/*
 * Decompiled with CFR 0.152.
 */
package hive.keycloak.app;

import hive.keycloak.app.AppCredentialProvider;
import hive.keycloak.app.AppRequiredActionFactory;
import hive.keycloak.app.AuthenticationUtil;
import hive.keycloak.app.actiontoken.AppAuthActionToken;
import hive.keycloak.app.credentials.AppCredentialData;
import hive.keycloak.app.dto.ChallengeConverter;
import hive.keycloak.app.jpa.Challenge;
import hive.keycloak.app.messaging.MessagingServiceFactory;
import hive.keycloak.app.rest.ChallengeResourceProvider;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.NonUniqueResultException;
import jakarta.persistence.TypedQuery;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.CredentialValidator;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.common.util.Base64;
import org.keycloak.common.util.SecretGenerator;
import org.keycloak.common.util.Time;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.device.DeviceRepresentationProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.jpa.entities.ClientEntity;
import org.keycloak.models.jpa.entities.RealmEntity;
import org.keycloak.models.jpa.entities.UserEntity;
import org.keycloak.representations.account.DeviceRepresentation;
import org.keycloak.services.Urls;
import org.keycloak.services.resource.RealmResourceProvider;
import org.keycloak.sessions.AuthenticationSessionCompoundId;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.util.JsonSerialization;

public class AppAuthenticator
implements Authenticator,
CredentialValidator<AppCredentialProvider> {
    private final Logger logger = Logger.getLogger(AppAuthenticator.class);
    private static final int SECRET_LENGTH = 501;
    public static final String APP_AUTH_GRANTED_NOTE = "appAuthGranted";

    public void authenticate(AuthenticationFlowContext context) {
        CredentialModel appCredentialModel = this.getSelectedAppCredential(context);
        if (appCredentialModel == null) {
            return;
        }
        this.createAppChallenge(context, appCredentialModel);
    }

    private void createAppChallenge(AuthenticationFlowContext context, CredentialModel appCredentialModel) {
        AppCredentialData appCredentialData;
        try {
            appCredentialData = (AppCredentialData)JsonSerialization.readValue((String)appCredentialModel.getCredentialData(), AppCredentialData.class);
        }
        catch (IOException e) {
            this.logger.error((Object)"App credential deserialization failed", (Throwable)e);
            Response challenge = context.form().setError("appAuthCriticalError", new Object[0]).createForm("app-login.ftl");
            context.challenge(challenge);
            return;
        }
        String secret = SecretGenerator.getInstance().randomString(501, SecretGenerator.ALPHANUM);
        AuthenticationSessionModel authSession = context.getAuthenticationSession();
        Map authConfig = context.getAuthenticatorConfig() != null ? context.getAuthenticatorConfig().getConfig() : Collections.emptyMap();
        long tokenExpiration = 60L;
        try {
            tokenExpiration = Long.parseLong(authConfig.getOrDefault("appAuthActionTokenExpiration", "60"));
        }
        catch (NumberFormatException e) {
            this.logger.warn((Object)"Invalid config for app auth action token expiration, falling back to default");
        }
        long expiresAt = (long)Time.currentTime() + tokenExpiration;
        AppAuthActionToken token = new AppAuthActionToken(context.getUser().getId(), (int)expiresAt, AuthenticationSessionCompoundId.fromAuthSession((AuthenticationSessionModel)authSession).getEncodedId(), authSession.getClient().getClientId());
        UriBuilder builder = Urls.actionTokenBuilder((URI)context.getUriInfo().getBaseUri(), (String)token.serialize(context.getSession(), context.getRealm(), context.getUriInfo()), (String)authSession.getClient().getClientId(), (String)authSession.getTabId(), (String)AuthenticationProcessor.getClientData((KeycloakSession)context.getSession(), (AuthenticationSessionModel)authSession));
        DeviceRepresentation deviceRepresentation = ((DeviceRepresentationProvider)context.getSession().getProvider(DeviceRepresentationProvider.class)).deviceRepresentation();
        try {
            Challenge challenge = this.upsertAppChallengeEntity(context, builder.build(new Object[]{context.getRealm().getName()}), deviceRepresentation, appCredentialData.getDeviceId(), secret, expiresAt);
            ChallengeResourceProvider challengeProvider = (ChallengeResourceProvider)context.getSession().getProvider(RealmResourceProvider.class, "challenges");
            challengeProvider.notifyListeners(challenge, context.getRealm());
            authSession.setAuthNote("credentialId", appCredentialModel.getId());
            authSession.setAuthNote("secret", secret);
            authSession.setAuthNote("timestamp", String.valueOf(challenge.getUpdatedTimestamp()));
            if (Boolean.parseBoolean(authConfig.getOrDefault("simulation", "false"))) {
                LinkedHashMap<String, String> signatureStringMap = new LinkedHashMap<String, String>();
                signatureStringMap.put("created", authSession.getAuthNote("timestamp"));
                signatureStringMap.put("secret", authSession.getAuthNote("secret"));
                signatureStringMap.put("granted", String.valueOf(true));
                this.logger.infov("App authentication signature string\n\n{0}\n", (Object)AuthenticationUtil.getSignatureString(signatureStringMap));
            }
            MessagingServiceFactory.get(authConfig).send(appCredentialData.getDevicePushId(), ChallengeConverter.getChallengeDto(challenge, context.getSession()));
            Response response = context.form().setAttribute("appAuthStatusUrl", (Object)String.format("/realms/%s/%s?%s", context.getRealm().getName(), "app-auth-status", context.getRefreshExecutionUrl().getQuery())).createForm("app-login.ftl");
            context.challenge(response);
        }
        catch (NonUniqueResultException e) {
            this.logger.error((Object)"App authentication init failed", (Throwable)e);
            Response challenge = context.form().setError("appAuthCriticalError", new Object[0]).createForm("app-login.ftl");
            context.challenge(challenge);
        }
    }

    private Challenge upsertAppChallengeEntity(AuthenticationFlowContext context, URI actionTokenUri, DeviceRepresentation deviceRepresentation, String deviceId, String encryptedSecret, long expiresAt) throws NonUniqueResultException {
        Challenge challenge;
        EntityManager em = this.getEntityManager(context.getSession());
        RealmEntity realm = (RealmEntity)em.getReference(RealmEntity.class, (Object)context.getRealm().getId());
        UserEntity user = (UserEntity)em.getReference(UserEntity.class, (Object)context.getUser().getId());
        ClientEntity client = (ClientEntity)em.getReference(ClientEntity.class, (Object)context.getAuthenticationSession().getClient().getId());
        try {
            TypedQuery query = em.createNamedQuery("Challenge.findByRealmAndDeviceId", Challenge.class);
            query.setParameter("realm", (Object)realm);
            query.setParameter("deviceId", (Object)deviceId);
            challenge = (Challenge)query.getSingleResult();
        }
        catch (NoResultException e) {
            challenge = new Challenge();
            challenge.setRealm(realm);
            challenge.setDeviceId(deviceId);
        }
        catch (NonUniqueResultException e) {
            this.logger.errorf((Throwable)e, "Failed to add app authenticator challenge for user [%s] device ID [%s]: duplicate challenge detected", (Object)context.getUser(), (Object)deviceId);
            throw e;
        }
        challenge.setUser(user);
        challenge.setSecret(encryptedSecret);
        challenge.setTargetUrl(actionTokenUri.toString());
        challenge.setDevice(deviceRepresentation.getDevice());
        challenge.setBrowser(deviceRepresentation.getBrowser());
        challenge.setOs(deviceRepresentation.getOs());
        challenge.setOsVersion(deviceRepresentation.getOsVersion());
        challenge.setIpAddress(deviceRepresentation.getIpAddress());
        challenge.setUpdatedTimestamp(Time.currentTimeMillis());
        challenge.setClient(client);
        challenge.setExpiresAt(expiresAt);
        em.persist((Object)challenge);
        em.flush();
        return challenge;
    }

    private EntityManager getEntityManager(KeycloakSession session) {
        return ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
    }

    private CredentialModel getSelectedAppCredential(AuthenticationFlowContext context) {
        CredentialModel appCredentialModel;
        AuthenticationSessionModel authSession = context.getAuthenticationSession();
        String credentialId = authSession.getAuthNote("selectedCredentialId");
        authSession.clearAuthNotes();
        if (credentialId == null) {
            List<CredentialModel> appCredentialModels = this.getCredentialProvider(context.getSession()).getAllCredentials(context.getUser());
            if (appCredentialModels.size() > 1) {
                authSession.setAuthNote("appCredentialSelection", "true");
                Response challenge = context.form().setAttribute("appCredentials", appCredentialModels).createForm("app-auth-selection.ftl");
                context.challenge(challenge);
                return null;
            }
            appCredentialModel = appCredentialModels.get(0);
        } else {
            appCredentialModel = this.getCredentialProvider(context.getSession()).getCredentialModel(context.getUser(), credentialId);
        }
        return appCredentialModel;
    }

    private String encryptSecretMessage(AppCredentialData credentialData, String secret) throws GeneralSecurityException, IOException {
        KeyFactory keyFactory = KeyFactory.getInstance(credentialData.getKeyAlgorithm());
        byte[] publicKeyBytes = Base64.decode((String)credentialData.getPublicKey());
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(publicKeyBytes);
        PublicKey publicKey = keyFactory.generatePublic(publicKeySpec);
        Cipher encryptCipher = Cipher.getInstance(credentialData.getKeyAlgorithm());
        encryptCipher.init(1, publicKey);
        byte[] encryptedMessage = encryptCipher.doFinal(secret.getBytes(StandardCharsets.UTF_8));
        return Base64.encodeBytes((byte[])encryptedMessage);
    }

    public void action(AuthenticationFlowContext context) {
        AuthenticationSessionModel authSession = context.getAuthenticationSession();
        if (Boolean.parseBoolean(authSession.getAuthNote("appCredentialSelection"))) {
            authSession.setAuthNote("selectedCredentialId", (String)context.getHttpRequest().getDecodedFormParameters().getFirst((Object)"app-credential"));
            CredentialModel appCredentialModel = this.getSelectedAppCredential(context);
            this.createAppChallenge(context, appCredentialModel);
            return;
        }
        String granted = authSession.getAuthNote(APP_AUTH_GRANTED_NOTE);
        String appAuthStatusUrl = String.format("/realms/%s/%s?%s", context.getRealm().getName(), "app-auth-status", context.getRefreshExecutionUrl().getQuery());
        if (granted == null) {
            Response challenge = context.form().setAttribute("appAuthStatusUrl", (Object)appAuthStatusUrl).setError("appAuthError", new Object[0]).createForm("app-login.ftl");
            context.challenge(challenge);
            return;
        }
        if (!Boolean.parseBoolean(granted)) {
            Response challenge = context.form().setError("appAuthRejected", new Object[0]).createForm("app-login.ftl");
            context.challenge(challenge);
            return;
        }
        context.success();
    }

    public boolean requiresUser() {
        return true;
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return this.getCredentialProvider(session).isConfiguredFor(realm, user, this.getType(session));
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
        user.addRequiredAction("app-register");
    }

    public void close() {
    }

    public AppCredentialProvider getCredentialProvider(KeycloakSession session) {
        return (AppCredentialProvider)session.getProvider(CredentialProvider.class, "app-credential");
    }

    public List<RequiredActionFactory> getRequiredActions(KeycloakSession session) {
        return Collections.singletonList((AppRequiredActionFactory)session.getKeycloakSessionFactory().getProviderFactory(RequiredActionProvider.class, "app-register"));
    }
}

