/*
 * Decompiled with CFR 0.152.
 */
package hive.keycloak.app;

import hive.keycloak.app.AppAuthenticator;
import java.util.Arrays;
import java.util.List;
import org.keycloak.Config;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;

public class AppAuthenticatorFactory
implements AuthenticatorFactory {
    public static final String PROVIDER_ID = "app-authenticator";
    private static final AppAuthenticator SINGLETON = new AppAuthenticator();
    private static final AuthenticationExecutionModel.Requirement[] REQUIREMENT_CHOICES = new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.REQUIRED, AuthenticationExecutionModel.Requirement.ALTERNATIVE, AuthenticationExecutionModel.Requirement.DISABLED};

    public String getDisplayType() {
        return "App Authenticator";
    }

    public String getReferenceCategory() {
        return "APP_CREDENTIAL";
    }

    public boolean isConfigurable() {
        return true;
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return REQUIREMENT_CHOICES;
    }

    public boolean isUserSetupAllowed() {
        return true;
    }

    public String getHelpText() {
        return "Authenticator to grant access by mobile app.";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        ProviderConfigProperty simulationMode = new ProviderConfigProperty("simulation", "Simulation Mode", "Logs app push notification instead of sending", "boolean", (Object)false);
        ProviderConfigProperty appAuthActionTokenExpiration = new ProviderConfigProperty("appAuthActionTokenExpiration", "App Auth Action Token expiration", "App Auth Action Token expiration time in seconds", "String", (Object)60);
        return Arrays.asList(simulationMode, appAuthActionTokenExpiration);
    }

    public Authenticator create(KeycloakSession keycloakSession) {
        return SINGLETON;
    }

    public void init(Config.Scope scope) {
    }

    public void postInit(KeycloakSessionFactory keycloakSessionFactory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }
}

