/*
 * Decompiled with CFR 0.152.
 */
package hive.keycloak.app;

import hive.keycloak.app.credentials.AppCredentialModel;
import java.util.List;
import java.util.stream.Collectors;
import org.keycloak.common.util.Time;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialInputValidator;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.credential.CredentialTypeMetadata;
import org.keycloak.credential.CredentialTypeMetadataContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;

public class AppCredentialProvider
implements CredentialProvider<AppCredentialModel>,
CredentialInputValidator {
    protected final KeycloakSession session;

    public AppCredentialProvider(KeycloakSession session) {
        this.session = session;
    }

    public String getType() {
        return "APP_CREDENTIAL";
    }

    public CredentialModel createCredential(RealmModel realm, UserModel user, AppCredentialModel appCredentialModel) {
        if (appCredentialModel.getCredentialData() == null) {
            appCredentialModel.setCreatedDate(Time.currentTimeMillis());
        }
        return user.credentialManager().createStoredCredential((CredentialModel)appCredentialModel);
    }

    public boolean deleteCredential(RealmModel realm, UserModel user, String credentialId) {
        return user.credentialManager().removeStoredCredentialById(credentialId);
    }

    public AppCredentialModel getCredentialFromModel(CredentialModel credentialModel) {
        return AppCredentialModel.createFromCredentialModel(credentialModel);
    }

    public CredentialTypeMetadata getCredentialTypeMetadata(CredentialTypeMetadataContext metadataContext) {
        return CredentialTypeMetadata.builder().type(this.getType()).category(CredentialTypeMetadata.Category.TWO_FACTOR).displayName("appAuthDisplayName").helpText("appAuthHelpText").iconCssClass("fa fa-mobile").createAction("app-register").removeable(true).build(this.session);
    }

    public boolean supportsCredentialType(String credentialType) {
        return this.getType().equals(credentialType);
    }

    public boolean isConfiguredFor(RealmModel realm, UserModel user, String credentialType) {
        if (!this.supportsCredentialType(credentialType)) {
            return false;
        }
        return user.credentialManager().getStoredCredentialsByTypeStream(credentialType).findAny().isPresent();
    }

    public boolean isValid(RealmModel realmModel, UserModel userModel, CredentialInput credentialInput) {
        return false;
    }

    public List<CredentialModel> getAllCredentials(UserModel user) {
        return user.credentialManager().getStoredCredentialsByTypeStream(this.getType()).collect(Collectors.toList());
    }

    public CredentialModel getCredentialModel(UserModel user, String credentialId) {
        return user.credentialManager().getStoredCredentialById(credentialId);
    }
}

