/*
 * Decompiled with CFR 0.152.
 */
package hive.keycloak.app;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import hive.keycloak.app.actiontoken.ActionTokenUtil;
import hive.keycloak.app.actiontoken.AppSetupActionToken;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import org.keycloak.authentication.CredentialRegistrator;
import org.keycloak.authentication.InitiatedActionSupport;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.common.util.Base64;
import org.keycloak.models.KeycloakSession;
import org.keycloak.sessions.AuthenticationSessionModel;

public class AppRequiredAction
implements RequiredActionProvider,
CredentialRegistrator {
    public static final String PROVIDER_ID = "app-register";

    public InitiatedActionSupport initiatedActionSupport() {
        return InitiatedActionSupport.SUPPORTED;
    }

    public void evaluateTriggers(RequiredActionContext requiredActionContext) {
    }

    public void requiredActionChallenge(RequiredActionContext context) {
        URI actionTokenUrl = ActionTokenUtil.createActionToken(AppSetupActionToken.class, context.getAuthenticationSession(), context.getSession(), context.getRealm(), context.getUser(), context.getUriInfo());
        Response challenge = context.form().setAttribute("appAuthQrCode", (Object)this.createQrCode(actionTokenUrl.toString())).setAttribute("appAuthActionTokenUrl", (Object)actionTokenUrl.toString()).setAttribute("appAuthStatusUrl", (Object)String.format("/realms/%s/%s?%s", context.getRealm().getName(), "app-auth-status", context.getActionUrl().getQuery())).createForm("app-auth-setup.ftl");
        context.challenge(challenge);
    }

    private String createQrCode(String uri) {
        try {
            int width = 400;
            int height = 400;
            QRCodeWriter writer = new QRCodeWriter();
            BitMatrix bitMatrix = writer.encode(uri, BarcodeFormat.QR_CODE, width, height);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"png", (OutputStream)bos);
            bos.close();
            return Base64.encodeBytes((byte[])bos.toByteArray());
        }
        catch (WriterException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void processAction(RequiredActionContext context) {
        AuthenticationSessionModel authSession = context.getAuthenticationSession();
        if (!Boolean.parseBoolean(authSession.getAuthNote("appSetupSuccessful"))) {
            URI actionTokenUrl = ActionTokenUtil.createActionToken(AppSetupActionToken.class, context.getAuthenticationSession(), context.getSession(), context.getRealm(), context.getUser(), context.getUriInfo());
            String errorMessage = Boolean.parseBoolean(authSession.getAuthNote("duplicateDeviceId")) ? "appAuthSetupDuplicate" : "appAuthSetupError";
            Response challenge = context.form().setAttribute("appAuthQrCode", (Object)this.createQrCode(actionTokenUrl.toString())).setAttribute("appAuthActionTokenUrl", (Object)actionTokenUrl.toString()).setAttribute("appAuthStatusUrl", (Object)String.format("/realms/%s/%s?%s", context.getRealm().getName(), "app-auth-status", context.getActionUrl().getQuery())).setError(errorMessage, new Object[0]).createForm("app-auth-setup.ftl");
            context.challenge(challenge);
            return;
        }
        context.success();
    }

    public void close() {
    }

    public String getCredentialType(KeycloakSession keycloakSession, AuthenticationSessionModel authenticationSessionModel) {
        return "APP_CREDENTIAL";
    }
}

