/*
 * Decompiled with CFR 0.152.
 */
package hive.keycloak.app;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import hive.keycloak.app.credentials.AppCredentialData;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.models.UserModel;

public class AuthenticationUtil {
    private static final Logger logger = Logger.getLogger(AuthenticationUtil.class);
    private static final Splitter.MapSplitter signatureMapSplitter = Splitter.on((String)",").withKeyValueSeparator(":");

    public static Map<String, String> getSignatureMap(List<String> signatureHeaders) {
        if (signatureHeaders.isEmpty()) {
            return null;
        }
        String signatureHeader = signatureHeaders.get(0);
        Map signatureMap = signatureMapSplitter.split((CharSequence)signatureHeader);
        if (!(signatureMap.containsKey("signature") && signatureMap.containsKey("keyId") && signatureMap.containsKey("created"))) {
            logger.warnf("Failed to parse signature header: header must at least contain keys: signature, keyId, created", new Object[0]);
            return null;
        }
        try {
            if (Long.parseLong((String)signatureMap.get("created")) > Time.currentTimeMillis() + 10000L) {
                logger.warnf("Failed to parse signature header: created is in the future device ID [%s]", signatureMap.get("keyId"));
                return null;
            }
        }
        catch (NumberFormatException e) {
            logger.warnf((Throwable)e, "Failed to parse signature header: created is not a parsable long device ID [%s]", signatureMap.get("keyId"));
            return null;
        }
        return signatureMap;
    }

    public static String getSignatureString(Map<String, String> signedData) {
        return Joiner.on((String)",").withKeyValueSeparator(":").join(signedData);
    }

    public static boolean verifyChallenge(UserModel user, AppCredentialData appCredentialData, String signedData, String signature) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(appCredentialData.getKeyAlgorithm());
            byte[] publicKeyBytes = Base64.decodeBase64((String)appCredentialData.getPublicKey());
            X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(publicKeyBytes);
            PublicKey publicKey = keyFactory.generatePublic(publicKeySpec);
            Signature sign = Signature.getInstance(appCredentialData.getSignatureAlgorithm());
            sign.initVerify(publicKey);
            sign.update(signedData.getBytes());
            if (!sign.verify(Base64.decodeBase64((String)signature))) {
                logger.warnv("App authentication rejected: invalid signature for user [{0}]", (Object)user.getUsername());
                return false;
            }
            return true;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException | InvalidKeySpecException e) {
            logger.warnf((Throwable)e, "App authentication rejected: signature verification failed for user: [%s], probably due to malformed signature or wrong algorithm", (Object)user.getUsername());
            return false;
        }
    }
}

