/*
 * Decompiled with CFR 0.152.
 */
package hive.keycloak.app.actiontoken;

import jakarta.ws.rs.core.UriInfo;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.authentication.actiontoken.DefaultActionToken;
import org.keycloak.common.util.Time;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.sessions.AuthenticationSessionCompoundId;
import org.keycloak.sessions.AuthenticationSessionModel;

public class ActionTokenUtil {
    private static final Logger logger = Logger.getLogger(ActionTokenUtil.class);

    public static AuthenticationSessionModel getOriginalAuthSession(KeycloakSession session, RealmModel realm, String originalAuthSessionId) {
        AuthenticationSessionManager asm = new AuthenticationSessionManager(session);
        AuthenticationSessionCompoundId compoundId = AuthenticationSessionCompoundId.encoded((String)originalAuthSessionId);
        ClientModel originalClient = realm.getClientById(compoundId.getClientUUID());
        return asm.getAuthenticationSessionByIdAndClient(realm, compoundId.getRootSessionId(), originalClient, compoundId.getTabId());
    }

    public static URI createActionToken(Class<?> actionTokenClass, AuthenticationSessionModel authSession, KeycloakSession session, RealmModel realm, UserModel user, UriInfo uriInfo) {
        try {
            String clientId = authSession.getClient().getClientId();
            DefaultActionToken token = (DefaultActionToken)actionTokenClass.getDeclaredConstructor(String.class, Integer.class, String.class, String.class).newInstance(user.getId(), Time.currentTime() + realm.getActionTokenGeneratedByUserLifespan(), AuthenticationSessionCompoundId.fromAuthSession((AuthenticationSessionModel)authSession).getEncodedId(), clientId);
            return Urls.actionTokenBuilder((URI)uriInfo.getBaseUri(), (String)token.serialize(session, realm, uriInfo), (String)clientId, (String)authSession.getTabId(), (String)AuthenticationProcessor.getClientData((KeycloakSession)session, (AuthenticationSessionModel)authSession)).build(new Object[]{realm.getName()});
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

