/*
 * Decompiled with CFR 0.152.
 */
package hive.keycloak.app.actiontoken;

import hive.keycloak.app.AppCredentialProvider;
import hive.keycloak.app.AuthenticationUtil;
import hive.keycloak.app.actiontoken.ActionTokenUtil;
import hive.keycloak.app.actiontoken.AppAuthActionToken;
import hive.keycloak.app.credentials.AppCredentialData;
import hive.keycloak.app.credentials.AppCredentialModel;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceException;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.authentication.actiontoken.AbstractActionTokenHandler;
import org.keycloak.authentication.actiontoken.ActionTokenContext;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.events.EventType;
import org.keycloak.models.jpa.entities.RealmEntity;
import org.keycloak.sessions.AuthenticationSessionModel;

public class AppAuthActionTokenHandler
extends AbstractActionTokenHandler<AppAuthActionToken> {
    private final Logger logger = Logger.getLogger(AppAuthActionTokenHandler.class);

    public AppAuthActionTokenHandler() {
        super("app-auth-action-token", AppAuthActionToken.class, "invalidRequestMessage", EventType.EXECUTE_ACTION_TOKEN, "invalid_request");
    }

    public Response handleToken(AppAuthActionToken token, ActionTokenContext<AppAuthActionToken> tokenContext) {
        MultivaluedMap queryParameters = tokenContext.getRequest().getUri().getQueryParameters();
        String granted = (String)queryParameters.getFirst((Object)"granted");
        AuthenticationSessionModel authSession = ActionTokenUtil.getOriginalAuthSession(tokenContext.getSession(), tokenContext.getRealm(), token.getOriginalAuthenticationSessionId());
        if (authSession == null) {
            this.logger.errorf("App Authentication rejected: Auth session not found for user [%s]", (Object)token.getUserId());
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        String authSessionGranted = authSession.getAuthNote("appAuthGranted");
        if (authSessionGranted != null && !Boolean.parseBoolean(authSessionGranted)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (granted == null) {
            this.logger.warnf("App authentication rejected: missing query param \"granted\" for user ID [%s]", (Object)token.getUserId());
            authSession.setAuthNote("appAuthReady", Boolean.toString(true));
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Map<String, String> signatureMap = AuthenticationUtil.getSignatureMap(tokenContext.getRequest().getHttpHeaders().getRequestHeader("Signature"));
        if (signatureMap == null) {
            this.logger.warnf("App authentication rejected: missing or incomplete signature header for user ID [%s]", (Object)token.getUserId());
            authSession.setAuthNote("appAuthReady", Boolean.toString(true));
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        AppCredentialProvider appCredentialProvider = (AppCredentialProvider)tokenContext.getSession().getProvider(CredentialProvider.class, "app-credential");
        CredentialModel appCredentialModel = appCredentialProvider.getCredentialModel(authSession.getAuthenticatedUser(), authSession.getAuthNote("credentialId"));
        AppCredentialData appCredentialData = AppCredentialModel.createFromCredentialModel(appCredentialModel).getAppCredentialData();
        HashMap<String, String> signatureStringMap = new HashMap<String, String>();
        signatureStringMap.put("created", authSession.getAuthNote("timestamp"));
        signatureStringMap.put("secret", authSession.getAuthNote("secret"));
        signatureStringMap.put("granted", granted);
        boolean verified = AuthenticationUtil.verifyChallenge(authSession.getAuthenticatedUser(), appCredentialData, AuthenticationUtil.getSignatureString(signatureStringMap), signatureMap.get("signature"));
        if (!verified) {
            authSession.setAuthNote("appAuthReady", Boolean.toString(true));
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (!Boolean.parseBoolean(granted)) {
            authSession.setAuthNote("appAuthGranted", Boolean.toString(false));
        } else {
            authSession.setAuthNote("appAuthGranted", Boolean.toString(true));
        }
        authSession.setAuthNote("appAuthReady", Boolean.toString(true));
        try {
            EntityManager em = ((JpaConnectionProvider)tokenContext.getSession().getProvider(JpaConnectionProvider.class)).getEntityManager();
            RealmEntity realm = (RealmEntity)em.getReference(RealmEntity.class, (Object)tokenContext.getRealm().getId());
            em.createNamedQuery("Challenge.deleteByRealmAndDeviceId").setParameter("realm", (Object)realm).setParameter("deviceId", (Object)appCredentialData.getDeviceId()).executeUpdate();
        }
        catch (PersistenceException e) {
            this.logger.error((Object)String.format("Failed to delete challenge for device ID %s", appCredentialData.getDeviceId()), (Throwable)e);
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    public boolean canUseTokenRepeatedly(AppAuthActionToken token, ActionTokenContext<AppAuthActionToken> tokenContext) {
        return false;
    }
}

