/*
 * Decompiled with CFR 0.152.
 */
package hive.keycloak.app.actiontoken;

import hive.keycloak.app.actiontoken.ActionTokenUtil;
import hive.keycloak.app.actiontoken.AppSetupActionToken;
import hive.keycloak.app.credentials.AppCredentialModel;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import org.keycloak.authentication.actiontoken.AbstractActionTokenHandler;
import org.keycloak.authentication.actiontoken.ActionTokenContext;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.events.EventType;
import org.keycloak.models.UserModel;
import org.keycloak.sessions.AuthenticationSessionModel;

public class AppSetupActionTokenHandler
extends AbstractActionTokenHandler<AppSetupActionToken> {
    public AppSetupActionTokenHandler() {
        super("app-setup-action-token", AppSetupActionToken.class, "invalidRequestMessage", EventType.EXECUTE_ACTION_TOKEN, "invalid_request");
    }

    public Response handleToken(AppSetupActionToken token, ActionTokenContext<AppSetupActionToken> tokenContext) {
        MultivaluedMap queryParameters = tokenContext.getRequest().getUri().getQueryParameters();
        String deviceId = (String)queryParameters.getFirst((Object)"device_id");
        String deviceOs = (String)queryParameters.getFirst((Object)"device_os");
        String publicKey = (String)queryParameters.getFirst((Object)"public_key");
        String keyAlgorithm = (String)queryParameters.getFirst((Object)"key_algorithm");
        String signatureAlgorithm = (String)queryParameters.getFirst((Object)"signature_algorithm");
        String devicePushId = (String)queryParameters.getFirst((Object)"device_push_id");
        if (deviceId == null || deviceOs == null || publicKey == null || keyAlgorithm == null || signatureAlgorithm == null) {
            return Response.status((int)400).build();
        }
        UserModel user = tokenContext.getAuthenticationSession().getAuthenticatedUser();
        long count = user.credentialManager().getStoredCredentialsByTypeStream("APP_CREDENTIAL").map(AppCredentialModel::createFromCredentialModel).filter(c -> c.getAppCredentialData().getDeviceId().equals(deviceId)).count();
        AuthenticationSessionModel authSession = ActionTokenUtil.getOriginalAuthSession(tokenContext.getSession(), tokenContext.getRealm(), token.getOriginalAuthenticationSessionId());
        if (authSession == null) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (count > 0L) {
            authSession.setAuthNote("duplicateDeviceId", Boolean.toString(true));
            authSession.setAuthNote("appAuthReady", Boolean.toString(true));
            return Response.status((int)400).build();
        }
        CredentialProvider appCredentialProvider = (CredentialProvider)tokenContext.getSession().getProvider(CredentialProvider.class, "app-credential");
        appCredentialProvider.createCredential(tokenContext.getRealm(), user, (CredentialModel)AppCredentialModel.createAppCredential(publicKey, deviceId, deviceOs, keyAlgorithm, signatureAlgorithm, devicePushId));
        authSession.setAuthNote("appSetupSuccessful", Boolean.toString(true));
        authSession.setAuthNote("appAuthReady", Boolean.toString(true));
        return Response.status((int)201).build();
    }

    public boolean canUseTokenRepeatedly(AppSetupActionToken token, ActionTokenContext<AppSetupActionToken> tokenContext) {
        return false;
    }
}

