/*
 * Decompiled with CFR 0.152.
 */
package hive.keycloak.app.messaging;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.firebase.messaging.FirebaseMessagingException;
import com.google.firebase.messaging.Message;
import hive.keycloak.app.dto.ChallengeDto;
import hive.keycloak.app.messaging.MessagingService;
import java.util.Map;
import org.jboss.logging.Logger;

public class FcmMessagingService
implements MessagingService {
    private final Logger logger = Logger.getLogger(FcmMessagingService.class);
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public void send(String devicePushId, ChallengeDto challenge) {
        if (devicePushId == null) {
            this.logger.infof("Skip sending firebase notification: missing device push ID user [%s]", (Object)challenge.getUserName());
            return;
        }
        Map challengeMap = (Map)this.objectMapper.convertValue((Object)challenge, Map.class);
        Message message = Message.builder().putAllData(challengeMap).setToken(devicePushId).build();
        try {
            String response = FirebaseMessaging.getInstance().send(message);
            this.logger.debugv("Successfully sent message: ", (Object)response);
        }
        catch (FirebaseMessagingException e) {
            this.logger.error((Object)"Failed to send firebase app notification", (Throwable)e);
        }
    }
}

