/*
 * Decompiled with CFR 0.152.
 */
package hive.keycloak.app.rest;

import hive.keycloak.app.AuthenticationUtil;
import hive.keycloak.app.credentials.AppCredentialModel;
import hive.keycloak.app.dto.ChallengeConverter;
import hive.keycloak.app.dto.ChallengeDto;
import hive.keycloak.app.jpa.Challenge;
import hive.keycloak.app.rest.DeviceConnection;
import hive.keycloak.app.rest.Message;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.NonUniqueResultException;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Base64;
import org.keycloak.common.util.Time;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.credential.CredentialModel;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.jpa.entities.CredentialEntity;
import org.keycloak.models.jpa.entities.RealmEntity;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.services.resource.RealmResourceProvider;

public class ChallengeResourceProvider
implements RealmResourceProvider {
    private final KeycloakSession session;
    private final EntityManager em;
    private final Logger logger = Logger.getLogger(ChallengeResourceProvider.class);
    private final KeycloakSessionFactory sessionFactory;
    private static final ConcurrentHashMap<String, DeviceConnection> listeners = new ConcurrentHashMap();
    public static final ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(1);
    public static final String CHALLENGE_REJECTED = "challenge_rejected";
    public static final String CHALLENGE_EXPIRED = "challenge_expired";
    public static final String INTERNAL_ERROR = "internal_error";
    public static final String NO_CREDENTIAL = "no_credential";
    private static final long EXPIRATION_TIME = 120L;
    private static final long RESPONSE_TIMEOUT = 60L;

    public ChallengeResourceProvider(KeycloakSession session) {
        this.session = session;
        this.em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
        this.sessionFactory = session.getKeycloakSessionFactory();
    }

    public Object getResource() {
        return this;
    }

    public void close() {
    }

    @GET
    @Produces(value={"application/json"})
    public Response getChallenges(@HeaderParam(value="Signature") List<String> signatureHeader) {
        Map<String, String> signatureMap = AuthenticationUtil.getSignatureMap(signatureHeader);
        return this.getChallengesResponse(signatureMap);
    }

    private Response getChallengesResponse(Map<String, String> signatureMap) {
        Challenge challenge;
        CredentialEntity credentialEntity;
        if (signatureMap == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new Message(CHALLENGE_REJECTED, "Missing, incomplete or invalid signature header")).build();
        }
        String deviceId = signatureMap.get("keyId");
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery criteria = cb.createQuery(CredentialEntity.class);
        Root root = criteria.from(CredentialEntity.class);
        criteria.where(new Predicate[]{cb.equal((Expression)root.get("type"), (Object)"APP_CREDENTIAL"), cb.like((Expression)root.get("credentialData"), String.format("%%\"deviceId\":\"%s\"%%", deviceId))});
        TypedQuery criteriaQuery = this.em.createQuery(criteria);
        try {
            credentialEntity = (CredentialEntity)criteriaQuery.getSingleResult();
        }
        catch (NoResultException e) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)new Message(NO_CREDENTIAL, "App credential does not exist")).build();
        }
        catch (NonUniqueResultException e) {
            this.logger.error((Object)("Failed to get app credentials: duplicate credentials detected for device ID: " + deviceId), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new Message(INTERNAL_ERROR, "Internal server error")).build();
        }
        AppCredentialModel appCredential = AppCredentialModel.createFromCredentialModel(this.toModel(credentialEntity));
        UserModel user = this.session.users().getUserById(this.session.getContext().getRealm(), credentialEntity.getUser().getId());
        LinkedHashMap<String, String> signatureStringMap = new LinkedHashMap<String, String>();
        signatureStringMap.put("created", signatureMap.get("created"));
        boolean verified = AuthenticationUtil.verifyChallenge(user, appCredential.getAppCredentialData(), AuthenticationUtil.getSignatureString(signatureStringMap), signatureMap.get("signature"));
        if (!verified) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new Message(CHALLENGE_REJECTED, "Invalid signature")).build();
        }
        TypedQuery query = this.em.createNamedQuery("Challenge.findByRealmAndDeviceId", Challenge.class);
        RealmEntity realm = (RealmEntity)this.em.getReference(RealmEntity.class, (Object)this.session.getContext().getRealm().getId());
        query.setParameter("realm", (Object)realm);
        query.setParameter("deviceId", (Object)deviceId);
        try {
            challenge = (Challenge)query.getSingleResult();
        }
        catch (NoResultException e) {
            return Response.status((Response.Status)Response.Status.OK).entity(Collections.emptyList()).build();
        }
        catch (NonUniqueResultException e) {
            this.logger.error((Object)("Failed to get app authenticator challenge: duplicate challenge detected for device ID: " + deviceId), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new Message(INTERNAL_ERROR, "Internal server error")).build();
        }
        catch (Throwable e) {
            this.logger.error((Object)("Failed to get app authenticator challenge for device ID: " + deviceId), e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new Message(INTERNAL_ERROR, "Internal server error")).build();
        }
        if ((long)Time.currentTime() > challenge.getExpiresAt() || Long.parseLong(signatureMap.get("created")) < challenge.getUpdatedTimestamp() - 1000L) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new Message(CHALLENGE_EXPIRED, "Challenge expired")).build();
        }
        return Response.ok(List.of(ChallengeConverter.getChallengeDto(challenge, this.session))).build();
    }

    CredentialModel toModel(CredentialEntity entity) {
        CredentialModel model = new CredentialModel();
        model.setId(entity.getId());
        model.setType(entity.getType());
        model.setCreatedDate(entity.getCreatedDate());
        model.setUserLabel(entity.getUserLabel());
        if (entity.getSalt() != null) {
            String newSecretData = entity.getSecretData().replace("__SALT__", Base64.encodeBytes((byte[])entity.getSalt()));
            entity.setSecretData(newSecretData);
            entity.setSalt(null);
        }
        model.setSecretData(entity.getSecretData());
        model.setCredentialData(entity.getCredentialData());
        return model;
    }

    @GET
    @Path(value="async")
    @Produces(value={"application/json"})
    public void getChallengesAsync(@HeaderParam(value="Signature") List<String> signatureHeader, @Suspended AsyncResponse asyncResponse) {
        Map<String, String> signatureMap = AuthenticationUtil.getSignatureMap(signatureHeader);
        Response response = this.getChallengesResponse(signatureMap);
        if (!response.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
            if (response.getStatus() != 403) {
                asyncResponse.resume((Object)response);
                return;
            }
            Message message = (Message)response.readEntity(Message.class);
            if (!message.error().equals(CHALLENGE_EXPIRED)) {
                asyncResponse.resume((Object)response);
                return;
            }
        } else {
            List challenges = (List)response.readEntity((GenericType)new GenericType<List<ChallengeDto>>(){});
            if (!challenges.isEmpty()) {
                asyncResponse.resume((Object)response);
                return;
            }
        }
        String deviceId = signatureMap.get("keyId");
        asyncResponse.setTimeout(60L, TimeUnit.SECONDS);
        ScheduledFuture<?> evictionJob = scheduler.schedule(() -> listeners.remove(deviceId), 120L, TimeUnit.SECONDS);
        DeviceConnection existingConnection = listeners.get(deviceId);
        if (existingConnection != null) {
            existingConnection.evictionJob().cancel(false);
            existingConnection.asyncResponse().cancel();
        }
        listeners.put(deviceId, new DeviceConnection(asyncResponse, evictionJob));
    }

    public void notifyListeners(Challenge challenge, RealmModel realm) {
        AsyncResponse asyncResponse;
        String deviceId = challenge.getDeviceId();
        DeviceConnection deviceConnection = listeners.get(deviceId);
        if (deviceConnection != null && (asyncResponse = deviceConnection.asyncResponse()) != null) {
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.sessionFactory, session -> {
                KeycloakContext context = session.getContext();
                context.setRealm(realm);
                asyncResponse.resume((Object)Response.ok(List.of(ChallengeConverter.getChallengeDto(challenge, session))).build());
            });
        }
    }
}

