/*
 * Decompiled with CFR 0.152.
 */
package hive.keycloak.app.rest;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.sse.Sse;
import jakarta.ws.rs.sse.SseEventSink;
import org.jboss.logging.Logger;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.services.resource.RealmResourceProvider;
import org.keycloak.sessions.AuthenticationSessionModel;

public class StatusResourceProvider
implements RealmResourceProvider {
    private final KeycloakSession session;
    private final Logger logger = Logger.getLogger(StatusResourceProvider.class);
    public static final String READY = "appAuthReady";
    private static final String UNAUTHORIZED = "Unauthorized";

    public StatusResourceProvider(KeycloakSession session) {
        this.session = session;
    }

    public Object getResource() {
        return this;
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"text/event-stream"})
    public void getAppAuthStatus(@Context SseEventSink sseEventSink, @Context Sse sse, @QueryParam(value="client_id") String clientId, @QueryParam(value="tab_id") String tabId) throws InterruptedException {
        RealmModel realm = this.session.getContext().getRealm();
        ClientModel client = null;
        if (clientId != null) {
            client = realm.getClientByClientId(clientId);
        }
        AuthenticationSessionManager authSessionManager = new AuthenticationSessionManager(this.session);
        int counter = 0;
        while (true) {
            AuthenticationSessionModel authSession;
            if ((authSession = authSessionManager.getCurrentAuthenticationSession(realm, client, tabId)) == null) {
                throw new NotAuthorizedException((Object)UNAUTHORIZED, new Object[0]);
            }
            UserModel user = authSession.getAuthenticatedUser();
            if (authSession.getAuthNote(READY) != null) {
                authSession.setAuthNote(READY, null);
                try {
                    try {
                        sseEventSink.send(sse.newEvent("ready")).toCompletableFuture().get();
                    }
                    catch (Exception e) {
                        this.logger.errorf((Throwable)e, "Failed to send authentication status for user %s", (Object)(user == null ? "null" : user.getId()));
                    }
                }
                catch (Throwable throwable) {}
                break;
            }
            if (counter++ % 4 == 0) {
                try {
                    sseEventSink.send(sse.newEvent("keep-alive")).toCompletableFuture().get();
                }
                catch (Exception e) {
                    this.logger.infof((Throwable)e, "Failed to send keep alive message for user %s", (Object)(user == null ? "null" : user.getId()));
                    break;
                }
            }
            Thread.sleep(1000L);
        }
        sseEventSink.close();
    }
}

