/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.httpjson.HttpJsonCallOptions;
import com.google.api.gax.httpjson.HttpJsonChannel;
import com.google.api.gax.httpjson.HttpJsonStatusCode;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.EndpointContext;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.internal.ApiCallContextOptions;
import com.google.api.gax.rpc.internal.Headers;
import com.google.api.gax.tracing.ApiTracer;
import com.google.api.gax.tracing.BaseApiTracer;
import com.google.api.gax.util.TimeConversionUtils;
import com.google.auth.Credentials;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.threeten.bp.Duration;
import org.threeten.bp.Instant;

public final class HttpJsonCallContext
implements ApiCallContext {
    private static final HttpJsonStatusCode UNAUTHENTICATED_STATUS_CODE = HttpJsonStatusCode.of(StatusCode.Code.UNAUTHENTICATED);
    private final HttpJsonChannel channel;
    private final HttpJsonCallOptions callOptions;
    @Nullable
    private final java.time.Duration timeout;
    @Nullable
    private final java.time.Duration streamWaitTimeout;
    @Nullable
    private final java.time.Duration streamIdleTimeout;
    private final ImmutableMap<String, List<String>> extraHeaders;
    private final ApiCallContextOptions options;
    private final ApiTracer tracer;
    @Nullable
    private final RetrySettings retrySettings;
    @Nullable
    private final ImmutableSet<StatusCode.Code> retryableCodes;
    private final EndpointContext endpointContext;

    public static HttpJsonCallContext createDefault() {
        return new HttpJsonCallContext(null, HttpJsonCallOptions.newBuilder().build(), null, null, null, ImmutableMap.of(), ApiCallContextOptions.getDefaultOptions(), null, null, null, null);
    }

    public static HttpJsonCallContext of(HttpJsonChannel channel, HttpJsonCallOptions options) {
        return new HttpJsonCallContext(channel, options, null, null, null, ImmutableMap.of(), ApiCallContextOptions.getDefaultOptions(), null, null, null, null);
    }

    private HttpJsonCallContext(HttpJsonChannel channel, HttpJsonCallOptions callOptions, java.time.Duration timeout, java.time.Duration streamWaitTimeout, java.time.Duration streamIdleTimeout, ImmutableMap<String, List<String>> extraHeaders, ApiCallContextOptions options, ApiTracer tracer, RetrySettings defaultRetrySettings, Set<StatusCode.Code> defaultRetryableCodes, @Nullable EndpointContext endpointContext) {
        this.channel = channel;
        this.callOptions = callOptions;
        this.timeout = timeout;
        this.streamWaitTimeout = streamWaitTimeout;
        this.streamIdleTimeout = streamIdleTimeout;
        this.extraHeaders = extraHeaders;
        this.options = options;
        this.tracer = tracer;
        this.retrySettings = defaultRetrySettings;
        this.retryableCodes = defaultRetryableCodes == null ? null : ImmutableSet.copyOf(defaultRetryableCodes);
        this.endpointContext = endpointContext == null ? EndpointContext.getDefaultInstance() : endpointContext;
    }

    @Override
    public HttpJsonCallContext nullToSelf(ApiCallContext inputContext) {
        HttpJsonCallContext httpJsonCallContext;
        if (inputContext == null) {
            httpJsonCallContext = this;
        } else {
            if (!(inputContext instanceof HttpJsonCallContext)) {
                throw new IllegalArgumentException("context must be an instance of HttpJsonCallContext, but found " + inputContext.getClass().getName());
            }
            httpJsonCallContext = (HttpJsonCallContext)inputContext;
        }
        return httpJsonCallContext;
    }

    @Override
    public HttpJsonCallContext merge(ApiCallContext inputCallContext) {
        ImmutableSet<StatusCode.Code> newRetryableCodes;
        RetrySettings newRetrySettings;
        java.time.Duration newStreamIdleTimeout;
        java.time.Duration newStreamWaitTimeout;
        if (inputCallContext == null) {
            return this;
        }
        if (!(inputCallContext instanceof HttpJsonCallContext)) {
            throw new IllegalArgumentException("context must be an instance of HttpJsonCallContext, but found " + inputCallContext.getClass().getName());
        }
        HttpJsonCallContext httpJsonCallContext = (HttpJsonCallContext)inputCallContext;
        HttpJsonChannel newChannel = httpJsonCallContext.channel;
        if (newChannel == null) {
            newChannel = this.channel;
        }
        HttpJsonCallOptions newCallOptions = this.callOptions.merge(httpJsonCallContext.callOptions);
        java.time.Duration newTimeout = httpJsonCallContext.timeout;
        if (newTimeout == null) {
            newTimeout = this.timeout;
        }
        if ((newStreamWaitTimeout = httpJsonCallContext.streamWaitTimeout) == null) {
            newStreamWaitTimeout = this.streamWaitTimeout;
        }
        if ((newStreamIdleTimeout = httpJsonCallContext.streamIdleTimeout) == null) {
            newStreamIdleTimeout = this.streamIdleTimeout;
        }
        ImmutableMap<String, List<String>> newExtraHeaders = Headers.mergeHeaders(this.extraHeaders, httpJsonCallContext.extraHeaders);
        ApiCallContextOptions newOptions = this.options.merge(httpJsonCallContext.options);
        ApiTracer newTracer = httpJsonCallContext.tracer;
        if (newTracer == null) {
            newTracer = this.tracer;
        }
        if ((newRetrySettings = httpJsonCallContext.retrySettings) == null) {
            newRetrySettings = this.retrySettings;
        }
        if ((newRetryableCodes = httpJsonCallContext.retryableCodes) == null) {
            newRetryableCodes = this.retryableCodes;
        }
        return new HttpJsonCallContext(newChannel, newCallOptions, newTimeout, newStreamWaitTimeout, newStreamIdleTimeout, newExtraHeaders, newOptions, newTracer, newRetrySettings, newRetryableCodes, this.endpointContext);
    }

    @Override
    public HttpJsonCallContext withCredentials(Credentials newCredentials) {
        HttpJsonCallOptions.Builder builder = this.callOptions != null ? this.callOptions.toBuilder() : HttpJsonCallOptions.newBuilder();
        return this.withCallOptions(builder.setCredentials(newCredentials).build());
    }

    @Override
    public HttpJsonCallContext withTransportChannel(TransportChannel inputChannel) {
        Preconditions.checkNotNull(inputChannel);
        if (!(inputChannel instanceof HttpJsonTransportChannel)) {
            throw new IllegalArgumentException("Expected HttpJsonTransportChannel, got " + inputChannel.getClass().getName());
        }
        HttpJsonTransportChannel transportChannel = (HttpJsonTransportChannel)inputChannel;
        return this.withChannel(transportChannel.getChannel());
    }

    @Override
    @ObsoleteApi(value="Use withTimeoutDuration(java.time.Duration) instead")
    public HttpJsonCallContext withTimeout(Duration timeout) {
        return this.withTimeoutDuration(TimeConversionUtils.toJavaTimeDuration(timeout));
    }

    @Override
    public HttpJsonCallContext withEndpointContext(EndpointContext endpointContext) {
        Preconditions.checkNotNull(endpointContext);
        return new HttpJsonCallContext(this.channel, this.callOptions, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.extraHeaders, this.options, this.tracer, this.retrySettings, this.retryableCodes, endpointContext);
    }

    @Override
    public HttpJsonCallContext withTimeoutDuration(java.time.Duration timeout) {
        if (timeout != null && (timeout.isZero() || timeout.isNegative())) {
            timeout = null;
        }
        if (timeout != null && this.timeout != null && this.timeout.compareTo(timeout) <= 0) {
            return this;
        }
        return new HttpJsonCallContext(this.channel, this.callOptions, timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.extraHeaders, this.options, this.tracer, this.retrySettings, this.retryableCodes, this.endpointContext);
    }

    @Override
    @Nullable
    @ObsoleteApi(value="Use getTimeoutDuration instead")
    public Duration getTimeout() {
        return TimeConversionUtils.toThreetenDuration(this.getTimeoutDuration());
    }

    @Override
    @Nullable
    public java.time.Duration getTimeoutDuration() {
        return this.timeout;
    }

    @Override
    @ObsoleteApi(value="Use withStreamWaitTimeoutDuration(java.time.Duration) instead")
    public HttpJsonCallContext withStreamWaitTimeout(@Nullable Duration streamWaitTimeout) {
        return this.withStreamWaitTimeoutDuration(TimeConversionUtils.toJavaTimeDuration(streamWaitTimeout));
    }

    @Override
    public HttpJsonCallContext withStreamWaitTimeoutDuration(@Nullable java.time.Duration streamWaitTimeout) {
        if (streamWaitTimeout != null) {
            Preconditions.checkArgument(streamWaitTimeout.compareTo(java.time.Duration.ZERO) >= 0, "Invalid timeout: < 0 s");
        }
        return new HttpJsonCallContext(this.channel, this.callOptions, this.timeout, streamWaitTimeout, this.streamIdleTimeout, this.extraHeaders, this.options, this.tracer, this.retrySettings, this.retryableCodes, this.endpointContext);
    }

    @Override
    @Nullable
    @ObsoleteApi(value="Use getStreamWaitTimeoutDuration() instead")
    public Duration getStreamWaitTimeout() {
        return TimeConversionUtils.toThreetenDuration(this.getStreamWaitTimeoutDuration());
    }

    @Override
    @Nullable
    public java.time.Duration getStreamWaitTimeoutDuration() {
        return this.streamWaitTimeout;
    }

    @Override
    @ObsoleteApi(value="Use withStreamIdleTimeoutDuration(java.time.Duration) instead")
    public HttpJsonCallContext withStreamIdleTimeout(@Nullable Duration streamIdleTimeout) {
        return this.withStreamIdleTimeoutDuration(TimeConversionUtils.toJavaTimeDuration(streamIdleTimeout));
    }

    @Override
    public HttpJsonCallContext withStreamIdleTimeoutDuration(@Nullable java.time.Duration streamIdleTimeout) {
        if (streamIdleTimeout != null) {
            Preconditions.checkArgument(streamIdleTimeout.compareTo(java.time.Duration.ZERO) >= 0, "Invalid timeout: < 0 s");
        }
        return new HttpJsonCallContext(this.channel, this.callOptions, this.timeout, this.streamWaitTimeout, streamIdleTimeout, this.extraHeaders, this.options, this.tracer, this.retrySettings, this.retryableCodes, this.endpointContext);
    }

    @Override
    @Nullable
    @ObsoleteApi(value="Use getStreamIdleTimeoutDuration() instead")
    public Duration getStreamIdleTimeout() {
        return TimeConversionUtils.toThreetenDuration(this.getStreamIdleTimeoutDuration());
    }

    @Override
    @Nullable
    public java.time.Duration getStreamIdleTimeoutDuration() {
        return this.streamIdleTimeout;
    }

    @Override
    @BetaApi(value="The surface for extra headers is not stable yet and may change in the future.")
    public ApiCallContext withExtraHeaders(Map<String, List<String>> extraHeaders) {
        Preconditions.checkNotNull(extraHeaders);
        ImmutableMap<String, List<String>> newExtraHeaders = Headers.mergeHeaders(this.extraHeaders, extraHeaders);
        return new HttpJsonCallContext(this.channel, this.callOptions, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, newExtraHeaders, this.options, this.tracer, this.retrySettings, this.retryableCodes, this.endpointContext);
    }

    @Override
    @BetaApi(value="The surface for extra headers is not stable yet and may change in the future.")
    public Map<String, List<String>> getExtraHeaders() {
        return this.extraHeaders;
    }

    @Override
    public <T> ApiCallContext withOption(ApiCallContext.Key<T> key, T value) {
        ApiCallContextOptions newOptions = this.options.withOption(key, value);
        return new HttpJsonCallContext(this.channel, this.callOptions, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.extraHeaders, newOptions, this.tracer, this.retrySettings, this.retryableCodes, this.endpointContext);
    }

    @Override
    public <T> T getOption(ApiCallContext.Key<T> key) {
        return this.options.getOption(key);
    }

    @InternalApi
    public void validateUniverseDomain() {
        try {
            this.endpointContext.validateUniverseDomain(this.getCallOptions().getCredentials(), UNAUTHENTICATED_STATUS_CODE);
        }
        catch (IOException e) {
            throw ApiExceptionFactory.createException("Unable to retrieve the Universe Domain from the Credentials.", e, UNAUTHENTICATED_STATUS_CODE, false);
        }
    }

    public HttpJsonChannel getChannel() {
        return this.channel;
    }

    public HttpJsonCallOptions getCallOptions() {
        return this.callOptions;
    }

    @Deprecated
    @Nullable
    public Instant getDeadline() {
        return this.getCallOptions() != null ? this.getCallOptions().getDeadline() : null;
    }

    @Deprecated
    @Nullable
    public Credentials getCredentials() {
        return this.getCallOptions() != null ? this.getCallOptions().getCredentials() : null;
    }

    @Override
    public RetrySettings getRetrySettings() {
        return this.retrySettings;
    }

    @Override
    public HttpJsonCallContext withRetrySettings(RetrySettings retrySettings) {
        return new HttpJsonCallContext(this.channel, this.callOptions, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.extraHeaders, this.options, this.tracer, retrySettings, this.retryableCodes, this.endpointContext);
    }

    @Override
    public Set<StatusCode.Code> getRetryableCodes() {
        return this.retryableCodes;
    }

    @Override
    public HttpJsonCallContext withRetryableCodes(Set<StatusCode.Code> retryableCodes) {
        return new HttpJsonCallContext(this.channel, this.callOptions, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.extraHeaders, this.options, this.tracer, this.retrySettings, retryableCodes, this.endpointContext);
    }

    public HttpJsonCallContext withChannel(HttpJsonChannel newChannel) {
        return new HttpJsonCallContext(newChannel, this.callOptions, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.extraHeaders, this.options, this.tracer, this.retrySettings, this.retryableCodes, this.endpointContext);
    }

    public HttpJsonCallContext withCallOptions(HttpJsonCallOptions newCallOptions) {
        return new HttpJsonCallContext(this.channel, newCallOptions, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.extraHeaders, this.options, this.tracer, this.retrySettings, this.retryableCodes, this.endpointContext);
    }

    @Deprecated
    public HttpJsonCallContext withDeadline(Instant newDeadline) {
        HttpJsonCallOptions.Builder builder = this.callOptions != null ? this.callOptions.toBuilder() : HttpJsonCallOptions.newBuilder();
        return this.withCallOptions(builder.setDeadline(newDeadline).build());
    }

    @Override
    @Nonnull
    public ApiTracer getTracer() {
        if (this.tracer == null) {
            return BaseApiTracer.getInstance();
        }
        return this.tracer;
    }

    @Override
    public HttpJsonCallContext withTracer(@Nonnull ApiTracer newTracer) {
        Preconditions.checkNotNull(newTracer);
        return new HttpJsonCallContext(this.channel, this.callOptions, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.extraHeaders, this.options, newTracer, this.retrySettings, this.retryableCodes, this.endpointContext);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpJsonCallContext that = (HttpJsonCallContext)o;
        return Objects.equals(this.channel, that.channel) && Objects.equals(this.callOptions, that.callOptions) && Objects.equals(this.timeout, that.timeout) && Objects.equals(this.extraHeaders, that.extraHeaders) && Objects.equals(this.options, that.options) && Objects.equals(this.tracer, that.tracer) && Objects.equals(this.retrySettings, that.retrySettings) && Objects.equals(this.retryableCodes, that.retryableCodes) && Objects.equals(this.endpointContext, that.endpointContext);
    }

    public int hashCode() {
        return Objects.hash(this.channel, this.callOptions, this.timeout, this.extraHeaders, this.options, this.tracer, this.retrySettings, this.retryableCodes, this.endpointContext);
    }
}

