/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.cloud.firestore.Order;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class BasePath<B extends BasePath<B>>
implements Comparable<B> {
    abstract ImmutableList<String> getSegments();

    @Nullable
    B getParent() {
        ImmutableList<String> parts = this.getSegments();
        if (parts.isEmpty()) {
            return null;
        }
        return this.createPathWithSegments((ImmutableList<String>)parts.subList(0, parts.size() - 1));
    }

    B append(String path) {
        return this.append(path, true);
    }

    B append(String path, boolean splitPath) {
        Preconditions.checkArgument(path != null && !path.isEmpty(), "'path' must be a non-empty String");
        ImmutableList.Builder components = ImmutableList.builder();
        components.addAll(this.getSegments());
        if (splitPath) {
            components.add(this.splitChildPath(path));
        } else {
            components.add(path);
        }
        return this.createPathWithSegments((ImmutableList<String>)components.build());
    }

    B append(BasePath<B> path) {
        ImmutableList<String> segments1 = this.getSegments();
        ImmutableList<String> segments2 = path.getSegments();
        ImmutableList.Builder components = ImmutableList.builderWithExpectedSize(segments1.size() + segments2.size());
        components.addAll(segments1);
        components.addAll(segments2);
        return this.createPathWithSegments((ImmutableList<String>)components.build());
    }

    boolean isPrefixOf(BasePath<B> path) {
        ImmutableList<String> prefixSegments = this.getSegments();
        ImmutableList<String> childSegments = path.getSegments();
        int size = prefixSegments.size();
        if (size > childSegments.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (((String)prefixSegments.get(i)).equals(childSegments.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(@Nonnull B other) {
        ImmutableList<String> thisSegments = this.getSegments();
        ImmutableList<String> otherSegments = ((BasePath)other).getSegments();
        int length = Math.min(thisSegments.size(), otherSegments.size());
        for (int i = 0; i < length; ++i) {
            int cmp = this.compareSegments((String)thisSegments.get(i), (String)otherSegments.get(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return Integer.compare(thisSegments.size(), otherSegments.size());
    }

    private int compareSegments(String lhs, String rhs) {
        boolean isLhsNumeric = this.isNumericId(lhs);
        boolean isRhsNumeric = this.isNumericId(rhs);
        if (isLhsNumeric && !isRhsNumeric) {
            return -1;
        }
        if (!isLhsNumeric && isRhsNumeric) {
            return 1;
        }
        if (isLhsNumeric && isRhsNumeric) {
            return Long.compare(this.extractNumericId(lhs), this.extractNumericId(rhs));
        }
        return Order.compareUtf8Strings(lhs, rhs);
    }

    private boolean isNumericId(String segment) {
        return segment.startsWith("__id") && segment.endsWith("__");
    }

    private long extractNumericId(String segment) {
        return Long.parseLong(segment.substring(4, segment.length() - 2));
    }

    abstract String[] splitChildPath(String var1);

    abstract B createPathWithSegments(ImmutableList<String> var1);
}

