/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.InternalExtensionOnly;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptions;
import com.google.cloud.firestore.CollectionReference;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.EventListener;
import com.google.cloud.firestore.FieldMask;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.Firestore;
import com.google.cloud.firestore.FirestoreException;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.FirestoreRpcContext;
import com.google.cloud.firestore.ListenerRegistration;
import com.google.cloud.firestore.Precondition;
import com.google.cloud.firestore.ResourcePath;
import com.google.cloud.firestore.SetOptions;
import com.google.cloud.firestore.Watch;
import com.google.cloud.firestore.WriteBatch;
import com.google.cloud.firestore.WriteResult;
import com.google.cloud.firestore.telemetry.MetricsUtil;
import com.google.cloud.firestore.telemetry.TelemetryConstants;
import com.google.cloud.firestore.telemetry.TraceUtil;
import com.google.cloud.firestore.v1.FirestoreClient;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.firestore.v1.ListCollectionIdsRequest;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalExtensionOnly
public class DocumentReference {
    private final ResourcePath path;
    private final FirestoreRpcContext<?> rpcContext;

    DocumentReference(FirestoreRpcContext<?> rpcContext, ResourcePath path) {
        this.path = path;
        this.rpcContext = rpcContext;
    }

    @Nonnull
    public Firestore getFirestore() {
        return this.rpcContext.getFirestore();
    }

    @Nonnull
    public String getId() {
        return this.path.getId();
    }

    @Nonnull
    public String getPath() {
        return this.path.getPath();
    }

    @Nonnull
    String getName() {
        return this.path.getName();
    }

    @Nonnull
    public CollectionReference getParent() {
        return new CollectionReference(this.rpcContext, (ResourcePath)this.path.getParent());
    }

    @Nonnull
    public CollectionReference collection(@Nonnull String collectionPath) {
        return new CollectionReference(this.rpcContext, (ResourcePath)this.path.append(collectionPath));
    }

    private <T> ApiFuture<T> extractFirst(ApiFuture<List<T>> results) {
        return ApiFutures.transform(results, results1 -> results1.isEmpty() ? null : results1.get(0), MoreExecutors.directExecutor());
    }

    @Nonnull
    private TraceUtil getTraceUtil() {
        return ((FirestoreOptions)this.getFirestore().getOptions()).getTraceUtil();
    }

    @Nonnull
    private MetricsUtil getMetricsUtil() {
        return ((FirestoreOptions)this.getFirestore().getOptions()).getMetricsUtil();
    }

    @Nonnull
    public ApiFuture<WriteResult> create(@Nonnull Map<String, Object> fields) {
        TraceUtil.Span span = this.getTraceUtil().startSpan("DocumentReference.Create");
        MetricsUtil.MetricsContext metricsContext = this.getMetricsUtil().createMetricsContext("DocumentReference.Create");
        TraceUtil.Scope ignored = span.makeCurrent();
        try {
            WriteBatch writeBatch = this.rpcContext.getFirestore().batch();
            ApiFuture<WriteResult> result = this.extractFirst(((WriteBatch)writeBatch.create(this, fields)).commit());
            span.endAtFuture(result);
            metricsContext.recordLatencyAtFuture(TelemetryConstants.MetricType.END_TO_END_LATENCY, result);
            ApiFuture<WriteResult> apiFuture = result;
            if (ignored != null) {
                ignored.close();
            }
            return apiFuture;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception error) {
                span.end(error);
                metricsContext.recordLatency(TelemetryConstants.MetricType.END_TO_END_LATENCY, error);
                throw error;
            }
        }
    }

    @Nonnull
    public ApiFuture<WriteResult> create(@Nonnull Object pojo) {
        TraceUtil.Span span = this.getTraceUtil().startSpan("DocumentReference.Create");
        MetricsUtil.MetricsContext metricsContext = this.getMetricsUtil().createMetricsContext("DocumentReference.Create");
        TraceUtil.Scope ignored = span.makeCurrent();
        try {
            WriteBatch writeBatch = this.rpcContext.getFirestore().batch();
            ApiFuture<WriteResult> result = this.extractFirst(((WriteBatch)writeBatch.create(this, pojo)).commit());
            span.endAtFuture(result);
            metricsContext.recordLatencyAtFuture(TelemetryConstants.MetricType.END_TO_END_LATENCY, result);
            ApiFuture<WriteResult> apiFuture = result;
            if (ignored != null) {
                ignored.close();
            }
            return apiFuture;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception error) {
                span.end(error);
                metricsContext.recordLatency(TelemetryConstants.MetricType.END_TO_END_LATENCY, error);
                throw error;
            }
        }
    }

    @Nonnull
    public ApiFuture<WriteResult> set(@Nonnull Map<String, Object> fields) {
        TraceUtil.Span span = this.getTraceUtil().startSpan("DocumentReference.Set");
        MetricsUtil.MetricsContext metricsContext = this.getMetricsUtil().createMetricsContext("DocumentReference.Set");
        TraceUtil.Scope ignored = span.makeCurrent();
        try {
            WriteBatch writeBatch = this.rpcContext.getFirestore().batch();
            ApiFuture<WriteResult> result = this.extractFirst(((WriteBatch)writeBatch.set(this, fields)).commit());
            span.endAtFuture(result);
            metricsContext.recordLatencyAtFuture(TelemetryConstants.MetricType.END_TO_END_LATENCY, result);
            ApiFuture<WriteResult> apiFuture = result;
            if (ignored != null) {
                ignored.close();
            }
            return apiFuture;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception error) {
                span.end(error);
                metricsContext.recordLatency(TelemetryConstants.MetricType.END_TO_END_LATENCY, error);
                throw error;
            }
        }
    }

    @Nonnull
    public ApiFuture<WriteResult> set(@Nonnull Map<String, Object> fields, @Nonnull SetOptions options) {
        TraceUtil.Span span = this.getTraceUtil().startSpan("DocumentReference.Set");
        MetricsUtil.MetricsContext metricsContext = this.getMetricsUtil().createMetricsContext("DocumentReference.Set");
        TraceUtil.Scope ignored = span.makeCurrent();
        try {
            WriteBatch writeBatch = this.rpcContext.getFirestore().batch();
            ApiFuture<WriteResult> result = this.extractFirst(((WriteBatch)writeBatch.set(this, fields, options)).commit());
            span.endAtFuture(result);
            metricsContext.recordLatencyAtFuture(TelemetryConstants.MetricType.END_TO_END_LATENCY, result);
            ApiFuture<WriteResult> apiFuture = result;
            if (ignored != null) {
                ignored.close();
            }
            return apiFuture;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception error) {
                span.end(error);
                metricsContext.recordLatency(TelemetryConstants.MetricType.END_TO_END_LATENCY, error);
                throw error;
            }
        }
    }

    @Nonnull
    public ApiFuture<WriteResult> set(@Nonnull Object pojo) {
        TraceUtil.Span span = this.getTraceUtil().startSpan("DocumentReference.Set");
        MetricsUtil.MetricsContext metricsContext = this.getMetricsUtil().createMetricsContext("DocumentReference.Set");
        TraceUtil.Scope ignored = span.makeCurrent();
        try {
            WriteBatch writeBatch = this.rpcContext.getFirestore().batch();
            ApiFuture<WriteResult> result = this.extractFirst(((WriteBatch)writeBatch.set(this, pojo)).commit());
            span.endAtFuture(result);
            metricsContext.recordLatencyAtFuture(TelemetryConstants.MetricType.END_TO_END_LATENCY, result);
            ApiFuture<WriteResult> apiFuture = result;
            if (ignored != null) {
                ignored.close();
            }
            return apiFuture;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception error) {
                span.end(error);
                metricsContext.recordLatency(TelemetryConstants.MetricType.END_TO_END_LATENCY, error);
                throw error;
            }
        }
    }

    @Nonnull
    public ApiFuture<WriteResult> set(@Nonnull Object pojo, @Nonnull SetOptions options) {
        TraceUtil.Span span = this.getTraceUtil().startSpan("DocumentReference.Set");
        MetricsUtil.MetricsContext metricsContext = this.getMetricsUtil().createMetricsContext("DocumentReference.Set");
        TraceUtil.Scope ignored = span.makeCurrent();
        try {
            WriteBatch writeBatch = this.rpcContext.getFirestore().batch();
            ApiFuture<WriteResult> result = this.extractFirst(((WriteBatch)writeBatch.set(this, pojo, options)).commit());
            span.endAtFuture(result);
            metricsContext.recordLatencyAtFuture(TelemetryConstants.MetricType.END_TO_END_LATENCY, result);
            ApiFuture<WriteResult> apiFuture = result;
            if (ignored != null) {
                ignored.close();
            }
            return apiFuture;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception error) {
                span.end(error);
                metricsContext.recordLatency(TelemetryConstants.MetricType.END_TO_END_LATENCY, error);
                throw error;
            }
        }
    }

    @Nonnull
    public ApiFuture<WriteResult> update(@Nonnull Map<String, Object> fields) {
        TraceUtil.Span span = this.getTraceUtil().startSpan("DocumentReference.Update");
        MetricsUtil.MetricsContext metricsContext = this.getMetricsUtil().createMetricsContext("DocumentReference.Update");
        TraceUtil.Scope ignored = span.makeCurrent();
        try {
            WriteBatch writeBatch = this.rpcContext.getFirestore().batch();
            ApiFuture<WriteResult> result = this.extractFirst(((WriteBatch)writeBatch.update(this, fields)).commit());
            span.endAtFuture(result);
            metricsContext.recordLatencyAtFuture(TelemetryConstants.MetricType.END_TO_END_LATENCY, result);
            ApiFuture<WriteResult> apiFuture = result;
            if (ignored != null) {
                ignored.close();
            }
            return apiFuture;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception error) {
                span.end(error);
                metricsContext.recordLatency(TelemetryConstants.MetricType.END_TO_END_LATENCY, error);
                throw error;
            }
        }
    }

    @Nonnull
    public ApiFuture<WriteResult> update(@Nonnull Map<String, Object> fields, Precondition options) {
        TraceUtil.Span span = this.getTraceUtil().startSpan("DocumentReference.Update");
        MetricsUtil.MetricsContext metricsContext = this.getMetricsUtil().createMetricsContext("DocumentReference.Update");
        TraceUtil.Scope ignored = span.makeCurrent();
        try {
            WriteBatch writeBatch = this.rpcContext.getFirestore().batch();
            ApiFuture<WriteResult> result = this.extractFirst(((WriteBatch)writeBatch.update(this, fields, options)).commit());
            span.endAtFuture(result);
            metricsContext.recordLatencyAtFuture(TelemetryConstants.MetricType.END_TO_END_LATENCY, result);
            ApiFuture<WriteResult> apiFuture = result;
            if (ignored != null) {
                ignored.close();
            }
            return apiFuture;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception error) {
                span.end(error);
                metricsContext.recordLatency(TelemetryConstants.MetricType.END_TO_END_LATENCY, error);
                throw error;
            }
        }
    }

    @Nonnull
    public ApiFuture<WriteResult> update(@Nonnull String field, @Nullable Object value, Object ... moreFieldsAndValues) {
        TraceUtil.Span span = this.getTraceUtil().startSpan("DocumentReference.Update");
        MetricsUtil.MetricsContext metricsContext = this.getMetricsUtil().createMetricsContext("DocumentReference.Update");
        TraceUtil.Scope ignored = span.makeCurrent();
        try {
            WriteBatch writeBatch = this.rpcContext.getFirestore().batch();
            ApiFuture<WriteResult> result = this.extractFirst(((WriteBatch)writeBatch.update(this, field, value, moreFieldsAndValues)).commit());
            span.endAtFuture(result);
            metricsContext.recordLatencyAtFuture(TelemetryConstants.MetricType.END_TO_END_LATENCY, result);
            ApiFuture<WriteResult> apiFuture = result;
            if (ignored != null) {
                ignored.close();
            }
            return apiFuture;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception error) {
                span.end(error);
                metricsContext.recordLatency(TelemetryConstants.MetricType.END_TO_END_LATENCY, error);
                throw error;
            }
        }
    }

    @Nonnull
    public ApiFuture<WriteResult> update(@Nonnull FieldPath fieldPath, @Nullable Object value, Object ... moreFieldsAndValues) {
        TraceUtil.Span span = this.getTraceUtil().startSpan("DocumentReference.Update");
        MetricsUtil.MetricsContext metricsContext = this.getMetricsUtil().createMetricsContext("DocumentReference.Update");
        TraceUtil.Scope ignored = span.makeCurrent();
        try {
            WriteBatch writeBatch = this.rpcContext.getFirestore().batch();
            ApiFuture<WriteResult> result = this.extractFirst(((WriteBatch)writeBatch.update(this, fieldPath, value, moreFieldsAndValues)).commit());
            span.endAtFuture(result);
            metricsContext.recordLatencyAtFuture(TelemetryConstants.MetricType.END_TO_END_LATENCY, result);
            ApiFuture<WriteResult> apiFuture = result;
            if (ignored != null) {
                ignored.close();
            }
            return apiFuture;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception error) {
                span.end(error);
                metricsContext.recordLatency(TelemetryConstants.MetricType.END_TO_END_LATENCY, error);
                throw error;
            }
        }
    }

    @Nonnull
    public ApiFuture<WriteResult> update(@Nonnull Precondition options, @Nonnull String field, @Nullable Object value, Object ... moreFieldsAndValues) {
        TraceUtil.Span span = this.getTraceUtil().startSpan("DocumentReference.Update");
        MetricsUtil.MetricsContext metricsContext = this.getMetricsUtil().createMetricsContext("DocumentReference.Update");
        TraceUtil.Scope ignored = span.makeCurrent();
        try {
            WriteBatch writeBatch = this.rpcContext.getFirestore().batch();
            ApiFuture<WriteResult> result = this.extractFirst(((WriteBatch)writeBatch.update(this, options, field, value, moreFieldsAndValues)).commit());
            span.endAtFuture(result);
            metricsContext.recordLatencyAtFuture(TelemetryConstants.MetricType.END_TO_END_LATENCY, result);
            ApiFuture<WriteResult> apiFuture = result;
            if (ignored != null) {
                ignored.close();
            }
            return apiFuture;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception error) {
                span.end(error);
                metricsContext.recordLatency(TelemetryConstants.MetricType.END_TO_END_LATENCY, error);
                throw error;
            }
        }
    }

    @Nonnull
    public ApiFuture<WriteResult> update(@Nonnull Precondition options, @Nonnull FieldPath fieldPath, @Nullable Object value, Object ... moreFieldsAndValues) {
        TraceUtil.Span span = this.getTraceUtil().startSpan("DocumentReference.Update");
        MetricsUtil.MetricsContext metricsContext = this.getMetricsUtil().createMetricsContext("DocumentReference.Update");
        TraceUtil.Scope ignored = span.makeCurrent();
        try {
            WriteBatch writeBatch = this.rpcContext.getFirestore().batch();
            ApiFuture<WriteResult> result = this.extractFirst(((WriteBatch)writeBatch.update(this, options, fieldPath, value, moreFieldsAndValues)).commit());
            span.endAtFuture(result);
            metricsContext.recordLatencyAtFuture(TelemetryConstants.MetricType.END_TO_END_LATENCY, result);
            ApiFuture<WriteResult> apiFuture = result;
            if (ignored != null) {
                ignored.close();
            }
            return apiFuture;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception error) {
                span.end(error);
                metricsContext.recordLatency(TelemetryConstants.MetricType.END_TO_END_LATENCY, error);
                throw error;
            }
        }
    }

    @Nonnull
    public ApiFuture<WriteResult> delete(@Nonnull Precondition options) {
        TraceUtil.Span span = this.getTraceUtil().startSpan("DocumentReference.Delete");
        MetricsUtil.MetricsContext metricsContext = this.getMetricsUtil().createMetricsContext("DocumentReference.Delete");
        TraceUtil.Scope ignored = span.makeCurrent();
        try {
            WriteBatch writeBatch = this.rpcContext.getFirestore().batch();
            ApiFuture<WriteResult> result = this.extractFirst(((WriteBatch)writeBatch.delete(this, options)).commit());
            span.endAtFuture(result);
            metricsContext.recordLatencyAtFuture(TelemetryConstants.MetricType.END_TO_END_LATENCY, result);
            ApiFuture<WriteResult> apiFuture = result;
            if (ignored != null) {
                ignored.close();
            }
            return apiFuture;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception error) {
                span.end(error);
                metricsContext.recordLatency(TelemetryConstants.MetricType.END_TO_END_LATENCY, error);
                throw error;
            }
        }
    }

    @Nonnull
    public ApiFuture<WriteResult> delete() {
        TraceUtil.Span span = this.getTraceUtil().startSpan("DocumentReference.Delete");
        MetricsUtil.MetricsContext metricsContext = this.getMetricsUtil().createMetricsContext("DocumentReference.Delete");
        TraceUtil.Scope ignored = span.makeCurrent();
        try {
            WriteBatch writeBatch = this.rpcContext.getFirestore().batch();
            ApiFuture<WriteResult> result = this.extractFirst(((WriteBatch)writeBatch.delete(this)).commit());
            span.endAtFuture(result);
            metricsContext.recordLatencyAtFuture(TelemetryConstants.MetricType.END_TO_END_LATENCY, result);
            ApiFuture<WriteResult> apiFuture = result;
            if (ignored != null) {
                ignored.close();
            }
            return apiFuture;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception error) {
                span.end(error);
                metricsContext.recordLatency(TelemetryConstants.MetricType.END_TO_END_LATENCY, error);
                throw error;
            }
        }
    }

    @Nonnull
    public ApiFuture<DocumentSnapshot> get() {
        TraceUtil.Span span = this.getTraceUtil().startSpan("DocumentReference.Get");
        MetricsUtil.MetricsContext metricsContext = this.getMetricsUtil().createMetricsContext("DocumentReference.Get");
        TraceUtil.Scope ignored = span.makeCurrent();
        try {
            ApiFuture<DocumentSnapshot> result = this.extractFirst(this.rpcContext.getFirestore().getAll(this));
            span.endAtFuture(result);
            metricsContext.recordLatencyAtFuture(TelemetryConstants.MetricType.END_TO_END_LATENCY, result);
            ApiFuture<DocumentSnapshot> apiFuture = result;
            if (ignored != null) {
                ignored.close();
            }
            return apiFuture;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception error) {
                span.end(error);
                metricsContext.recordLatency(TelemetryConstants.MetricType.END_TO_END_LATENCY, error);
                throw error;
            }
        }
    }

    @Nonnull
    public ApiFuture<DocumentSnapshot> get(FieldMask fieldMask) {
        TraceUtil.Span span = this.getTraceUtil().startSpan("DocumentReference.Get");
        MetricsUtil.MetricsContext metricsContext = this.getMetricsUtil().createMetricsContext("DocumentReference.Get");
        TraceUtil.Scope ignored = span.makeCurrent();
        try {
            ApiFuture<DocumentSnapshot> result = this.extractFirst(this.rpcContext.getFirestore().getAll(new DocumentReference[]{this}, fieldMask));
            span.endAtFuture(result);
            metricsContext.recordLatencyAtFuture(TelemetryConstants.MetricType.END_TO_END_LATENCY, result);
            ApiFuture<DocumentSnapshot> apiFuture = result;
            if (ignored != null) {
                ignored.close();
            }
            return apiFuture;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception error) {
                span.end(error);
                metricsContext.recordLatency(TelemetryConstants.MetricType.END_TO_END_LATENCY, error);
                throw error;
            }
        }
    }

    @Nonnull
    public Iterable<CollectionReference> listCollections() {
        TraceUtil.Span span = this.getTraceUtil().startSpan("DocumentReference.ListCollections");
        MetricsUtil.MetricsContext metricsContext = this.getMetricsUtil().createMetricsContext("DocumentReference.ListCollections");
        TraceUtil.Scope ignored = span.makeCurrent();
        try {
            ListCollectionIdsRequest.Builder request = ListCollectionIdsRequest.newBuilder();
            request.setParent(this.path.toString());
            final FirestoreClient.ListCollectionIdsPagedResponse response = ApiExceptions.callAndTranslateApiException(this.rpcContext.sendRequest(request.build(), this.rpcContext.getClient().listCollectionIdsPagedCallable()));
            Iterable<CollectionReference> result = new Iterable<CollectionReference>(){

                @Override
                @Nonnull
                public Iterator<CollectionReference> iterator() {
                    final Iterator iterator = response.iterateAll().iterator();
                    return new Iterator<CollectionReference>(){

                        @Override
                        public boolean hasNext() {
                            return iterator.hasNext();
                        }

                        @Override
                        public CollectionReference next() {
                            return DocumentReference.this.collection((String)iterator.next());
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException("remove");
                        }
                    };
                }
            };
            span.end();
            metricsContext.recordLatency(TelemetryConstants.MetricType.END_TO_END_LATENCY);
            Iterable<CollectionReference> iterable = result;
            if (ignored != null) {
                ignored.close();
            }
            return iterable;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (ApiException exception) {
                span.end(exception);
                metricsContext.recordLatency(TelemetryConstants.MetricType.END_TO_END_LATENCY, exception);
                throw FirestoreException.forApiException(exception);
            }
        }
    }

    @Nonnull
    public ListenerRegistration addSnapshotListener(@Nonnull Executor executor, @Nonnull EventListener<DocumentSnapshot> listener) {
        return Watch.forDocument(this).runWatch(executor, (value, error) -> {
            if (value == null) {
                listener.onEvent(null, error);
                return;
            }
            for (DocumentSnapshot doc : value) {
                if (!doc.getReference().equals(this)) continue;
                listener.onEvent(value.getDocuments().get(0), null);
                return;
            }
            listener.onEvent(DocumentSnapshot.fromMissing(this.rpcContext, this, value.getReadTime()), null);
        });
    }

    @Nonnull
    public ListenerRegistration addSnapshotListener(@Nonnull EventListener<DocumentSnapshot> listener) {
        return this.addSnapshotListener(this.rpcContext.getClient().getExecutor(), listener);
    }

    ResourcePath getResourcePath() {
        return this.path;
    }

    public String toString() {
        return String.format("DocumentReference{path=%s}", this.path);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DocumentReference that = (DocumentReference)obj;
        return Objects.equals(this.path, that.path) && Objects.equals(this.rpcContext, that.rpcContext);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.rpcContext);
    }
}

