/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiClock;
import com.google.api.core.ApiFuture;
import com.google.api.core.InternalApi;
import com.google.api.core.InternalExtensionOnly;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.rpc.BidiStreamObserver;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.ClientStream;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.gax.util.TimeConversionUtils;
import com.google.cloud.firestore.Firestore;
import com.google.cloud.firestore.ResourcePath;
import com.google.cloud.firestore.spi.v1.FirestoreRpc;
import org.threeten.bp.Duration;

@InternalApi
@InternalExtensionOnly
interface FirestoreRpcContext<FS extends Firestore> {
    public FS getFirestore();

    public String getDatabaseName();

    public ResourcePath getResourcePath();

    public FirestoreRpc getClient();

    @ObsoleteApi(value="Use getTotalRequestTimeoutDuration() instead")
    public Duration getTotalRequestTimeout();

    default public java.time.Duration getTotalRequestTimeoutDuration() {
        return TimeConversionUtils.toJavaTimeDuration(this.getTotalRequestTimeout());
    }

    public ApiClock getClock();

    public <RequestT, ResponseT> ApiFuture<ResponseT> sendRequest(RequestT var1, UnaryCallable<RequestT, ResponseT> var2);

    public <RequestT, ResponseT> void streamRequest(RequestT var1, ResponseObserver<ResponseT> var2, ServerStreamingCallable<RequestT, ResponseT> var3);

    public <RequestT, ResponseT> ClientStream<RequestT> streamRequest(BidiStreamObserver<RequestT, ResponseT> var1, BidiStreamingCallable<RequestT, ResponseT> var2);
}

