/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.InternalApi;
import com.google.cloud.Timestamp;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.UserDataConverter;
import com.google.cloud.firestore.encoding.CustomClassMapper;
import com.google.cloud.firestore.spi.v1.FirestoreRpc;
import com.google.common.base.Preconditions;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.Value;
import java.util.Map;

@InternalApi
public class Internal {
    private final FirestoreImpl firestore;

    @InternalApi
    public Internal(FirestoreImpl firestore) {
        this.firestore = firestore;
    }

    @InternalApi
    public Internal(FirestoreOptions firestoreOptions, FirestoreRpc firestoreRpc) {
        this.firestore = new FirestoreImpl(firestoreOptions, firestoreRpc);
    }

    @InternalApi
    public DocumentSnapshot snapshotFromObject(String documentPath, Object pojo) {
        DocumentReference documentReference = this.firestore.document(documentPath);
        Object data = CustomClassMapper.convertToPlainJavaTypes(pojo);
        Preconditions.checkArgument(data instanceof Map, "Can't create a document from an array or primitive");
        return DocumentSnapshot.fromObject(this.firestore, documentReference, (Map)data, UserDataConverter.NO_DELETES);
    }

    @InternalApi
    public DocumentSnapshot snapshotFromMap(String documentPath, Map<String, Object> data) {
        DocumentReference documentReference = this.firestore.document(documentPath);
        return DocumentSnapshot.fromObject(this.firestore, documentReference, data, UserDataConverter.NO_DELETES);
    }

    @InternalApi
    public DocumentSnapshot snapshotFromProto(Timestamp readTime, Document document) {
        return DocumentSnapshot.fromDocument(this.firestore, readTime, document);
    }

    @InternalApi
    public Map<String, Value> protoFromSnapshot(DocumentSnapshot snapshot) {
        return snapshot.getProtoFields();
    }

    @InternalApi
    public static String autoId() {
        return FirestoreImpl.autoId();
    }
}

