/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.InternalExtensionOnly;
import com.google.cloud.Timestamp;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.FirestoreRpcContext;
import com.google.cloud.firestore.ResourcePath;
import com.google.common.base.Preconditions;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.Value;
import java.util.Map;
import javax.annotation.Nonnull;

@InternalExtensionOnly
public class QueryDocumentSnapshot
extends DocumentSnapshot {
    QueryDocumentSnapshot(FirestoreRpcContext<?> rpcContext, DocumentReference docRef, Map<String, Value> fields, Timestamp readTime, Timestamp updateTime, Timestamp createTime) {
        super(rpcContext, docRef, fields, readTime, updateTime, createTime);
    }

    static QueryDocumentSnapshot fromDocument(FirestoreRpcContext<?> rpcContext, Timestamp readTime, Document document) {
        return new QueryDocumentSnapshot(rpcContext, new DocumentReference(rpcContext, ResourcePath.create(document.getName())), document.getFieldsMap(), readTime, Timestamp.fromProto(document.getUpdateTime()), Timestamp.fromProto(document.getCreateTime()));
    }

    @Override
    @Nonnull
    public Map<String, Object> getData() {
        Map<String, Object> result = super.getData();
        Preconditions.checkNotNull(result, "Data in a QueryDocumentSnapshot should be non-null");
        return result;
    }

    @Override
    @Nonnull
    public <T> T toObject(@Nonnull Class<T> valueType) {
        T result = super.toObject(valueType);
        Preconditions.checkNotNull(result, "Object in a QueryDocumentSnapshot should be non-null");
        return result;
    }

    static int compareDocumentId(QueryDocumentSnapshot doc1, QueryDocumentSnapshot doc2) {
        return doc1.getReference().getResourcePath().compareTo(doc2.getReference().getResourcePath());
    }
}

