/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.cloud.Timestamp;
import com.google.cloud.firestore.AggregateQuery;
import com.google.cloud.firestore.AggregateQuerySnapshot;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.FieldMask;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.Precondition;
import com.google.cloud.firestore.Query;
import com.google.cloud.firestore.QuerySnapshot;
import com.google.cloud.firestore.SetOptions;
import com.google.cloud.firestore.Transaction;
import com.google.cloud.firestore.telemetry.TraceUtil;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class ReadTimeTransaction
extends Transaction {
    public static final String WRITE_EXCEPTION_MSG = "Firestore ready-only transactions do not support writes";
    private final com.google.protobuf.Timestamp readTime;

    ReadTimeTransaction(FirestoreImpl firestore, com.google.protobuf.Timestamp readTime) {
        super(firestore);
        Preconditions.checkNotNull(readTime, "readTime cannot be null");
        this.readTime = readTime;
    }

    @Override
    public boolean hasTransactionId() {
        return false;
    }

    @Override
    @Nonnull
    public ApiFuture<DocumentSnapshot> get(@Nonnull DocumentReference documentRef) {
        TraceUtil.Span span = this.getTraceUtil().startSpan("Transaction.Get.Document", this.transactionTraceContext);
        TraceUtil.Scope ignored = span.makeCurrent();
        try {
            ApiFuture<DocumentSnapshot> result = ApiFutures.transform(this.firestore.getAll(new DocumentReference[]{documentRef}, null, this.readTime), snapshots -> snapshots.isEmpty() ? null : (DocumentSnapshot)snapshots.get(0), MoreExecutors.directExecutor());
            span.endAtFuture(result);
            ApiFuture<DocumentSnapshot> apiFuture = result;
            if (ignored != null) {
                ignored.close();
            }
            return apiFuture;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception error) {
                span.end(error);
                throw error;
            }
        }
    }

    @Override
    @Nonnull
    public ApiFuture<List<DocumentSnapshot>> getAll(DocumentReference ... documentReferences) {
        TraceUtil.Span span = this.getTraceUtil().startSpan("Transaction.Get.Documents", this.transactionTraceContext);
        TraceUtil.Scope ignored = span.makeCurrent();
        try {
            ApiFuture<List<DocumentSnapshot>> result = this.firestore.getAll(documentReferences, null, this.readTime);
            span.endAtFuture(result);
            ApiFuture<List<DocumentSnapshot>> apiFuture = result;
            if (ignored != null) {
                ignored.close();
            }
            return apiFuture;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception error) {
                span.end(error);
                throw error;
            }
        }
    }

    @Override
    @Nonnull
    public ApiFuture<List<DocumentSnapshot>> getAll(@Nonnull DocumentReference[] documentReferences, @Nullable FieldMask fieldMask) {
        TraceUtil.Span span = this.getTraceUtil().startSpan("Transaction.Get.Documents", this.transactionTraceContext);
        TraceUtil.Scope ignored = span.makeCurrent();
        try {
            ApiFuture<List<DocumentSnapshot>> result = this.firestore.getAll(documentReferences, null, this.readTime);
            span.endAtFuture(result);
            ApiFuture<List<DocumentSnapshot>> apiFuture = result;
            if (ignored != null) {
                ignored.close();
            }
            return apiFuture;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception error) {
                span.end(error);
                throw error;
            }
        }
    }

    @Override
    @Nonnull
    public ApiFuture<QuerySnapshot> get(@Nonnull Query query) {
        try (TraceUtil.Scope ignored = this.transactionTraceContext.makeCurrent();){
            ApiFuture<QuerySnapshot> apiFuture = query.get(null, Timestamp.fromProto(this.readTime));
            return apiFuture;
        }
    }

    @Override
    @Nonnull
    public ApiFuture<AggregateQuerySnapshot> get(@Nonnull AggregateQuery query) {
        try (TraceUtil.Scope ignored = this.transactionTraceContext.makeCurrent();){
            ApiFuture<AggregateQuerySnapshot> apiFuture = query.get(null, this.readTime);
            return apiFuture;
        }
    }

    @Override
    @Nonnull
    public Transaction create(@Nonnull DocumentReference documentReference, @Nonnull Map<String, Object> fields) {
        throw new IllegalStateException(WRITE_EXCEPTION_MSG);
    }

    @Override
    @Nonnull
    public Transaction create(@Nonnull DocumentReference documentReference, @Nonnull Object pojo) {
        throw new IllegalStateException(WRITE_EXCEPTION_MSG);
    }

    @Override
    @Nonnull
    public Transaction set(@Nonnull DocumentReference documentReference, @Nonnull Map<String, Object> fields) {
        throw new IllegalStateException(WRITE_EXCEPTION_MSG);
    }

    @Override
    @Nonnull
    public Transaction set(@Nonnull DocumentReference documentReference, @Nonnull Map<String, Object> fields, @Nonnull SetOptions options) {
        throw new IllegalStateException(WRITE_EXCEPTION_MSG);
    }

    @Override
    @Nonnull
    public Transaction set(@Nonnull DocumentReference documentReference, @Nonnull Object pojo) {
        throw new IllegalStateException(WRITE_EXCEPTION_MSG);
    }

    @Override
    @Nonnull
    public Transaction set(@Nonnull DocumentReference documentReference, @Nonnull Object pojo, @Nonnull SetOptions options) {
        throw new IllegalStateException(WRITE_EXCEPTION_MSG);
    }

    @Override
    @Nonnull
    public Transaction update(@Nonnull DocumentReference documentReference, @Nonnull Map<String, Object> fields) {
        throw new IllegalStateException(WRITE_EXCEPTION_MSG);
    }

    @Override
    @Nonnull
    public Transaction update(@Nonnull DocumentReference documentReference, @Nonnull Map<String, Object> fields, Precondition precondition) {
        throw new IllegalStateException(WRITE_EXCEPTION_MSG);
    }

    @Override
    @Nonnull
    public Transaction update(@Nonnull DocumentReference documentReference, @Nonnull String field, @Nullable Object value, Object ... moreFieldsAndValues) {
        throw new IllegalStateException(WRITE_EXCEPTION_MSG);
    }

    @Override
    @Nonnull
    public Transaction update(@Nonnull DocumentReference documentReference, @Nonnull FieldPath fieldPath, @Nullable Object value, Object ... moreFieldsAndValues) {
        throw new IllegalStateException(WRITE_EXCEPTION_MSG);
    }

    @Override
    @Nonnull
    public Transaction update(@Nonnull DocumentReference documentReference, @Nonnull Precondition precondition, @Nonnull String field, @Nullable Object value, Object ... moreFieldsAndValues) {
        throw new IllegalStateException(WRITE_EXCEPTION_MSG);
    }

    @Override
    @Nonnull
    public Transaction update(@Nonnull DocumentReference documentReference, @Nonnull Precondition precondition, @Nonnull FieldPath fieldPath, @Nullable Object value, Object ... moreFieldsAndValues) {
        throw new IllegalStateException(WRITE_EXCEPTION_MSG);
    }

    @Override
    @Nonnull
    public Transaction delete(@Nonnull DocumentReference documentReference, @Nonnull Precondition precondition) {
        throw new IllegalStateException(WRITE_EXCEPTION_MSG);
    }

    @Override
    @Nonnull
    public Transaction delete(@Nonnull DocumentReference documentReference) {
        throw new IllegalStateException(WRITE_EXCEPTION_MSG);
    }

    @Override
    public String toString() {
        return String.format("%s{readTime=%s}", this.getClass().getSimpleName(), this.readTime);
    }
}

