/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.auto.value.AutoValue;
import com.google.cloud.firestore.AutoValue_ResourcePath;
import com.google.cloud.firestore.BasePath;
import com.google.common.collect.ImmutableList;
import com.google.firestore.v1.DatabaseRootName;
import java.util.Arrays;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@AutoValue
abstract class ResourcePath
extends BasePath<ResourcePath> {
    ResourcePath() {
    }

    static ResourcePath create(DatabaseRootName databaseName, ImmutableList<String> segments) {
        return new AutoValue_ResourcePath(segments, databaseName);
    }

    static ResourcePath create(DatabaseRootName databaseName) {
        return new AutoValue_ResourcePath(ImmutableList.of(), databaseName);
    }

    static ResourcePath create(String resourceName) {
        String[] parts = resourceName.split("/");
        if (parts.length >= 5 && parts[0].equals("projects") && parts[2].equals("databases")) {
            Object[] path = Arrays.copyOfRange(parts, 5, parts.length);
            return ResourcePath.create(DatabaseRootName.of(parts[1], parts[3]), (ImmutableList<String>)((ImmutableList.Builder)ImmutableList.builder().add(path)).build());
        }
        return ResourcePath.create(DatabaseRootName.parse(resourceName));
    }

    abstract DatabaseRootName getDatabaseName();

    boolean isDocument() {
        int size = this.getSegments().size();
        return size > 0 && size % 2 == 0;
    }

    boolean isCollection() {
        return this.getSegments().size() % 2 == 1;
    }

    @Nullable
    String getId() {
        ImmutableList<String> parts = this.getSegments();
        if (!parts.isEmpty()) {
            return (String)parts.get(parts.size() - 1);
        }
        return null;
    }

    String getPath() {
        return String.join((CharSequence)"/", this.getSegments());
    }

    String getName() {
        String path = this.getPath();
        if (path.isEmpty()) {
            return this.getDatabaseName() + "/documents";
        }
        return this.getDatabaseName() + "/documents/" + path;
    }

    @Override
    public int compareTo(@Nonnull ResourcePath other) {
        DatabaseRootName otherDatabaseName;
        DatabaseRootName thisDatabaseName = this.getDatabaseName();
        if (thisDatabaseName != (otherDatabaseName = other.getDatabaseName())) {
            int cmp = thisDatabaseName.getProject().compareTo(otherDatabaseName.getProject());
            if (cmp != 0) {
                return cmp;
            }
            cmp = thisDatabaseName.getDatabase().compareTo(otherDatabaseName.getDatabase());
            if (cmp != 0) {
                return cmp;
            }
        }
        return super.compareTo(other);
    }

    ResourcePath popLast() {
        ImmutableList<String> segments = this.getSegments();
        return this.createPathWithSegments((ImmutableList)segments.subList(0, segments.size() - 1));
    }

    public String toString() {
        return this.getName();
    }

    @Override
    String[] splitChildPath(String name) {
        return name.split("/");
    }

    @Override
    ResourcePath createPathWithSegments(ImmutableList<String> segments) {
        return ResourcePath.create(this.getDatabaseName(), segments);
    }

    public static Comparator<ResourcePath> comparator() {
        return Comparator.naturalOrder();
    }
}

