/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.gax.rpc.BidiStreamObserver;
import com.google.api.gax.rpc.ClientStream;
import com.google.api.gax.rpc.StreamController;
import java.util.function.Function;
import java.util.logging.Logger;

final class SilenceableBidiStream<RequestT, ResponseT>
implements BidiStreamObserver<RequestT, ResponseT> {
    private static final Logger LOGGER = Logger.getLogger(SilenceableBidiStream.class.getName());
    private final ClientStream<RequestT> stream;
    private final BidiStreamObserver<RequestT, ResponseT> delegate;
    private boolean silence = false;

    SilenceableBidiStream(BidiStreamObserver<RequestT, ResponseT> responseObserverT, Function<BidiStreamObserver<RequestT, ResponseT>, ClientStream<RequestT>> streamSupplier) {
        this.delegate = responseObserverT;
        this.stream = streamSupplier.apply(this);
    }

    public boolean isSilenced() {
        return this.silence;
    }

    public void send(RequestT request) {
        LOGGER.fine(this.stream.toString());
        this.stream.send(request);
    }

    public void closeSend() {
        LOGGER.fine(this.stream::toString);
        this.stream.closeSend();
    }

    public void closeSendAndSilence() {
        LOGGER.fine(this.stream::toString);
        this.silence = true;
        this.stream.closeSend();
    }

    @Override
    public void onReady(ClientStream<RequestT> stream) {
        if (this.silence) {
            LOGGER.info(() -> String.format("Silenced: %s", stream));
        } else {
            this.delegate.onReady(stream);
        }
    }

    @Override
    public void onStart(StreamController controller) {
        if (this.silence) {
            LOGGER.info(() -> String.format("Silenced: %s", this.stream));
        } else {
            this.delegate.onStart(controller);
        }
    }

    @Override
    public void onResponse(ResponseT response) {
        if (this.silence) {
            LOGGER.info(() -> String.format("Silenced: %s", this.stream));
        } else {
            this.delegate.onResponse(response);
        }
    }

    @Override
    public void onError(Throwable t2) {
        if (this.silence) {
            LOGGER.info(() -> String.format("Silenced: %s", this.stream));
        } else {
            this.delegate.onError(t2);
        }
    }

    @Override
    public void onComplete() {
        if (this.silence) {
            LOGGER.info(() -> String.format("Silenced: %s", this.stream));
        } else {
            this.delegate.onComplete();
        }
    }
}

