/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.InternalExtensionOnly;
import com.google.cloud.firestore.BasePath;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.DocumentTransform;
import com.google.cloud.firestore.FieldMask;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.FieldValue;
import com.google.cloud.firestore.FirestoreException;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.Precondition;
import com.google.cloud.firestore.SetOptions;
import com.google.cloud.firestore.UserDataConverter;
import com.google.cloud.firestore.WriteResult;
import com.google.cloud.firestore.encoding.CustomClassMapper;
import com.google.cloud.firestore.telemetry.TraceUtil;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.firestore.v1.CommitRequest;
import com.google.firestore.v1.CommitResponse;
import com.google.firestore.v1.Write;
import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalExtensionOnly
public abstract class UpdateBuilder<T> {
    final FirestoreImpl firestore;
    private final List<WriteOperation> writes = new ArrayList<WriteOperation>();
    protected volatile boolean committed;

    UpdateBuilder(FirestoreImpl firestore) {
        this.firestore = firestore;
    }

    abstract T wrapResult(int var1);

    private static Map<String, Object> expandObject(Map<FieldPath, Object> data) {
        if (data instanceof SortedMap) {
            return UpdateBuilder.expandObject((SortedMap)data);
        }
        return UpdateBuilder.expandObject(new TreeMap<FieldPath, Object>(data));
    }

    private static Map<String, Object> expandObject(SortedMap<FieldPath, Object> data) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        BasePath lastField = null;
        for (Map.Entry<FieldPath, Object> entry : data.entrySet()) {
            FieldPath field = entry.getKey();
            if (lastField != null && lastField.isPrefixOf(field)) {
                throw new IllegalArgumentException(String.format("Detected ambiguous definition for field '%s'.", lastField));
            }
            Iterator iterator = field.getSegments().iterator();
            if (iterator.hasNext()) {
                String segment = (String)iterator.next();
                Map<String, Object> currentMap = result;
                while (iterator.hasNext()) {
                    currentMap = (Map)currentMap.computeIfAbsent(segment, key -> new HashMap());
                    segment = (String)iterator.next();
                }
                currentMap.put(segment, entry.getValue());
            }
            lastField = field;
        }
        return result;
    }

    @Nonnull
    public T create(@Nonnull DocumentReference documentReference, @Nonnull Map<String, Object> fields) {
        return this.performCreate(documentReference, fields);
    }

    private T performCreate(@Nonnull DocumentReference documentReference, @Nonnull Map<String, Object> fields) {
        DocumentSnapshot documentSnapshot = DocumentSnapshot.fromObject(this.firestore, documentReference, fields, UserDataConverter.NO_DELETES);
        DocumentTransform documentTransform = DocumentTransform.fromFieldPathMap(UpdateBuilder.convertToFieldPaths(fields));
        Write.Builder write = documentSnapshot.toPb();
        write.setCurrentDocument(Precondition.exists(false).toPb());
        if (!documentTransform.isEmpty()) {
            write.addAllUpdateTransforms(documentTransform.toPb());
        }
        return this.addWrite(documentReference, write);
    }

    @Nonnull
    public T create(@Nonnull DocumentReference documentReference, @Nonnull Object pojo) {
        Object data = CustomClassMapper.convertToPlainJavaTypes(pojo);
        if (!(data instanceof Map)) {
            throw FirestoreException.forInvalidArgument("Can't set a document's data to an array or primitive", new Object[0]);
        }
        return this.performCreate(documentReference, (Map)data);
    }

    @Nonnull
    public T set(@Nonnull DocumentReference documentReference, @Nonnull Map<String, Object> fields) {
        return this.set(documentReference, fields, SetOptions.OVERWRITE);
    }

    @Nonnull
    public T set(@Nonnull DocumentReference documentReference, @Nonnull Map<String, Object> fields, @Nonnull SetOptions options) {
        return this.performSet(documentReference, fields, options);
    }

    @Nonnull
    public T set(@Nonnull DocumentReference documentReference, @Nonnull Object pojo) {
        return this.set(documentReference, pojo, SetOptions.OVERWRITE);
    }

    @Nonnull
    public T set(@Nonnull DocumentReference documentReference, @Nonnull Object pojo, @Nonnull SetOptions options) {
        Object data = CustomClassMapper.convertToPlainJavaTypes(pojo);
        if (!(data instanceof Map)) {
            throw new IllegalArgumentException("Can't set a document's data to an array or primitive");
        }
        return this.performSet(documentReference, (Map)data, options);
    }

    private T performSet(@Nonnull DocumentReference documentReference, @Nonnull Map<String, Object> fields, @Nonnull SetOptions options) {
        Map<FieldPath, Object> documentData = options.getFieldMask() != null ? UpdateBuilder.applyFieldMask(fields, options.getFieldMask()) : UpdateBuilder.convertToFieldPaths(fields);
        DocumentSnapshot documentSnapshot = DocumentSnapshot.fromObject(this.firestore, documentReference, UpdateBuilder.expandObject(documentData), options.getEncodingOptions());
        FieldMask documentMask = FieldMask.EMPTY_MASK;
        DocumentTransform documentTransform = DocumentTransform.fromFieldPathMap(documentData);
        if (options.getFieldMask() != null) {
            TreeSet fieldPaths = options.getFieldMask().stream().filter(Predicates.not(documentTransform.getFields()::contains)).collect(Collectors.toCollection(TreeSet::new));
            documentMask = new FieldMask(fieldPaths);
        } else if (options.isMerge()) {
            documentMask = FieldMask.fromObject(fields);
        }
        Write.Builder write = documentSnapshot.toPb();
        if (!documentTransform.isEmpty()) {
            write.addAllUpdateTransforms(documentTransform.toPb());
        }
        if (options.isMerge() || options.getFieldMask() != null) {
            write.setUpdateMask(documentMask.toPb());
        }
        return this.addWrite(documentReference, write);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T addWrite(DocumentReference documentReference, Write.Builder write) {
        int writeIndex;
        WriteOperation operation = new WriteOperation(documentReference, write.build());
        List<WriteOperation> list = this.writes;
        synchronized (list) {
            Preconditions.checkState(!this.committed, String.format("Cannot modify a %s that has already been committed.", this.className()));
            this.writes.add(operation);
            writeIndex = this.writes.size() - 1;
        }
        return this.wrapResult(writeIndex);
    }

    protected String className() {
        return this.getClass().getSimpleName();
    }

    private static Map<FieldPath, Object> applyFieldMask(Map<String, Object> fields, List<FieldPath> fieldMask) {
        HashSet<FieldPath> remainingFields = new HashSet<FieldPath>(fieldMask);
        Map<FieldPath, Object> filteredData = UpdateBuilder.applyFieldMask(fields, remainingFields, FieldPath.empty());
        if (!remainingFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("Field masks contains invalid path. No data exist at field '%s'.", remainingFields.iterator().next()));
        }
        return filteredData;
    }

    private static Map<FieldPath, Object> applyFieldMask(Map<String, Object> fields, Set<FieldPath> fieldMask, FieldPath root) {
        HashMap<FieldPath, Object> filteredMap = new HashMap<FieldPath, Object>();
        for (Map.Entry<String, Object> entry : fields.entrySet()) {
            FieldPath currentField = root.append(FieldPath.of(entry.getKey()));
            if (fieldMask.remove(currentField)) {
                filteredMap.put(currentField, entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Map) {
                filteredMap.putAll(UpdateBuilder.applyFieldMask((Map)entry.getValue(), fieldMask, currentField));
                continue;
            }
            if (entry.getValue() != FieldValue.DELETE_SENTINEL) continue;
            throw new IllegalArgumentException(String.format("Cannot specify FieldValue.delete() for non-merged field '%s'.", currentField));
        }
        return filteredMap;
    }

    private static Map<FieldPath, Object> convertToFieldPaths(@Nonnull Map<String, Object> fields) {
        HashMap<FieldPath, Object> fieldPaths = new HashMap<FieldPath, Object>();
        fields.forEach((k, v) -> fieldPaths.put(FieldPath.of(k), v));
        return fieldPaths;
    }

    private static SortedMap<FieldPath, Object> convertToSplitOnDotsFieldPaths(@Nonnull Map<String, Object> fields) {
        TreeMap<FieldPath, Object> fieldPaths = new TreeMap<FieldPath, Object>();
        fields.forEach((k, v) -> fieldPaths.put(FieldPath.fromDotSeparatedString(k), v));
        return fieldPaths;
    }

    @Nonnull
    public T update(@Nonnull DocumentReference documentReference, @Nonnull Map<String, Object> fields) {
        return this.performUpdate(documentReference, UpdateBuilder.convertToSplitOnDotsFieldPaths(fields), Precondition.exists(true));
    }

    @Nonnull
    public T update(@Nonnull DocumentReference documentReference, @Nonnull Map<String, Object> fields, Precondition precondition) {
        Preconditions.checkArgument(!Boolean.FALSE.equals(precondition.getExists()), "Precondition 'exists' cannot have the value 'false' for update() calls.");
        return this.performUpdate(documentReference, UpdateBuilder.convertToSplitOnDotsFieldPaths(fields), precondition);
    }

    @Nonnull
    public T update(@Nonnull DocumentReference documentReference, @Nonnull String field, @Nullable Object value, Object ... moreFieldsAndValues) {
        return this.performUpdate(documentReference, Precondition.exists(true), FieldPath.fromDotSeparatedString(field), value, moreFieldsAndValues);
    }

    @Nonnull
    public T update(@Nonnull DocumentReference documentReference, @Nonnull FieldPath fieldPath, @Nullable Object value, Object ... moreFieldsAndValues) {
        return this.performUpdate(documentReference, Precondition.exists(true), fieldPath, value, moreFieldsAndValues);
    }

    @Nonnull
    public T update(@Nonnull DocumentReference documentReference, @Nonnull Precondition precondition, @Nonnull String field, @Nullable Object value, Object ... moreFieldsAndValues) {
        Preconditions.checkArgument(!Boolean.FALSE.equals(precondition.getExists()), "Precondition 'exists' cannot have the value 'false' for update() calls.");
        return this.performUpdate(documentReference, precondition, FieldPath.fromDotSeparatedString(field), value, moreFieldsAndValues);
    }

    @Nonnull
    public T update(@Nonnull DocumentReference documentReference, @Nonnull Precondition precondition, @Nonnull FieldPath fieldPath, @Nullable Object value, Object ... moreFieldsAndValues) {
        Preconditions.checkArgument(!Boolean.FALSE.equals(precondition.getExists()), "Precondition 'exists' cannot have the value 'false' for update() calls.");
        return this.performUpdate(documentReference, precondition, fieldPath, value, moreFieldsAndValues);
    }

    private T performUpdate(@Nonnull DocumentReference documentReference, @Nonnull Precondition precondition, @Nonnull FieldPath fieldPath, @Nullable Object value, Object[] moreFieldsAndValues) {
        Object data = CustomClassMapper.convertToPlainJavaTypes(value);
        TreeMap<FieldPath, Object> fields = new TreeMap<FieldPath, Object>();
        fields.put(fieldPath, data);
        Preconditions.checkArgument(moreFieldsAndValues.length % 2 == 0, "moreFieldsAndValues must be key-value pairs.");
        for (int i = 0; i < moreFieldsAndValues.length; i += 2) {
            FieldPath currentPath;
            Object objectPath = moreFieldsAndValues[i];
            Object objectValue = moreFieldsAndValues[i + 1];
            if (objectPath instanceof String) {
                currentPath = FieldPath.fromDotSeparatedString((String)objectPath);
            } else if (objectPath instanceof FieldPath) {
                currentPath = (FieldPath)objectPath;
            } else {
                throw new IllegalArgumentException("Field '" + objectPath + "' is not of type String or Field Path.");
            }
            if (fields.containsKey(currentPath)) {
                throw new IllegalArgumentException("Field value for field '" + objectPath + "' was specified multiple times.");
            }
            fields.put(currentPath, objectValue);
        }
        return this.performUpdate(documentReference, fields, precondition);
    }

    private T performUpdate(@Nonnull DocumentReference documentReference, final @Nonnull SortedMap<FieldPath, Object> fields, @Nonnull Precondition precondition) {
        Preconditions.checkArgument(!fields.isEmpty(), "Data for update() cannot be empty.");
        Map<String, Object> deconstructedMap = UpdateBuilder.expandObject(fields);
        DocumentSnapshot documentSnapshot = DocumentSnapshot.fromObject(this.firestore, documentReference, deconstructedMap, new UserDataConverter.EncodingOptions(){

            @Override
            public boolean allowDelete(FieldPath fieldPath) {
                return fields.containsKey(fieldPath);
            }

            @Override
            public boolean allowTransform() {
                return true;
            }
        });
        DocumentTransform documentTransform = DocumentTransform.fromFieldPathMap(fields);
        TreeSet fieldPaths = fields.keySet().stream().filter(Predicates.not(documentTransform.getFields()::contains)).collect(Collectors.toCollection(TreeSet::new));
        FieldMask fieldMask = new FieldMask(fieldPaths);
        Write.Builder write = documentSnapshot.toPb();
        write.setCurrentDocument(precondition.toPb());
        write.setUpdateMask(fieldMask.toPb());
        if (!documentTransform.isEmpty()) {
            write.addAllUpdateTransforms(documentTransform.toPb());
        }
        return this.addWrite(documentReference, write);
    }

    @Nonnull
    public T delete(@Nonnull DocumentReference documentReference, @Nonnull Precondition precondition) {
        return this.performDelete(documentReference, precondition);
    }

    @Nonnull
    public T delete(@Nonnull DocumentReference documentReference) {
        return this.performDelete(documentReference, Precondition.NONE);
    }

    private T performDelete(@Nonnull DocumentReference documentReference, @Nonnull Precondition precondition) {
        Write.Builder write = Write.newBuilder().setDelete(documentReference.getName());
        if (!precondition.isEmpty()) {
            write.setCurrentDocument(precondition.toPb());
        }
        return this.addWrite(documentReference, write);
    }

    ApiFuture<List<WriteResult>> commit(@Nullable ByteString transactionId) {
        TraceUtil.Span span = this.firestore.getOptions().getTraceUtil().startSpan(transactionId == null ? "Batch.Commit" : "Transaction.Commit");
        span.setAttribute("doc_count", this.writes.size());
        span.setAttribute("transactional", transactionId != null);
        TraceUtil.Scope ignored = span.makeCurrent();
        try {
            this.committed = true;
            CommitRequest request = this.buildCommitRequest(transactionId);
            ApiFuture<CommitResponse> response = this.firestore.sendRequest(request, this.firestore.getClient().commitCallable());
            ApiFuture<List<WriteResult>> returnValue = ApiFutures.transform(response, commitResponse -> {
                Timestamp commitTime = commitResponse.getCommitTime();
                return commitResponse.getWriteResultsList().stream().map(writeResult -> WriteResult.fromProto(writeResult, commitTime)).collect(Collectors.toList());
            }, MoreExecutors.directExecutor());
            span.endAtFuture(returnValue);
            ApiFuture<List<WriteResult>> apiFuture = returnValue;
            if (ignored != null) {
                ignored.close();
            }
            return apiFuture;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception error) {
                span.end(error);
                throw error;
            }
        }
    }

    private CommitRequest buildCommitRequest(ByteString transactionId) {
        CommitRequest.Builder builder = CommitRequest.newBuilder();
        builder.setDatabase(this.firestore.getDatabaseName());
        this.forEachWrite(builder::addWrites);
        if (transactionId != null) {
            builder.setTransaction(transactionId);
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isEmpty() {
        List<WriteOperation> list = this.writes;
        synchronized (list) {
            return this.writes.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forEachWrite(Consumer<Write> consumer) {
        List<WriteOperation> list = this.writes;
        synchronized (list) {
            for (WriteOperation writeOperation : this.writes) {
                consumer.accept(writeOperation.write);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMutationsSize() {
        List<WriteOperation> list = this.writes;
        synchronized (list) {
            return this.writes.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String writesAsString;
        List<WriteOperation> list = this.writes;
        synchronized (list) {
            writesAsString = this.writes.toString();
        }
        return String.format("%s{writes=%s, committed=%s}", this.getClass().getSimpleName(), writesAsString, this.committed);
    }

    static final class WriteOperation {
        final Write write;
        final DocumentReference documentReference;

        WriteOperation(DocumentReference documentReference, Write write) {
            this.documentReference = documentReference;
            this.write = write;
        }

        public String toString() {
            return String.format("WriteOperation{write=%s, doc=%s}", this.write, this.documentReference);
        }
    }
}

