/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.telemetry;

import com.google.api.gax.tracing.ApiTracer;
import com.google.api.gax.tracing.BaseApiTracer;
import com.google.api.gax.util.TimeConversionUtils;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.threeten.bp.Duration;

class CompositeApiTracer
extends BaseApiTracer {
    private final List<ApiTracer> children;

    public CompositeApiTracer(List<ApiTracer> children) {
        this.children = ImmutableList.copyOf(children);
    }

    @Override
    public ApiTracer.Scope inScope() {
        List childScopes = this.children.stream().map(ApiTracer::inScope).collect(Collectors.toCollection(() -> new ArrayList(this.children.size())));
        return () -> childScopes.forEach(ApiTracer.Scope::close);
    }

    @Override
    public void operationSucceeded() {
        this.children.forEach(ApiTracer::operationSucceeded);
    }

    @Override
    public void operationCancelled() {
        this.children.forEach(ApiTracer::operationCancelled);
    }

    @Override
    public void operationFailed(Throwable error) {
        this.children.forEach(child -> child.operationFailed(error));
    }

    @Override
    public void connectionSelected(String id) {
        this.children.forEach(child -> child.connectionSelected(id));
    }

    @Override
    public void attemptStarted(int attemptNumber) {
        this.children.forEach(child -> child.attemptStarted(null, attemptNumber));
    }

    @Override
    public void attemptStarted(Object request, int attemptNumber) {
        this.children.forEach(child -> child.attemptStarted(request, attemptNumber));
    }

    @Override
    public void attemptSucceeded() {
        this.children.forEach(ApiTracer::attemptSucceeded);
    }

    @Override
    public void attemptCancelled() {
        this.children.forEach(ApiTracer::attemptCancelled);
    }

    @Override
    public void attemptFailed(Throwable error, Duration delay) {
        this.attemptFailedDuration(error, TimeConversionUtils.toJavaTimeDuration(delay));
    }

    @Override
    public void attemptFailedDuration(Throwable error, java.time.Duration delay) {
        this.children.forEach(child -> child.attemptFailedDuration(error, delay));
    }

    @Override
    public void attemptFailedRetriesExhausted(Throwable error) {
        this.children.forEach(child -> child.attemptFailedRetriesExhausted(error));
    }

    @Override
    public void attemptPermanentFailure(Throwable error) {
        this.children.forEach(child -> child.attemptPermanentFailure(error));
    }

    @Override
    public void lroStartFailed(Throwable error) {
        this.children.forEach(child -> child.lroStartFailed(error));
    }

    @Override
    public void lroStartSucceeded() {
        this.children.forEach(ApiTracer::lroStartSucceeded);
    }

    @Override
    public void responseReceived() {
        this.children.forEach(ApiTracer::responseReceived);
    }

    @Override
    public void requestSent() {
        this.children.forEach(ApiTracer::requestSent);
    }

    @Override
    public void batchRequestSent(long elementCount, long requestSize) {
        this.children.forEach(child -> child.batchRequestSent(elementCount, requestSize));
    }
}

