/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.telemetry;

import com.google.api.core.InternalApi;
import com.google.api.gax.tracing.ApiTracer;
import com.google.api.gax.tracing.ApiTracerFactory;
import com.google.api.gax.tracing.BaseApiTracerFactory;
import com.google.api.gax.tracing.SpanName;
import com.google.cloud.firestore.telemetry.CompositeApiTracer;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;

@InternalApi
public class CompositeApiTracerFactory
extends BaseApiTracerFactory {
    private final List<ApiTracerFactory> apiTracerFactories;

    public CompositeApiTracerFactory(List<ApiTracerFactory> apiTracerFactories) {
        this.apiTracerFactories = ImmutableList.copyOf(apiTracerFactories);
    }

    @Override
    public ApiTracer newTracer(ApiTracer parent, SpanName spanName, ApiTracerFactory.OperationType operationType) {
        ArrayList<ApiTracer> children = new ArrayList<ApiTracer>(this.apiTracerFactories.size());
        for (ApiTracerFactory factory : this.apiTracerFactories) {
            children.add(factory.newTracer(parent, spanName, operationType));
        }
        return new CompositeApiTracer(children);
    }
}

