/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.telemetry;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.tracing.ApiTracerFactory;
import com.google.cloud.firestore.FirestoreException;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.telemetry.BuiltinMetricsProvider;
import com.google.cloud.firestore.telemetry.MetricsUtil;
import com.google.cloud.firestore.telemetry.TelemetryConstants;
import com.google.cloud.opentelemetry.metric.GoogleCloudMetricExporter;
import com.google.cloud.opentelemetry.metric.MetricConfiguration;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.Status;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.metrics.InstrumentSelector;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import io.opentelemetry.sdk.metrics.View;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.metrics.export.PeriodicMetricReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

class EnabledMetricsUtil
implements MetricsUtil {
    private BuiltinMetricsProvider defaultMetricsProvider;
    private BuiltinMetricsProvider customMetricsProvider;
    private static final Logger logger = Logger.getLogger(EnabledMetricsUtil.class.getName());

    EnabledMetricsUtil(FirestoreOptions firestoreOptions) {
        try {
            this.configureDefaultMetricsProvider(firestoreOptions);
            this.configureCustomMetricsProvider(firestoreOptions);
        }
        catch (IOException e) {
            logger.warning("Unable to create MetricsUtil object for client side metrics, will skip exporting client side metrics" + e);
        }
    }

    private void configureDefaultMetricsProvider(FirestoreOptions firestoreOptions) throws IOException {
        boolean exportBuiltinMetricsToGoogleCloudMonitoring = firestoreOptions.getOpenTelemetryOptions().exportBuiltinMetricsToGoogleCloudMonitoring();
        OpenTelemetry defaultOpenTelemetry = exportBuiltinMetricsToGoogleCloudMonitoring ? this.getDefaultOpenTelemetryInstance(firestoreOptions.getProjectId()) : OpenTelemetry.noop();
        this.defaultMetricsProvider = new BuiltinMetricsProvider(defaultOpenTelemetry);
    }

    private void configureCustomMetricsProvider(FirestoreOptions firestoreOptions) throws IOException {
        OpenTelemetry customOpenTelemetry = firestoreOptions.getOpenTelemetryOptions().getOpenTelemetry();
        if (customOpenTelemetry == null) {
            customOpenTelemetry = GlobalOpenTelemetry.get();
        }
        this.customMetricsProvider = new BuiltinMetricsProvider(customOpenTelemetry);
    }

    @Override
    public MetricsContext createMetricsContext(String methodName) {
        return new MetricsContext(methodName);
    }

    @Override
    public void addMetricsTracerFactory(List<ApiTracerFactory> apiTracerFactories) {
        this.addTracerFactory(apiTracerFactories, this.defaultMetricsProvider);
        this.addTracerFactory(apiTracerFactories, this.customMetricsProvider);
    }

    private OpenTelemetry getDefaultOpenTelemetryInstance(String projectId) throws IOException {
        SdkMeterProviderBuilder sdkMeterProviderBuilder = SdkMeterProvider.builder();
        for (Map.Entry<InstrumentSelector, View> entry : EnabledMetricsUtil.getAllViews().entrySet()) {
            sdkMeterProviderBuilder.registerView(entry.getKey(), entry.getValue());
        }
        MetricExporter metricExporter = GoogleCloudMetricExporter.createWithConfiguration(MetricConfiguration.builder().setProjectId(projectId).setInstrumentationLibraryLabelsEnabled(false).build());
        sdkMeterProviderBuilder.registerMetricReader(PeriodicMetricReader.create(metricExporter));
        return OpenTelemetrySdk.builder().setMeterProvider(sdkMeterProviderBuilder.build()).build();
    }

    private static Map<InstrumentSelector, View> getAllViews() {
        ImmutableMap.Builder views = ImmutableMap.builder();
        TelemetryConstants.GAX_METRICS.forEach(metric -> EnabledMetricsUtil.defineView(views, metric, "gax-java"));
        TelemetryConstants.FIRESTORE_METRICS.forEach(metric -> EnabledMetricsUtil.defineView(views, metric, "java_firestore"));
        return views.build();
    }

    private static void defineView(ImmutableMap.Builder<InstrumentSelector, View> viewMap, String id, String meter) {
        InstrumentSelector selector = InstrumentSelector.builder().setMeterName(meter).setName("custom.googleapis.com/internal/client/" + id).build();
        ImmutableCollection attributesFilter = ((ImmutableSet.Builder)ImmutableSet.builder().addAll((Iterable)TelemetryConstants.COMMON_ATTRIBUTES.stream().map(AttributeKey::getKey).collect(Collectors.toSet()))).build();
        View view = View.builder().setAttributeFilter((Set<String>)((Object)attributesFilter)).build();
        viewMap.put(selector, view);
    }

    private void addTracerFactory(List<ApiTracerFactory> apiTracerFactories, BuiltinMetricsProvider metricsProvider) {
        ApiTracerFactory tracerFactory = metricsProvider.getApiTracerFactory();
        if (tracerFactory != null) {
            apiTracerFactories.add(tracerFactory);
        }
    }

    private Map<String, String> createAttributes(String status, String methodName) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(TelemetryConstants.METRIC_ATTRIBUTE_KEY_METHOD.getKey(), methodName);
        attributes.put(TelemetryConstants.METRIC_ATTRIBUTE_KEY_STATUS.getKey(), status);
        return attributes;
    }

    private String extractErrorStatus(@Nullable Throwable throwable) {
        if (!(throwable instanceof FirestoreException)) {
            return StatusCode.Code.UNKNOWN.toString();
        }
        Status status = ((FirestoreException)throwable).getStatus();
        if (status == null) {
            return StatusCode.Code.UNKNOWN.toString();
        }
        return status.getCode().name();
    }

    class MetricsContext
    implements MetricsUtil.MetricsContext {
        private final Stopwatch stopwatch = Stopwatch.createStarted();
        private int counter;
        protected final String methodName;

        public MetricsContext(String methodName) {
            this.methodName = methodName;
            this.counter = 0;
        }

        @Override
        public <T> void recordLatencyAtFuture(final TelemetryConstants.MetricType metric, ApiFuture<T> futureValue) {
            ApiFutures.addCallback(futureValue, new ApiFutureCallback<T>(){

                @Override
                public void onFailure(Throwable t2) {
                    MetricsContext.this.recordLatency(metric, t2);
                }

                @Override
                public void onSuccess(T result) {
                    MetricsContext.this.recordLatency(metric);
                }
            }, MoreExecutors.directExecutor());
        }

        @Override
        public void recordLatency(TelemetryConstants.MetricType metric) {
            this.recordLatency(metric, StatusCode.Code.OK.toString());
        }

        @Override
        public void recordLatency(TelemetryConstants.MetricType metric, Throwable t2) {
            this.recordLatency(metric, EnabledMetricsUtil.this.extractErrorStatus(t2));
        }

        private void recordLatency(TelemetryConstants.MetricType metric, String status) {
            double elapsedTime = this.stopwatch.elapsed(TimeUnit.MILLISECONDS);
            Map attributes = EnabledMetricsUtil.this.createAttributes(status, this.methodName);
            EnabledMetricsUtil.this.defaultMetricsProvider.latencyRecorder(metric, elapsedTime, attributes);
            EnabledMetricsUtil.this.customMetricsProvider.latencyRecorder(metric, elapsedTime, attributes);
        }

        @Override
        public void incrementCounter() {
            ++this.counter;
        }

        @Override
        public <T> void recordCounterAtFuture(final TelemetryConstants.MetricType metric, ApiFuture<T> futureValue) {
            ApiFutures.addCallback(futureValue, new ApiFutureCallback<T>(){

                @Override
                public void onFailure(Throwable t2) {
                    MetricsContext.this.recordCounter(metric, EnabledMetricsUtil.this.extractErrorStatus(t2));
                }

                @Override
                public void onSuccess(T result) {
                    MetricsContext.this.recordCounter(metric, StatusCode.Code.OK.toString());
                }
            }, MoreExecutors.directExecutor());
        }

        private void recordCounter(TelemetryConstants.MetricType metric, String status) {
            Map attributes = EnabledMetricsUtil.this.createAttributes(status, this.methodName);
            EnabledMetricsUtil.this.defaultMetricsProvider.counterRecorder(TelemetryConstants.MetricType.TRANSACTION_ATTEMPT_COUNT, this.counter, attributes);
            EnabledMetricsUtil.this.customMetricsProvider.counterRecorder(TelemetryConstants.MetricType.TRANSACTION_ATTEMPT_COUNT, this.counter, attributes);
        }
    }
}

