/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.firestore.v1.FirestoreSettings;
import com.google.cloud.firestore.v1.stub.FirestoreStub;
import com.google.cloud.firestore.v1.stub.FirestoreStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.firestore.v1.BatchGetDocumentsRequest;
import com.google.firestore.v1.BatchGetDocumentsResponse;
import com.google.firestore.v1.BatchWriteRequest;
import com.google.firestore.v1.BatchWriteResponse;
import com.google.firestore.v1.BeginTransactionRequest;
import com.google.firestore.v1.BeginTransactionResponse;
import com.google.firestore.v1.CommitRequest;
import com.google.firestore.v1.CommitResponse;
import com.google.firestore.v1.CreateDocumentRequest;
import com.google.firestore.v1.Cursor;
import com.google.firestore.v1.DeleteDocumentRequest;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.DocumentMask;
import com.google.firestore.v1.GetDocumentRequest;
import com.google.firestore.v1.ListCollectionIdsRequest;
import com.google.firestore.v1.ListCollectionIdsResponse;
import com.google.firestore.v1.ListDocumentsRequest;
import com.google.firestore.v1.ListDocumentsResponse;
import com.google.firestore.v1.ListenRequest;
import com.google.firestore.v1.ListenResponse;
import com.google.firestore.v1.PartitionQueryRequest;
import com.google.firestore.v1.PartitionQueryResponse;
import com.google.firestore.v1.RollbackRequest;
import com.google.firestore.v1.RunAggregationQueryRequest;
import com.google.firestore.v1.RunAggregationQueryResponse;
import com.google.firestore.v1.RunQueryRequest;
import com.google.firestore.v1.RunQueryResponse;
import com.google.firestore.v1.UpdateDocumentRequest;
import com.google.firestore.v1.Write;
import com.google.firestore.v1.WriteRequest;
import com.google.firestore.v1.WriteResponse;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class FirestoreClient
implements BackgroundResource {
    private final FirestoreSettings settings;
    private final FirestoreStub stub;

    public static final FirestoreClient create() throws IOException {
        return FirestoreClient.create(FirestoreSettings.newBuilder().build());
    }

    public static final FirestoreClient create(FirestoreSettings settings) throws IOException {
        return new FirestoreClient(settings);
    }

    public static final FirestoreClient create(FirestoreStub stub) {
        return new FirestoreClient(stub);
    }

    protected FirestoreClient(FirestoreSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((FirestoreStubSettings)settings.getStubSettings()).createStub();
    }

    protected FirestoreClient(FirestoreStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final FirestoreSettings getSettings() {
        return this.settings;
    }

    public FirestoreStub getStub() {
        return this.stub;
    }

    public final Document getDocument(GetDocumentRequest request) {
        return this.getDocumentCallable().call(request);
    }

    public final UnaryCallable<GetDocumentRequest, Document> getDocumentCallable() {
        return this.stub.getDocumentCallable();
    }

    public final ListDocumentsPagedResponse listDocuments(ListDocumentsRequest request) {
        return this.listDocumentsPagedCallable().call(request);
    }

    public final UnaryCallable<ListDocumentsRequest, ListDocumentsPagedResponse> listDocumentsPagedCallable() {
        return this.stub.listDocumentsPagedCallable();
    }

    public final UnaryCallable<ListDocumentsRequest, ListDocumentsResponse> listDocumentsCallable() {
        return this.stub.listDocumentsCallable();
    }

    public final Document updateDocument(Document document, DocumentMask updateMask) {
        UpdateDocumentRequest request = UpdateDocumentRequest.newBuilder().setDocument(document).setUpdateMask(updateMask).build();
        return this.updateDocument(request);
    }

    public final Document updateDocument(UpdateDocumentRequest request) {
        return this.updateDocumentCallable().call(request);
    }

    public final UnaryCallable<UpdateDocumentRequest, Document> updateDocumentCallable() {
        return this.stub.updateDocumentCallable();
    }

    public final void deleteDocument(String name) {
        DeleteDocumentRequest request = DeleteDocumentRequest.newBuilder().setName(name).build();
        this.deleteDocument(request);
    }

    public final void deleteDocument(DeleteDocumentRequest request) {
        this.deleteDocumentCallable().call(request);
    }

    public final UnaryCallable<DeleteDocumentRequest, Empty> deleteDocumentCallable() {
        return this.stub.deleteDocumentCallable();
    }

    public final ServerStreamingCallable<BatchGetDocumentsRequest, BatchGetDocumentsResponse> batchGetDocumentsCallable() {
        return this.stub.batchGetDocumentsCallable();
    }

    public final BeginTransactionResponse beginTransaction(String database) {
        BeginTransactionRequest request = BeginTransactionRequest.newBuilder().setDatabase(database).build();
        return this.beginTransaction(request);
    }

    public final BeginTransactionResponse beginTransaction(BeginTransactionRequest request) {
        return this.beginTransactionCallable().call(request);
    }

    public final UnaryCallable<BeginTransactionRequest, BeginTransactionResponse> beginTransactionCallable() {
        return this.stub.beginTransactionCallable();
    }

    public final CommitResponse commit(String database, List<Write> writes) {
        CommitRequest request = CommitRequest.newBuilder().setDatabase(database).addAllWrites(writes).build();
        return this.commit(request);
    }

    public final CommitResponse commit(CommitRequest request) {
        return this.commitCallable().call(request);
    }

    public final UnaryCallable<CommitRequest, CommitResponse> commitCallable() {
        return this.stub.commitCallable();
    }

    public final void rollback(String database, ByteString transaction) {
        RollbackRequest request = RollbackRequest.newBuilder().setDatabase(database).setTransaction(transaction).build();
        this.rollback(request);
    }

    public final void rollback(RollbackRequest request) {
        this.rollbackCallable().call(request);
    }

    public final UnaryCallable<RollbackRequest, Empty> rollbackCallable() {
        return this.stub.rollbackCallable();
    }

    public final ServerStreamingCallable<RunQueryRequest, RunQueryResponse> runQueryCallable() {
        return this.stub.runQueryCallable();
    }

    public final ServerStreamingCallable<RunAggregationQueryRequest, RunAggregationQueryResponse> runAggregationQueryCallable() {
        return this.stub.runAggregationQueryCallable();
    }

    public final PartitionQueryPagedResponse partitionQuery(PartitionQueryRequest request) {
        return this.partitionQueryPagedCallable().call(request);
    }

    public final UnaryCallable<PartitionQueryRequest, PartitionQueryPagedResponse> partitionQueryPagedCallable() {
        return this.stub.partitionQueryPagedCallable();
    }

    public final UnaryCallable<PartitionQueryRequest, PartitionQueryResponse> partitionQueryCallable() {
        return this.stub.partitionQueryCallable();
    }

    public final BidiStreamingCallable<WriteRequest, WriteResponse> writeCallable() {
        return this.stub.writeCallable();
    }

    public final BidiStreamingCallable<ListenRequest, ListenResponse> listenCallable() {
        return this.stub.listenCallable();
    }

    public final ListCollectionIdsPagedResponse listCollectionIds(String parent) {
        ListCollectionIdsRequest request = ListCollectionIdsRequest.newBuilder().setParent(parent).build();
        return this.listCollectionIds(request);
    }

    public final ListCollectionIdsPagedResponse listCollectionIds(ListCollectionIdsRequest request) {
        return this.listCollectionIdsPagedCallable().call(request);
    }

    public final UnaryCallable<ListCollectionIdsRequest, ListCollectionIdsPagedResponse> listCollectionIdsPagedCallable() {
        return this.stub.listCollectionIdsPagedCallable();
    }

    public final UnaryCallable<ListCollectionIdsRequest, ListCollectionIdsResponse> listCollectionIdsCallable() {
        return this.stub.listCollectionIdsCallable();
    }

    public final BatchWriteResponse batchWrite(BatchWriteRequest request) {
        return this.batchWriteCallable().call(request);
    }

    public final UnaryCallable<BatchWriteRequest, BatchWriteResponse> batchWriteCallable() {
        return this.stub.batchWriteCallable();
    }

    public final Document createDocument(CreateDocumentRequest request) {
        return this.createDocumentCallable().call(request);
    }

    public final UnaryCallable<CreateDocumentRequest, Document> createDocumentCallable() {
        return this.stub.createDocumentCallable();
    }

    @Override
    public final void close() {
        this.stub.close();
    }

    @Override
    public void shutdown() {
        this.stub.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    @Override
    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    @Override
    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListDocumentsPagedResponse
    extends AbstractPagedListResponse<ListDocumentsRequest, ListDocumentsResponse, Document, ListDocumentsPage, ListDocumentsFixedSizeCollection> {
        public static ApiFuture<ListDocumentsPagedResponse> createAsync(PageContext<ListDocumentsRequest, ListDocumentsResponse, Document> context, ApiFuture<ListDocumentsResponse> futureResponse) {
            ApiFuture<ListDocumentsPage> futurePage = ListDocumentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDocumentsPagedResponse((ListDocumentsPage)input), MoreExecutors.directExecutor());
        }

        private ListDocumentsPagedResponse(ListDocumentsPage page) {
            super(page, ListDocumentsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class PartitionQueryPagedResponse
    extends AbstractPagedListResponse<PartitionQueryRequest, PartitionQueryResponse, Cursor, PartitionQueryPage, PartitionQueryFixedSizeCollection> {
        public static ApiFuture<PartitionQueryPagedResponse> createAsync(PageContext<PartitionQueryRequest, PartitionQueryResponse, Cursor> context, ApiFuture<PartitionQueryResponse> futureResponse) {
            ApiFuture<PartitionQueryPage> futurePage = PartitionQueryPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new PartitionQueryPagedResponse((PartitionQueryPage)input), MoreExecutors.directExecutor());
        }

        private PartitionQueryPagedResponse(PartitionQueryPage page) {
            super(page, PartitionQueryFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListCollectionIdsPagedResponse
    extends AbstractPagedListResponse<ListCollectionIdsRequest, ListCollectionIdsResponse, String, ListCollectionIdsPage, ListCollectionIdsFixedSizeCollection> {
        public static ApiFuture<ListCollectionIdsPagedResponse> createAsync(PageContext<ListCollectionIdsRequest, ListCollectionIdsResponse, String> context, ApiFuture<ListCollectionIdsResponse> futureResponse) {
            ApiFuture<ListCollectionIdsPage> futurePage = ListCollectionIdsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCollectionIdsPagedResponse((ListCollectionIdsPage)input), MoreExecutors.directExecutor());
        }

        private ListCollectionIdsPagedResponse(ListCollectionIdsPage page) {
            super(page, ListCollectionIdsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListCollectionIdsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCollectionIdsRequest, ListCollectionIdsResponse, String, ListCollectionIdsPage, ListCollectionIdsFixedSizeCollection> {
        private ListCollectionIdsFixedSizeCollection(List<ListCollectionIdsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCollectionIdsFixedSizeCollection createEmptyCollection() {
            return new ListCollectionIdsFixedSizeCollection(null, 0);
        }

        @Override
        protected ListCollectionIdsFixedSizeCollection createCollection(List<ListCollectionIdsPage> pages, int collectionSize) {
            return new ListCollectionIdsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCollectionIdsPage
    extends AbstractPage<ListCollectionIdsRequest, ListCollectionIdsResponse, String, ListCollectionIdsPage> {
        private ListCollectionIdsPage(PageContext<ListCollectionIdsRequest, ListCollectionIdsResponse, String> context, ListCollectionIdsResponse response) {
            super(context, response);
        }

        private static ListCollectionIdsPage createEmptyPage() {
            return new ListCollectionIdsPage(null, null);
        }

        @Override
        protected ListCollectionIdsPage createPage(PageContext<ListCollectionIdsRequest, ListCollectionIdsResponse, String> context, ListCollectionIdsResponse response) {
            return new ListCollectionIdsPage(context, response);
        }

        @Override
        public ApiFuture<ListCollectionIdsPage> createPageAsync(PageContext<ListCollectionIdsRequest, ListCollectionIdsResponse, String> context, ApiFuture<ListCollectionIdsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class PartitionQueryFixedSizeCollection
    extends AbstractFixedSizeCollection<PartitionQueryRequest, PartitionQueryResponse, Cursor, PartitionQueryPage, PartitionQueryFixedSizeCollection> {
        private PartitionQueryFixedSizeCollection(List<PartitionQueryPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static PartitionQueryFixedSizeCollection createEmptyCollection() {
            return new PartitionQueryFixedSizeCollection(null, 0);
        }

        @Override
        protected PartitionQueryFixedSizeCollection createCollection(List<PartitionQueryPage> pages, int collectionSize) {
            return new PartitionQueryFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class PartitionQueryPage
    extends AbstractPage<PartitionQueryRequest, PartitionQueryResponse, Cursor, PartitionQueryPage> {
        private PartitionQueryPage(PageContext<PartitionQueryRequest, PartitionQueryResponse, Cursor> context, PartitionQueryResponse response) {
            super(context, response);
        }

        private static PartitionQueryPage createEmptyPage() {
            return new PartitionQueryPage(null, null);
        }

        @Override
        protected PartitionQueryPage createPage(PageContext<PartitionQueryRequest, PartitionQueryResponse, Cursor> context, PartitionQueryResponse response) {
            return new PartitionQueryPage(context, response);
        }

        @Override
        public ApiFuture<PartitionQueryPage> createPageAsync(PageContext<PartitionQueryRequest, PartitionQueryResponse, Cursor> context, ApiFuture<PartitionQueryResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDocumentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDocumentsRequest, ListDocumentsResponse, Document, ListDocumentsPage, ListDocumentsFixedSizeCollection> {
        private ListDocumentsFixedSizeCollection(List<ListDocumentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDocumentsFixedSizeCollection createEmptyCollection() {
            return new ListDocumentsFixedSizeCollection(null, 0);
        }

        @Override
        protected ListDocumentsFixedSizeCollection createCollection(List<ListDocumentsPage> pages, int collectionSize) {
            return new ListDocumentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDocumentsPage
    extends AbstractPage<ListDocumentsRequest, ListDocumentsResponse, Document, ListDocumentsPage> {
        private ListDocumentsPage(PageContext<ListDocumentsRequest, ListDocumentsResponse, Document> context, ListDocumentsResponse response) {
            super(context, response);
        }

        private static ListDocumentsPage createEmptyPage() {
            return new ListDocumentsPage(null, null);
        }

        @Override
        protected ListDocumentsPage createPage(PageContext<ListDocumentsRequest, ListDocumentsResponse, Document> context, ListDocumentsResponse response) {
            return new ListDocumentsPage(context, response);
        }

        @Override
        public ApiFuture<ListDocumentsPage> createPageAsync(PageContext<ListDocumentsRequest, ListDocumentsResponse, Document> context, ApiFuture<ListDocumentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }
}

