/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.v1.stub;

import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.firestore.v1.FirestoreClient;
import com.google.cloud.firestore.v1.stub.FirestoreStub;
import com.google.cloud.firestore.v1.stub.FirestoreStubSettings;
import com.google.cloud.firestore.v1.stub.HttpJsonFirestoreCallableFactory;
import com.google.firestore.v1.BatchGetDocumentsRequest;
import com.google.firestore.v1.BatchGetDocumentsResponse;
import com.google.firestore.v1.BatchWriteRequest;
import com.google.firestore.v1.BatchWriteResponse;
import com.google.firestore.v1.BeginTransactionRequest;
import com.google.firestore.v1.BeginTransactionResponse;
import com.google.firestore.v1.CommitRequest;
import com.google.firestore.v1.CommitResponse;
import com.google.firestore.v1.CreateDocumentRequest;
import com.google.firestore.v1.DeleteDocumentRequest;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.GetDocumentRequest;
import com.google.firestore.v1.ListCollectionIdsRequest;
import com.google.firestore.v1.ListCollectionIdsResponse;
import com.google.firestore.v1.ListDocumentsRequest;
import com.google.firestore.v1.ListDocumentsResponse;
import com.google.firestore.v1.ListenRequest;
import com.google.firestore.v1.ListenResponse;
import com.google.firestore.v1.PartitionQueryRequest;
import com.google.firestore.v1.PartitionQueryResponse;
import com.google.firestore.v1.RollbackRequest;
import com.google.firestore.v1.RunAggregationQueryRequest;
import com.google.firestore.v1.RunAggregationQueryResponse;
import com.google.firestore.v1.RunQueryRequest;
import com.google.firestore.v1.RunQueryResponse;
import com.google.firestore.v1.UpdateDocumentRequest;
import com.google.firestore.v1.WriteRequest;
import com.google.firestore.v1.WriteResponse;
import com.google.protobuf.Empty;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class HttpJsonFirestoreStub
extends FirestoreStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<GetDocumentRequest, Document> getDocumentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.firestore.v1.Firestore/GetDocument").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter(ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/databases/*/documents/*/**}", request -> {
        HashMap<String, String> fields = new HashMap<String, String>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "mask", request.getMask());
        serializer.putQueryParam(fields, "readTime", request.getReadTime());
        serializer.putQueryParam(fields, "transaction", request.getTransaction());
        serializer.putQueryParam(fields, "$alt", "json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser(ProtoMessageResponseParser.newBuilder().setDefaultInstance(Document.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListDocumentsRequest, ListDocumentsResponse> listDocumentsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.firestore.v1.Firestore/ListDocuments").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter(ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/databases/*/documents/*/**}/{collectionId}", request -> {
        HashMap<String, String> fields = new HashMap<String, String>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "collectionId", request.getCollectionId());
        serializer.putPathParam(fields, "parent", request.getParent());
        return fields;
    }).setAdditionalPaths("/v1/{parent=projects/*/databases/*/documents}/{collectionId}").setQueryParamsExtractor(request -> {
        HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "mask", request.getMask());
        serializer.putQueryParam(fields, "orderBy", request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", request.getPageToken());
        serializer.putQueryParam(fields, "readTime", request.getReadTime());
        serializer.putQueryParam(fields, "showMissing", request.getShowMissing());
        serializer.putQueryParam(fields, "transaction", request.getTransaction());
        serializer.putQueryParam(fields, "$alt", "json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser(ProtoMessageResponseParser.newBuilder().setDefaultInstance(ListDocumentsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateDocumentRequest, Document> updateDocumentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.firestore.v1.Firestore/UpdateDocument").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter(ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{document.name=projects/*/databases/*/documents/*/**}", request -> {
        HashMap<String, String> fields = new HashMap<String, String>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "document.name", request.getDocument().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "currentDocument", request.getCurrentDocument());
        serializer.putQueryParam(fields, "mask", request.getMask());
        serializer.putQueryParam(fields, "updateMask", request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", "json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("document", request.getDocument(), true)).build()).setResponseParser(ProtoMessageResponseParser.newBuilder().setDefaultInstance(Document.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteDocumentRequest, Empty> deleteDocumentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.firestore.v1.Firestore/DeleteDocument").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter(ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/databases/*/documents/*/**}", request -> {
        HashMap<String, String> fields = new HashMap<String, String>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "currentDocument", request.getCurrentDocument());
        serializer.putQueryParam(fields, "$alt", "json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser(ProtoMessageResponseParser.newBuilder().setDefaultInstance(Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<BatchGetDocumentsRequest, BatchGetDocumentsResponse> batchGetDocumentsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.firestore.v1.Firestore/BatchGetDocuments").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.SERVER_STREAMING).setRequestFormatter(ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{database=projects/*/databases/*}/documents:batchGet", request -> {
        HashMap<String, String> fields = new HashMap<String, String>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "database", request.getDatabase());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", "json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", request.toBuilder().clearDatabase().build(), true)).build()).setResponseParser(ProtoMessageResponseParser.newBuilder().setDefaultInstance(BatchGetDocumentsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<BeginTransactionRequest, BeginTransactionResponse> beginTransactionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.firestore.v1.Firestore/BeginTransaction").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter(ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{database=projects/*/databases/*}/documents:beginTransaction", request -> {
        HashMap<String, String> fields = new HashMap<String, String>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "database", request.getDatabase());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", "json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", request.toBuilder().clearDatabase().build(), true)).build()).setResponseParser(ProtoMessageResponseParser.newBuilder().setDefaultInstance(BeginTransactionResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CommitRequest, CommitResponse> commitMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.firestore.v1.Firestore/Commit").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter(ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{database=projects/*/databases/*}/documents:commit", request -> {
        HashMap<String, String> fields = new HashMap<String, String>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "database", request.getDatabase());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", "json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", request.toBuilder().clearDatabase().build(), true)).build()).setResponseParser(ProtoMessageResponseParser.newBuilder().setDefaultInstance(CommitResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<RollbackRequest, Empty> rollbackMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.firestore.v1.Firestore/Rollback").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter(ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{database=projects/*/databases/*}/documents:rollback", request -> {
        HashMap<String, String> fields = new HashMap<String, String>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "database", request.getDatabase());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", "json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", request.toBuilder().clearDatabase().build(), true)).build()).setResponseParser(ProtoMessageResponseParser.newBuilder().setDefaultInstance(Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<RunQueryRequest, RunQueryResponse> runQueryMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.firestore.v1.Firestore/RunQuery").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.SERVER_STREAMING).setRequestFormatter(ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/databases/*/documents}:runQuery", request -> {
        HashMap<String, String> fields = new HashMap<String, String>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", request.getParent());
        return fields;
    }).setAdditionalPaths("/v1/{parent=projects/*/databases/*/documents/*/**}:runQuery").setQueryParamsExtractor(request -> {
        HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", "json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", request.toBuilder().clearParent().build(), true)).build()).setResponseParser(ProtoMessageResponseParser.newBuilder().setDefaultInstance(RunQueryResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<RunAggregationQueryRequest, RunAggregationQueryResponse> runAggregationQueryMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.firestore.v1.Firestore/RunAggregationQuery").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.SERVER_STREAMING).setRequestFormatter(ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/databases/*/documents}:runAggregationQuery", request -> {
        HashMap<String, String> fields = new HashMap<String, String>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", request.getParent());
        return fields;
    }).setAdditionalPaths("/v1/{parent=projects/*/databases/*/documents/*/**}:runAggregationQuery").setQueryParamsExtractor(request -> {
        HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", "json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", request.toBuilder().clearParent().build(), true)).build()).setResponseParser(ProtoMessageResponseParser.newBuilder().setDefaultInstance(RunAggregationQueryResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<PartitionQueryRequest, PartitionQueryResponse> partitionQueryMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.firestore.v1.Firestore/PartitionQuery").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter(ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/databases/*/documents}:partitionQuery", request -> {
        HashMap<String, String> fields = new HashMap<String, String>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", request.getParent());
        return fields;
    }).setAdditionalPaths("/v1/{parent=projects/*/databases/*/documents/*/**}:partitionQuery").setQueryParamsExtractor(request -> {
        HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", "json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", request.toBuilder().clearParent().build(), true)).build()).setResponseParser(ProtoMessageResponseParser.newBuilder().setDefaultInstance(PartitionQueryResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListCollectionIdsRequest, ListCollectionIdsResponse> listCollectionIdsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.firestore.v1.Firestore/ListCollectionIds").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter(ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/databases/*/documents}:listCollectionIds", request -> {
        HashMap<String, String> fields = new HashMap<String, String>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", request.getParent());
        return fields;
    }).setAdditionalPaths("/v1/{parent=projects/*/databases/*/documents/*/**}:listCollectionIds").setQueryParamsExtractor(request -> {
        HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", "json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", request.toBuilder().clearParent().build(), true)).build()).setResponseParser(ProtoMessageResponseParser.newBuilder().setDefaultInstance(ListCollectionIdsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<BatchWriteRequest, BatchWriteResponse> batchWriteMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.firestore.v1.Firestore/BatchWrite").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter(ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{database=projects/*/databases/*}/documents:batchWrite", request -> {
        HashMap<String, String> fields = new HashMap<String, String>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "database", request.getDatabase());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", "json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", request.toBuilder().clearDatabase().build(), true)).build()).setResponseParser(ProtoMessageResponseParser.newBuilder().setDefaultInstance(BatchWriteResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateDocumentRequest, Document> createDocumentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.firestore.v1.Firestore/CreateDocument").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter(ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/databases/*/documents/**}/{collectionId}", request -> {
        HashMap<String, String> fields = new HashMap<String, String>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "collectionId", request.getCollectionId());
        serializer.putPathParam(fields, "parent", request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "documentId", request.getDocumentId());
        serializer.putQueryParam(fields, "mask", request.getMask());
        serializer.putQueryParam(fields, "$alt", "json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("document", request.getDocument(), true)).build()).setResponseParser(ProtoMessageResponseParser.newBuilder().setDefaultInstance(Document.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<GetDocumentRequest, Document> getDocumentCallable;
    private final UnaryCallable<ListDocumentsRequest, ListDocumentsResponse> listDocumentsCallable;
    private final UnaryCallable<ListDocumentsRequest, FirestoreClient.ListDocumentsPagedResponse> listDocumentsPagedCallable;
    private final UnaryCallable<UpdateDocumentRequest, Document> updateDocumentCallable;
    private final UnaryCallable<DeleteDocumentRequest, Empty> deleteDocumentCallable;
    private final ServerStreamingCallable<BatchGetDocumentsRequest, BatchGetDocumentsResponse> batchGetDocumentsCallable;
    private final UnaryCallable<BeginTransactionRequest, BeginTransactionResponse> beginTransactionCallable;
    private final UnaryCallable<CommitRequest, CommitResponse> commitCallable;
    private final UnaryCallable<RollbackRequest, Empty> rollbackCallable;
    private final ServerStreamingCallable<RunQueryRequest, RunQueryResponse> runQueryCallable;
    private final ServerStreamingCallable<RunAggregationQueryRequest, RunAggregationQueryResponse> runAggregationQueryCallable;
    private final UnaryCallable<PartitionQueryRequest, PartitionQueryResponse> partitionQueryCallable;
    private final UnaryCallable<PartitionQueryRequest, FirestoreClient.PartitionQueryPagedResponse> partitionQueryPagedCallable;
    private final UnaryCallable<ListCollectionIdsRequest, ListCollectionIdsResponse> listCollectionIdsCallable;
    private final UnaryCallable<ListCollectionIdsRequest, FirestoreClient.ListCollectionIdsPagedResponse> listCollectionIdsPagedCallable;
    private final UnaryCallable<BatchWriteRequest, BatchWriteResponse> batchWriteCallable;
    private final UnaryCallable<CreateDocumentRequest, Document> createDocumentCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonFirestoreStub create(FirestoreStubSettings settings) throws IOException {
        return new HttpJsonFirestoreStub(settings, ClientContext.create(settings));
    }

    public static final HttpJsonFirestoreStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonFirestoreStub(FirestoreStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonFirestoreStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonFirestoreStub(FirestoreStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonFirestoreStub(FirestoreStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonFirestoreCallableFactory());
    }

    protected HttpJsonFirestoreStub(FirestoreStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings<GetDocumentRequest, Document> getDocumentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getDocumentMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings<ListDocumentsRequest, ListDocumentsResponse> listDocumentsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listDocumentsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("collection_id", String.valueOf(request.getCollectionId()));
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings<UpdateDocumentRequest, Document> updateDocumentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateDocumentMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("document.name", String.valueOf(request.getDocument().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings<DeleteDocumentRequest, Empty> deleteDocumentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteDocumentMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings<BatchGetDocumentsRequest, BatchGetDocumentsResponse> batchGetDocumentsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(batchGetDocumentsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("database", String.valueOf(request.getDatabase()));
            return builder.build();
        }).build();
        HttpJsonCallSettings<BeginTransactionRequest, BeginTransactionResponse> beginTransactionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(beginTransactionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("database", String.valueOf(request.getDatabase()));
            return builder.build();
        }).build();
        HttpJsonCallSettings<CommitRequest, CommitResponse> commitTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(commitMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("database", String.valueOf(request.getDatabase()));
            return builder.build();
        }).build();
        HttpJsonCallSettings<RollbackRequest, Empty> rollbackTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(rollbackMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("database", String.valueOf(request.getDatabase()));
            return builder.build();
        }).build();
        HttpJsonCallSettings<RunQueryRequest, RunQueryResponse> runQueryTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(runQueryMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings<RunAggregationQueryRequest, RunAggregationQueryResponse> runAggregationQueryTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(runAggregationQueryMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings<PartitionQueryRequest, PartitionQueryResponse> partitionQueryTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(partitionQueryMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings<ListCollectionIdsRequest, ListCollectionIdsResponse> listCollectionIdsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listCollectionIdsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings<BatchWriteRequest, BatchWriteResponse> batchWriteTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(batchWriteMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("database", String.valueOf(request.getDatabase()));
            return builder.build();
        }).build();
        HttpJsonCallSettings<CreateDocumentRequest, Document> createDocumentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createDocumentMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("collection_id", String.valueOf(request.getCollectionId()));
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.getDocumentCallable = callableFactory.createUnaryCallable(getDocumentTransportSettings, settings.getDocumentSettings(), clientContext);
        this.listDocumentsCallable = callableFactory.createUnaryCallable(listDocumentsTransportSettings, settings.listDocumentsSettings(), clientContext);
        this.listDocumentsPagedCallable = callableFactory.createPagedCallable(listDocumentsTransportSettings, settings.listDocumentsSettings(), clientContext);
        this.updateDocumentCallable = callableFactory.createUnaryCallable(updateDocumentTransportSettings, settings.updateDocumentSettings(), clientContext);
        this.deleteDocumentCallable = callableFactory.createUnaryCallable(deleteDocumentTransportSettings, settings.deleteDocumentSettings(), clientContext);
        this.batchGetDocumentsCallable = callableFactory.createServerStreamingCallable(batchGetDocumentsTransportSettings, settings.batchGetDocumentsSettings(), clientContext);
        this.beginTransactionCallable = callableFactory.createUnaryCallable(beginTransactionTransportSettings, settings.beginTransactionSettings(), clientContext);
        this.commitCallable = callableFactory.createUnaryCallable(commitTransportSettings, settings.commitSettings(), clientContext);
        this.rollbackCallable = callableFactory.createUnaryCallable(rollbackTransportSettings, settings.rollbackSettings(), clientContext);
        this.runQueryCallable = callableFactory.createServerStreamingCallable(runQueryTransportSettings, settings.runQuerySettings(), clientContext);
        this.runAggregationQueryCallable = callableFactory.createServerStreamingCallable(runAggregationQueryTransportSettings, settings.runAggregationQuerySettings(), clientContext);
        this.partitionQueryCallable = callableFactory.createUnaryCallable(partitionQueryTransportSettings, settings.partitionQuerySettings(), clientContext);
        this.partitionQueryPagedCallable = callableFactory.createPagedCallable(partitionQueryTransportSettings, settings.partitionQuerySettings(), clientContext);
        this.listCollectionIdsCallable = callableFactory.createUnaryCallable(listCollectionIdsTransportSettings, settings.listCollectionIdsSettings(), clientContext);
        this.listCollectionIdsPagedCallable = callableFactory.createPagedCallable(listCollectionIdsTransportSettings, settings.listCollectionIdsSettings(), clientContext);
        this.batchWriteCallable = callableFactory.createUnaryCallable(batchWriteTransportSettings, settings.batchWriteSettings(), clientContext);
        this.createDocumentCallable = callableFactory.createUnaryCallable(createDocumentTransportSettings, settings.createDocumentSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(getDocumentMethodDescriptor);
        methodDescriptors.add(listDocumentsMethodDescriptor);
        methodDescriptors.add(updateDocumentMethodDescriptor);
        methodDescriptors.add(deleteDocumentMethodDescriptor);
        methodDescriptors.add(batchGetDocumentsMethodDescriptor);
        methodDescriptors.add(beginTransactionMethodDescriptor);
        methodDescriptors.add(commitMethodDescriptor);
        methodDescriptors.add(rollbackMethodDescriptor);
        methodDescriptors.add(runQueryMethodDescriptor);
        methodDescriptors.add(runAggregationQueryMethodDescriptor);
        methodDescriptors.add(partitionQueryMethodDescriptor);
        methodDescriptors.add(listCollectionIdsMethodDescriptor);
        methodDescriptors.add(batchWriteMethodDescriptor);
        methodDescriptors.add(createDocumentMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<GetDocumentRequest, Document> getDocumentCallable() {
        return this.getDocumentCallable;
    }

    @Override
    public UnaryCallable<ListDocumentsRequest, ListDocumentsResponse> listDocumentsCallable() {
        return this.listDocumentsCallable;
    }

    @Override
    public UnaryCallable<ListDocumentsRequest, FirestoreClient.ListDocumentsPagedResponse> listDocumentsPagedCallable() {
        return this.listDocumentsPagedCallable;
    }

    @Override
    public UnaryCallable<UpdateDocumentRequest, Document> updateDocumentCallable() {
        return this.updateDocumentCallable;
    }

    @Override
    public UnaryCallable<DeleteDocumentRequest, Empty> deleteDocumentCallable() {
        return this.deleteDocumentCallable;
    }

    @Override
    public ServerStreamingCallable<BatchGetDocumentsRequest, BatchGetDocumentsResponse> batchGetDocumentsCallable() {
        return this.batchGetDocumentsCallable;
    }

    @Override
    public UnaryCallable<BeginTransactionRequest, BeginTransactionResponse> beginTransactionCallable() {
        return this.beginTransactionCallable;
    }

    @Override
    public UnaryCallable<CommitRequest, CommitResponse> commitCallable() {
        return this.commitCallable;
    }

    @Override
    public UnaryCallable<RollbackRequest, Empty> rollbackCallable() {
        return this.rollbackCallable;
    }

    @Override
    public ServerStreamingCallable<RunQueryRequest, RunQueryResponse> runQueryCallable() {
        return this.runQueryCallable;
    }

    @Override
    public ServerStreamingCallable<RunAggregationQueryRequest, RunAggregationQueryResponse> runAggregationQueryCallable() {
        return this.runAggregationQueryCallable;
    }

    @Override
    public UnaryCallable<PartitionQueryRequest, PartitionQueryResponse> partitionQueryCallable() {
        return this.partitionQueryCallable;
    }

    @Override
    public UnaryCallable<PartitionQueryRequest, FirestoreClient.PartitionQueryPagedResponse> partitionQueryPagedCallable() {
        return this.partitionQueryPagedCallable;
    }

    @Override
    public UnaryCallable<ListCollectionIdsRequest, ListCollectionIdsResponse> listCollectionIdsCallable() {
        return this.listCollectionIdsCallable;
    }

    @Override
    public UnaryCallable<ListCollectionIdsRequest, FirestoreClient.ListCollectionIdsPagedResponse> listCollectionIdsPagedCallable() {
        return this.listCollectionIdsPagedCallable;
    }

    @Override
    public UnaryCallable<BatchWriteRequest, BatchWriteResponse> batchWriteCallable() {
        return this.batchWriteCallable;
    }

    @Override
    public UnaryCallable<CreateDocumentRequest, Document> createDocumentCallable() {
        return this.createDocumentCallable;
    }

    @Override
    public BidiStreamingCallable<WriteRequest, WriteResponse> writeCallable() {
        throw new UnsupportedOperationException("Not implemented: writeCallable(). REST transport is not implemented for this method yet.");
    }

    @Override
    public BidiStreamingCallable<ListenRequest, ListenResponse> listenCallable() {
        throw new UnsupportedOperationException("Not implemented: listenCallable(). REST transport is not implemented for this method yet.");
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    @Override
    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    @Override
    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    @Override
    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

