/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.cloud.ReadChannel;
import com.google.cloud.WriteChannel;
import com.google.cloud.storage.Acl;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.CopyWriter;
import com.google.cloud.storage.Option;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageClass;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.TransportCompatibility;
import com.google.cloud.storage.UnifiedOpts;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Path;
import java.security.Key;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.NonNull;

@TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
public class Blob
extends BlobInfo {
    private static final long serialVersionUID = 5007541696912440917L;
    private final StorageOptions options;
    private transient Storage storage;

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public void downloadTo(Path path, BlobSourceOption ... options) {
        this.storage.downloadTo(this.getBlobId(), path, BlobSourceOption.toSourceOptions(this, options));
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public void downloadTo(OutputStream outputStream, BlobSourceOption ... options) {
        this.storage.downloadTo(this.getBlobId(), outputStream, BlobSourceOption.toSourceOptions(this, options));
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public void downloadTo(Path path) {
        this.downloadTo(path, new BlobSourceOption[0]);
    }

    Blob(Storage storage, BlobInfo.BuilderImpl infoBuilder) {
        super(infoBuilder);
        this.storage = Preconditions.checkNotNull(storage);
        this.options = (StorageOptions)storage.getOptions();
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public boolean exists(BlobSourceOption ... options) {
        int length = options.length;
        Storage.BlobGetOption[] getOptions = Arrays.copyOf(BlobSourceOption.toGetOptions(this, options), length + 1);
        getOptions[length] = Storage.BlobGetOption.fields(new Storage.BlobField[0]);
        return this.storage.get(this.getBlobId(), getOptions) != null;
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public byte[] getContent(BlobSourceOption ... options) {
        return this.storage.readAllBytes(this.getBlobId(), BlobSourceOption.toSourceOptions(this, options));
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Blob reload(BlobSourceOption ... options) {
        BlobId idWithoutGeneration = BlobId.of(this.getBucket(), this.getName());
        return this.storage.get(idWithoutGeneration, BlobSourceOption.toGetOptions(this, options));
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Blob update(Storage.BlobTargetOption ... options) {
        return this.storage.update((BlobInfo)this, options);
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public boolean delete(BlobSourceOption ... options) {
        return this.storage.delete(this.getBlobId(), BlobSourceOption.toSourceOptions(this, options));
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public CopyWriter copyTo(BlobId targetBlob, BlobSourceOption ... options) {
        Storage.CopyRequest copyRequest = Storage.CopyRequest.newBuilder().setSource(this.getBucket(), this.getName()).setSourceOptions(BlobSourceOption.toSourceOptions(this, options)).setTarget(targetBlob).build();
        return this.storage.copy(copyRequest);
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public CopyWriter copyTo(String targetBucket, BlobSourceOption ... options) {
        return this.copyTo(targetBucket, this.getName(), options);
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public CopyWriter copyTo(String targetBucket, String targetBlob, BlobSourceOption ... options) {
        return this.copyTo(BlobId.of(targetBucket, targetBlob), options);
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public ReadChannel reader(BlobSourceOption ... options) {
        return this.storage.reader(this.getBlobId(), BlobSourceOption.toSourceOptions(this, options));
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public WriteChannel writer(Storage.BlobWriteOption ... options) {
        return this.storage.writer(this, options);
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
    public URL signUrl(long duration, TimeUnit unit, Storage.SignUrlOption ... options) {
        return this.storage.signUrl(this, duration, unit, options);
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Acl getAcl(Acl.Entity entity) {
        return this.storage.getAcl(this.getBlobId(), entity);
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public boolean deleteAcl(Acl.Entity entity) {
        return this.storage.deleteAcl(this.getBlobId(), entity);
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Acl createAcl(Acl acl) {
        return this.storage.createAcl(this.getBlobId(), acl);
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Acl updateAcl(Acl acl) {
        return this.storage.updateAcl(this.getBlobId(), acl);
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public List<Acl> listAcls() {
        return this.storage.listAcls(this.getBlobId());
    }

    public Storage getStorage() {
        return this.storage;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(Blob.class)) {
            return false;
        }
        Blob other = (Blob)obj;
        return super.equals(other) && Objects.equals(this.options, other.options);
    }

    @Override
    public final int hashCode() {
        return Objects.hash(super.hashCode(), this.options);
    }

    public BlobInfo asBlobInfo() {
        return this.toBuilder().infoBuilder.build();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.storage = (Storage)this.options.getService();
    }

    public static class BlobSourceOption
    extends Option<UnifiedOpts.ObjectSourceOpt> {
        private static final long serialVersionUID = 8205000496563385634L;

        private BlobSourceOption(UnifiedOpts.ObjectSourceOpt opt) {
            super(opt);
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobSourceOption generationMatch() {
            return new BlobSourceOption(UnifiedOpts.generationMatchExtractor());
        }

        @Deprecated
        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobSourceOption generationNotMatch() {
            return new BlobSourceOption(UnifiedOpts.generationNotMatchExtractor());
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobSourceOption metagenerationMatch() {
            return new BlobSourceOption(UnifiedOpts.metagenerationMatchExtractor());
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobSourceOption metagenerationNotMatch() {
            return new BlobSourceOption(UnifiedOpts.metagenerationNotMatchExtractor());
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobSourceOption decryptionKey(@NonNull Key key) {
            return new BlobSourceOption(UnifiedOpts.decryptionKey(key));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobSourceOption decryptionKey(@NonNull String key) {
            return new BlobSourceOption(UnifiedOpts.decryptionKey(key));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobSourceOption userProject(@NonNull String userProject) {
            return new BlobSourceOption(UnifiedOpts.userProject(userProject));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobSourceOption shouldReturnRawInputStream(boolean shouldReturnRawInputStream) {
            return new BlobSourceOption(UnifiedOpts.returnRawInputStream(shouldReturnRawInputStream));
        }

        public static BlobSourceOption[] dedupe(BlobSourceOption ... os) {
            return (BlobSourceOption[])Option.dedupe(BlobSourceOption[]::new, (Option[])os);
        }

        public static BlobSourceOption[] dedupe(Collection<BlobSourceOption> collection, BlobSourceOption ... os) {
            return (BlobSourceOption[])Option.dedupe(BlobSourceOption[]::new, collection, (Option[])os);
        }

        public static BlobSourceOption[] dedupe(BlobSourceOption[] array, BlobSourceOption ... os) {
            return (BlobSourceOption[])Option.dedupe(BlobSourceOption[]::new, (Option[])array, (Option[])os);
        }

        static Storage.BlobSourceOption[] toSourceOptions(BlobInfo blobInfo, BlobSourceOption ... options) {
            Storage.BlobSourceOption[] convertedOptions = new Storage.BlobSourceOption[options.length];
            for (int i = 0; i < options.length; ++i) {
                UnifiedOpts.ObjectSourceOpt opt = (UnifiedOpts.ObjectSourceOpt)options[i].getOpt();
                if (opt instanceof UnifiedOpts.ObjectOptExtractor) {
                    UnifiedOpts.ObjectOptExtractor ex = (UnifiedOpts.ObjectOptExtractor)opt;
                    UnifiedOpts.ObjectSourceOpt objectSourceOpt = (UnifiedOpts.ObjectSourceOpt)ex.extractFromBlobInfo(blobInfo);
                    convertedOptions[i] = new Storage.BlobSourceOption(objectSourceOpt);
                    continue;
                }
                convertedOptions[i] = new Storage.BlobSourceOption(opt);
            }
            return convertedOptions;
        }

        static Storage.BlobGetOption[] toGetOptions(BlobInfo blobInfo, BlobSourceOption ... options) {
            Storage.BlobGetOption[] convertedOptions = new Storage.BlobGetOption[options.length];
            for (int i = 0; i < options.length; ++i) {
                UnifiedOpts.ObjectSourceOpt opt = (UnifiedOpts.ObjectSourceOpt)options[i].getOpt();
                if (opt instanceof UnifiedOpts.ObjectOptExtractor) {
                    UnifiedOpts.ObjectOptExtractor ex = (UnifiedOpts.ObjectOptExtractor)opt;
                    UnifiedOpts.ObjectSourceOpt objectSourceOpt = (UnifiedOpts.ObjectSourceOpt)ex.extractFromBlobInfo(blobInfo);
                    convertedOptions[i] = new Storage.BlobGetOption(objectSourceOpt);
                    continue;
                }
                convertedOptions[i] = new Storage.BlobGetOption((UnifiedOpts.ObjectSourceOpt)options[i].getOpt());
            }
            return convertedOptions;
        }
    }

    public static class Builder
    extends BlobInfo.Builder {
        private final Storage storage;
        private final BlobInfo.BuilderImpl infoBuilder;

        Builder(Blob blob) {
            this.storage = blob.getStorage();
            this.infoBuilder = new BlobInfo.BuilderImpl(blob);
        }

        @Override
        public Builder setBlobId(BlobId blobId) {
            this.infoBuilder.setBlobId(blobId);
            return this;
        }

        @Override
        Builder setGeneratedId(String generatedId) {
            this.infoBuilder.setGeneratedId(generatedId);
            return this;
        }

        @Override
        public Builder setContentType(String contentType) {
            this.infoBuilder.setContentType(contentType);
            return this;
        }

        @Override
        public Builder setContentDisposition(String contentDisposition) {
            this.infoBuilder.setContentDisposition(contentDisposition);
            return this;
        }

        @Override
        public Builder setContentLanguage(String contentLanguage) {
            this.infoBuilder.setContentLanguage(contentLanguage);
            return this;
        }

        @Override
        public Builder setContentEncoding(String contentEncoding) {
            this.infoBuilder.setContentEncoding(contentEncoding);
            return this;
        }

        @Override
        Builder setComponentCount(Integer componentCount) {
            this.infoBuilder.setComponentCount(componentCount);
            return this;
        }

        @Override
        public Builder setCacheControl(String cacheControl) {
            this.infoBuilder.setCacheControl(cacheControl);
            return this;
        }

        @Override
        public Builder setAcl(List<Acl> acl) {
            this.infoBuilder.setAcl(acl);
            return this;
        }

        @Override
        Builder setOwner(Acl.Entity owner) {
            this.infoBuilder.setOwner(owner);
            return this;
        }

        @Override
        Builder setSize(Long size) {
            this.infoBuilder.setSize(size);
            return this;
        }

        @Override
        Builder setEtag(String etag) {
            this.infoBuilder.setEtag(etag);
            return this;
        }

        @Override
        Builder setSelfLink(String selfLink) {
            this.infoBuilder.setSelfLink(selfLink);
            return this;
        }

        @Override
        public Builder setMd5(String md5) {
            this.infoBuilder.setMd5(md5);
            return this;
        }

        @Override
        public Builder setMd5FromHexString(String md5HexString) {
            this.infoBuilder.setMd5FromHexString(md5HexString);
            return this;
        }

        @Override
        public Builder setCrc32c(String crc32c) {
            this.infoBuilder.setCrc32c(crc32c);
            return this;
        }

        @Override
        public Builder setCrc32cFromHexString(String crc32cHexString) {
            this.infoBuilder.setCrc32cFromHexString(crc32cHexString);
            return this;
        }

        @Override
        Builder setMediaLink(String mediaLink) {
            this.infoBuilder.setMediaLink(mediaLink);
            return this;
        }

        @Override
        public Builder setMetadata(Map<String, String> metadata) {
            this.infoBuilder.setMetadata(metadata);
            return this;
        }

        @Override
        public Builder setStorageClass(StorageClass storageClass) {
            this.infoBuilder.setStorageClass(storageClass);
            return this;
        }

        @Override
        @Deprecated
        public Builder setTimeStorageClassUpdated(Long timeStorageClassUpdated) {
            this.infoBuilder.setTimeStorageClassUpdated(timeStorageClassUpdated);
            return this;
        }

        @Override
        public BlobInfo.Builder setTimeStorageClassUpdatedOffsetDateTime(OffsetDateTime timeStorageClassUpdated) {
            this.infoBuilder.setTimeStorageClassUpdatedOffsetDateTime(timeStorageClassUpdated);
            return this;
        }

        @Override
        Builder setMetageneration(Long metageneration) {
            this.infoBuilder.setMetageneration(metageneration);
            return this;
        }

        @Override
        @Deprecated
        Builder setDeleteTime(Long deleteTime) {
            this.infoBuilder.setDeleteTime(deleteTime);
            return this;
        }

        @Override
        BlobInfo.Builder setDeleteTimeOffsetDateTime(OffsetDateTime deleteTime) {
            this.infoBuilder.setDeleteTimeOffsetDateTime(deleteTime);
            return this;
        }

        @Override
        @Deprecated
        Builder setUpdateTime(Long updateTime) {
            this.infoBuilder.setUpdateTime(updateTime);
            return this;
        }

        @Override
        BlobInfo.Builder setUpdateTimeOffsetDateTime(OffsetDateTime updateTime) {
            this.infoBuilder.setUpdateTimeOffsetDateTime(updateTime);
            return this;
        }

        @Override
        @Deprecated
        Builder setCreateTime(Long createTime) {
            this.infoBuilder.setCreateTime(createTime);
            return this;
        }

        @Override
        BlobInfo.Builder setCreateTimeOffsetDateTime(OffsetDateTime createTime) {
            this.infoBuilder.setCreateTimeOffsetDateTime(createTime);
            return this;
        }

        @Override
        @Deprecated
        public Builder setCustomTime(Long customTime) {
            this.infoBuilder.setCustomTime(customTime);
            return this;
        }

        @Override
        public BlobInfo.Builder setCustomTimeOffsetDateTime(OffsetDateTime customTime) {
            this.infoBuilder.setCustomTimeOffsetDateTime(customTime);
            return this;
        }

        @Override
        Builder setIsDirectory(boolean isDirectory) {
            this.infoBuilder.setIsDirectory(isDirectory);
            return this;
        }

        @Override
        Builder setCustomerEncryption(BlobInfo.CustomerEncryption customerEncryption) {
            this.infoBuilder.setCustomerEncryption(customerEncryption);
            return this;
        }

        @Override
        Builder setKmsKeyName(String kmsKeyName) {
            this.infoBuilder.setKmsKeyName(kmsKeyName);
            return this;
        }

        @Override
        public Builder setEventBasedHold(Boolean eventBasedHold) {
            this.infoBuilder.setEventBasedHold(eventBasedHold);
            return this;
        }

        @Override
        public Builder setTemporaryHold(Boolean temporaryHold) {
            this.infoBuilder.setTemporaryHold(temporaryHold);
            return this;
        }

        @Override
        @Deprecated
        Builder setRetentionExpirationTime(Long retentionExpirationTime) {
            this.infoBuilder.setRetentionExpirationTime(retentionExpirationTime);
            return this;
        }

        @Override
        Builder setRetentionExpirationTimeOffsetDateTime(OffsetDateTime retentionExpirationTime) {
            this.infoBuilder.setRetentionExpirationTimeOffsetDateTime(retentionExpirationTime);
            return this;
        }

        @Override
        Builder setSoftDeleteTime(OffsetDateTime softDeleteTime) {
            this.infoBuilder.setSoftDeleteTime(softDeleteTime);
            return this;
        }

        @Override
        Builder setHardDeleteTime(OffsetDateTime hardDeleteTime) {
            this.infoBuilder.setHardDeleteTime(hardDeleteTime);
            return this;
        }

        @Override
        public Builder setRetention(BlobInfo.Retention retention) {
            this.infoBuilder.setRetention(retention);
            return this;
        }

        @Override
        public Blob build() {
            return new Blob(this.storage, this.infoBuilder);
        }

        @Override
        BlobId getBlobId() {
            return this.infoBuilder.getBlobId();
        }

        @Override
        Builder clearBlobId() {
            this.infoBuilder.clearBlobId();
            return this;
        }

        @Override
        Builder clearGeneratedId() {
            this.infoBuilder.clearGeneratedId();
            return this;
        }

        @Override
        Builder clearContentType() {
            this.infoBuilder.clearContentType();
            return this;
        }

        @Override
        Builder clearContentEncoding() {
            this.infoBuilder.clearContentEncoding();
            return this;
        }

        @Override
        Builder clearContentDisposition() {
            this.infoBuilder.clearContentDisposition();
            return this;
        }

        @Override
        Builder clearContentLanguage() {
            this.infoBuilder.clearContentLanguage();
            return this;
        }

        @Override
        Builder clearComponentCount() {
            this.infoBuilder.clearComponentCount();
            return this;
        }

        @Override
        Builder clearCacheControl() {
            this.infoBuilder.clearCacheControl();
            return this;
        }

        @Override
        Builder clearAcl() {
            this.infoBuilder.clearAcl();
            return this;
        }

        @Override
        Builder clearOwner() {
            this.infoBuilder.clearOwner();
            return this;
        }

        @Override
        Builder clearSize() {
            this.infoBuilder.clearSize();
            return this;
        }

        @Override
        Builder clearEtag() {
            this.infoBuilder.clearEtag();
            return this;
        }

        @Override
        Builder clearSelfLink() {
            this.infoBuilder.clearSelfLink();
            return this;
        }

        @Override
        Builder clearMd5() {
            this.infoBuilder.clearMd5();
            return this;
        }

        @Override
        Builder clearCrc32c() {
            this.infoBuilder.clearCrc32c();
            return this;
        }

        @Override
        Builder clearCustomTime() {
            this.infoBuilder.clearCustomTime();
            return this;
        }

        @Override
        Builder clearMediaLink() {
            this.infoBuilder.clearMediaLink();
            return this;
        }

        @Override
        Builder clearMetadata() {
            this.infoBuilder.clearMetadata();
            return this;
        }

        @Override
        Builder clearMetageneration() {
            this.infoBuilder.clearMetageneration();
            return this;
        }

        @Override
        Builder clearDeleteTime() {
            this.infoBuilder.clearDeleteTime();
            return this;
        }

        @Override
        Builder clearUpdateTime() {
            this.infoBuilder.clearUpdateTime();
            return this;
        }

        @Override
        Builder clearCreateTime() {
            this.infoBuilder.clearCreateTime();
            return this;
        }

        @Override
        Builder clearIsDirectory() {
            this.infoBuilder.clearIsDirectory();
            return this;
        }

        @Override
        Builder clearCustomerEncryption() {
            this.infoBuilder.clearCustomerEncryption();
            return this;
        }

        @Override
        Builder clearStorageClass() {
            this.infoBuilder.clearStorageClass();
            return this;
        }

        @Override
        Builder clearTimeStorageClassUpdated() {
            this.infoBuilder.clearTimeStorageClassUpdated();
            return this;
        }

        @Override
        Builder clearKmsKeyName() {
            this.infoBuilder.clearKmsKeyName();
            return this;
        }

        @Override
        Builder clearEventBasedHold() {
            this.infoBuilder.clearEventBasedHold();
            return this;
        }

        @Override
        Builder clearTemporaryHold() {
            this.infoBuilder.clearTemporaryHold();
            return this;
        }

        @Override
        Builder clearRetentionExpirationTime() {
            this.infoBuilder.clearRetentionExpirationTime();
            return this;
        }
    }
}

