/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import com.google.api.client.util.Key;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;

public final class UserProvider {
    @Key(value="rawId")
    private final String uid;
    @Key(value="displayName")
    private final String displayName;
    @Key(value="email")
    private final String email;
    @Key(value="photoUrl")
    private final String photoUrl;
    @Key(value="providerId")
    private final String providerId;

    private UserProvider(Builder builder) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(builder.uid), "Uid must not be null or empty");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(builder.providerId), "ProviderId must not be null or empty");
        this.uid = builder.uid;
        this.displayName = builder.displayName;
        this.email = builder.email;
        this.photoUrl = builder.photoUrl;
        this.providerId = builder.providerId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String uid;
        private String displayName;
        private String email;
        private String photoUrl;
        private String providerId;

        private Builder() {
        }

        public Builder setUid(String uid) {
            this.uid = uid;
            return this;
        }

        public Builder setDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder setEmail(String email) {
            this.email = email;
            return this;
        }

        public Builder setPhotoUrl(String photoUrl) {
            this.photoUrl = photoUrl;
            return this;
        }

        public Builder setProviderId(String providerId) {
            this.providerId = providerId;
            return this;
        }

        public UserProvider build() {
            return new UserProvider(this);
        }
    }
}

