/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.internal;

import com.google.api.client.http.LowLevelHttpResponse;
import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;

public class ApacheHttp2Response
extends LowLevelHttpResponse {
    private final SimpleHttpResponse response;
    private final Header[] allHeaders;

    ApacheHttp2Response(SimpleHttpResponse response) {
        this.response = response;
        this.allHeaders = response.getHeaders();
    }

    @Override
    public int getStatusCode() {
        return this.response.getCode();
    }

    @Override
    public InputStream getContent() throws IOException {
        return new ByteArrayInputStream(this.response.getBodyBytes());
    }

    @Override
    public String getContentEncoding() {
        Header contentEncodingHeader = this.response.getFirstHeader("Content-Encoding");
        return contentEncodingHeader == null ? null : contentEncodingHeader.getValue();
    }

    @Override
    public long getContentLength() {
        String bodyText = this.response.getBodyText();
        return bodyText == null ? 0L : (long)bodyText.length();
    }

    @Override
    public String getContentType() {
        ContentType contentType = this.response.getContentType();
        return contentType == null ? null : contentType.toString();
    }

    @Override
    public String getReasonPhrase() {
        return this.response.getReasonPhrase();
    }

    @Override
    public String getStatusLine() {
        return this.response.toString();
    }

    public String getHeaderValue(String name) {
        return this.response.getLastHeader(name).getValue();
    }

    @Override
    public String getHeaderValue(int index) {
        return this.allHeaders[index].getValue();
    }

    @Override
    public int getHeaderCount() {
        return this.allHeaders.length;
    }

    @Override
    public String getHeaderName(int index) {
        return this.allHeaders[index].getName();
    }

    @VisibleForTesting
    public SimpleHttpResponse getResponse() {
        return this.response;
    }
}

