/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.internal;

import com.google.api.client.http.HttpTransport;
import com.google.firebase.internal.ApacheHttp2Request;
import java.io.IOException;
import java.net.ProxySelector;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.async.HttpAsyncClient;
import org.apache.hc.client5.http.async.methods.SimpleRequestBuilder;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.TlsConfig;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.impl.routing.SystemDefaultRoutePlanner;
import org.apache.hc.client5.http.ssl.ClientTlsStrategyBuilder;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.http2.config.H2Config;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.ssl.SSLContexts;

public final class ApacheHttp2Transport
extends HttpTransport {
    private final CloseableHttpAsyncClient httpAsyncClient;
    private final boolean isMtls;

    public ApacheHttp2Transport() {
        this(ApacheHttp2Transport.newDefaultHttpAsyncClient(), false);
    }

    public ApacheHttp2Transport(CloseableHttpAsyncClient httpAsyncClient) {
        this(httpAsyncClient, false);
    }

    public ApacheHttp2Transport(CloseableHttpAsyncClient httpAsyncClient, boolean isMtls) {
        this.httpAsyncClient = httpAsyncClient;
        this.isMtls = isMtls;
        httpAsyncClient.start();
    }

    public static CloseableHttpAsyncClient newDefaultHttpAsyncClient() {
        return ApacheHttp2Transport.defaultHttpAsyncClientBuilder().build();
    }

    public static HttpAsyncClientBuilder defaultHttpAsyncClientBuilder() {
        PoolingAsyncClientConnectionManager connectionManager = PoolingAsyncClientConnectionManagerBuilder.create().setMaxConnTotal(200).setMaxConnPerRoute(100).setDefaultConnectionConfig(ConnectionConfig.custom().setTimeToLive(-1L, TimeUnit.MILLISECONDS).build()).setDefaultTlsConfig(TlsConfig.custom().setVersionPolicy(HttpVersionPolicy.NEGOTIATE).build()).setTlsStrategy(ClientTlsStrategyBuilder.create().setSslContext(SSLContexts.createSystemDefault()).build()).build();
        return HttpAsyncClientBuilder.create().setH2Config(H2Config.custom().setMaxConcurrentStreams(100).build()).setHttp1Config(Http1Config.DEFAULT).setConnectionManager(connectionManager).setRoutePlanner(new SystemDefaultRoutePlanner(ProxySelector.getDefault())).disableRedirectHandling().disableAutomaticRetries();
    }

    @Override
    public boolean supportsMethod(String method) {
        return true;
    }

    @Override
    protected ApacheHttp2Request buildRequest(String method, String url) {
        SimpleRequestBuilder requestBuilder = SimpleRequestBuilder.create(method).setUri(url);
        return new ApacheHttp2Request(this.httpAsyncClient, requestBuilder);
    }

    @Override
    public void shutdown() throws IOException {
        this.httpAsyncClient.close(CloseMode.GRACEFUL);
    }

    public HttpAsyncClient getHttpClient() {
        return this.httpAsyncClient;
    }

    @Override
    public boolean isMtls() {
        return this.isMtls;
    }
}

