/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.internal;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.JsonFactory;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.firebase.internal.Nullable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public final class HttpRequestInfo {
    private final String method;
    private final GenericUrl url;
    private final HttpContent content;
    private final Object jsonContent;
    private final Map<String, String> headers = new HashMap<String, String>();

    private HttpRequestInfo(String method, GenericUrl url, HttpContent content, Object jsonContent) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(method), "method must not be null");
        this.method = method;
        this.url = Preconditions.checkNotNull(url, "url must not be null");
        this.content = content;
        this.jsonContent = jsonContent;
    }

    public HttpRequestInfo addHeader(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public HttpRequestInfo addAllHeaders(Map<String, String> headers) {
        this.headers.putAll(headers);
        return this;
    }

    public HttpRequestInfo addParameter(String name, Object value) {
        this.url.put(name, value);
        return this;
    }

    public HttpRequestInfo addAllParameters(Map<String, Object> params) {
        this.url.putAll((Map<? extends String, ?>)params);
        return this;
    }

    public static HttpRequestInfo buildGetRequest(String url) {
        return HttpRequestInfo.buildRequest("GET", url, null);
    }

    public static HttpRequestInfo buildDeleteRequest(String url) {
        return HttpRequestInfo.buildRequest("DELETE", url, null);
    }

    public static HttpRequestInfo buildRequest(String method, String url, @Nullable HttpContent content) {
        return new HttpRequestInfo(method, new GenericUrl(url), content, null);
    }

    public static HttpRequestInfo buildJsonPostRequest(String url, @Nullable Object content) {
        return HttpRequestInfo.buildJsonRequest("POST", url, content);
    }

    public static HttpRequestInfo buildJsonPatchRequest(String url, @Nullable Object content) {
        return HttpRequestInfo.buildJsonRequest("PATCH", url, content);
    }

    public static HttpRequestInfo buildJsonRequest(String method, String url, @Nullable Object content) {
        return new HttpRequestInfo(method, new GenericUrl(url), null, content);
    }

    HttpRequest newHttpRequest(HttpRequestFactory factory, JsonFactory jsonFactory) throws IOException {
        HttpRequest request;
        HttpContent httpContent = this.getContent(jsonFactory);
        if (factory.getTransport().supportsMethod(this.method)) {
            request = factory.buildRequest(this.method, this.url, httpContent);
        } else {
            request = factory.buildPostRequest(this.url, httpContent);
            request.getHeaders().set("X-HTTP-Method-Override", this.method);
        }
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            request.getHeaders().set(entry.getKey(), entry.getValue());
        }
        return request;
    }

    private HttpContent getContent(JsonFactory jsonFactory) {
        if (this.content != null) {
            return this.content;
        }
        if (this.jsonContent != null) {
            return new JsonHttpContent(jsonFactory, this.jsonContent);
        }
        return null;
    }
}

