/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.internal;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class SdkUtils {
    private static final String ADMIN_SDK_PROPERTIES = "admin_sdk.properties";
    private static final String SDK_VERSION = SdkUtils.loadSdkVersion();

    public static String getVersion() {
        return SDK_VERSION;
    }

    public static String getJavaVersion() {
        return System.getProperty("java.version");
    }

    public static String getMetricsHeader() {
        return String.format("gl-java/%s fire-admin/%s", SdkUtils.getJavaVersion(), SdkUtils.getVersion());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String loadSdkVersion() {
        try (InputStream in = SdkUtils.class.getClassLoader().getResourceAsStream(ADMIN_SDK_PROPERTIES);){
            Properties properties = new Properties();
            properties.load(Preconditions.checkNotNull(in, "Failed to load: admin_sdk.properties"));
            String string = properties.getProperty("sdk.version");
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

