/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import com.google.api.client.util.Key;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.firebase.internal.NonNull;
import com.google.firebase.messaging.ApnsFcmOptions;
import com.google.firebase.messaging.Aps;
import java.util.HashMap;
import java.util.Map;

public class ApnsConfig {
    @Key(value="headers")
    private final Map<String, String> headers;
    @Key(value="payload")
    private final Map<String, Object> payload;
    @Key(value="fcm_options")
    private final ApnsFcmOptions fcmOptions;
    @Key(value="live_activity_token")
    private final String liveActivityToken;

    private ApnsConfig(Builder builder) {
        Preconditions.checkArgument(builder.aps != null, "aps must be specified");
        Preconditions.checkArgument(!builder.customData.containsKey("aps"), "aps cannot be specified as part of custom data");
        this.headers = builder.headers.isEmpty() ? null : ImmutableMap.copyOf(builder.headers);
        this.payload = ImmutableMap.builder().putAll(builder.customData).put("aps", builder.aps.getFields()).build();
        this.fcmOptions = builder.fcmOptions;
        this.liveActivityToken = builder.liveActivityToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, String> headers = new HashMap<String, String>();
        private final Map<String, Object> customData = new HashMap<String, Object>();
        private Aps aps;
        private ApnsFcmOptions fcmOptions;
        private String liveActivityToken;

        private Builder() {
        }

        public Builder putHeader(@NonNull String key, @NonNull String value) {
            this.headers.put(key, value);
            return this;
        }

        public Builder putAllHeaders(@NonNull Map<String, String> map) {
            this.headers.putAll(map);
            return this;
        }

        public Builder setAps(@NonNull Aps aps) {
            this.aps = aps;
            return this;
        }

        public Builder putCustomData(@NonNull String key, @NonNull Object value) {
            this.customData.put(key, value);
            return this;
        }

        public Builder putAllCustomData(@NonNull Map<String, Object> map) {
            this.customData.putAll(map);
            return this;
        }

        public Builder setFcmOptions(ApnsFcmOptions apnsFcmOptions) {
            this.fcmOptions = apnsFcmOptions;
            return this;
        }

        public Builder setLiveActivityToken(String liveActivityToken) {
            this.liveActivityToken = liveActivityToken;
            return this;
        }

        public ApnsConfig build() {
            return new ApnsConfig(this);
        }
    }
}

