/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public final class CriticalSound {
    private final Map<String, Object> fields;

    private CriticalSound(Builder builder) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(builder.name), "name must not be null or empty");
        ImmutableMap.Builder<String, String> fields = ImmutableMap.builder().put("name", builder.name);
        if (builder.critical) {
            fields.put("critical", (String)((Object)Integer.valueOf(1)));
        }
        if (builder.volume != null) {
            Preconditions.checkArgument(builder.volume >= 0.0 && builder.volume <= 1.0, "volume must be in the interval [0,1]");
            fields.put("volume", (String)((Object)builder.volume));
        }
        this.fields = fields.build();
    }

    Map<String, Object> getFields() {
        return this.fields;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private boolean critical;
        private String name;
        private Double volume;

        private Builder() {
        }

        public Builder setCritical(boolean critical) {
            this.critical = critical;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setVolume(double volume) {
            this.volume = volume;
            return this;
        }

        public CriticalSound build() {
            return new CriticalSound(this);
        }
    }
}

