/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import com.google.common.base.Preconditions;
import com.google.firebase.remoteconfig.RemoteConfigUtil;
import java.util.HashMap;
import java.util.Map;

public final class ListVersionsOptions {
    private final Integer pageSize;
    private final String pageToken;
    private final String endVersionNumber;
    private final String startTime;
    private final String endTime;

    private ListVersionsOptions(Builder builder) {
        if (builder.pageSize != null) {
            Preconditions.checkArgument(builder.pageSize > 0 && builder.pageSize < 301, "pageSize must be a number between 1 and 300 (inclusive).");
        }
        if (builder.endVersionNumber != null) {
            Preconditions.checkArgument(RemoteConfigUtil.isValidVersionNumber(builder.endVersionNumber) && Integer.parseInt(builder.endVersionNumber) > 0, "endVersionNumber must be a non-empty string in int64 format and must be greater than 0.");
        }
        this.pageSize = builder.pageSize;
        this.pageToken = builder.pageToken;
        this.endVersionNumber = builder.endVersionNumber;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    Map<String, Object> wrapForTransport() {
        HashMap<String, Object> optionsMap = new HashMap<String, Object>();
        if (this.pageSize != null) {
            optionsMap.put("pageSize", this.pageSize);
        }
        if (this.pageToken != null) {
            optionsMap.put("pageToken", this.pageToken);
        }
        if (this.endVersionNumber != null) {
            optionsMap.put("endVersionNumber", this.endVersionNumber);
        }
        if (this.startTime != null) {
            optionsMap.put("startTime", this.startTime);
        }
        if (this.endTime != null) {
            optionsMap.put("endTime", this.endTime);
        }
        return optionsMap;
    }

    String getPageToken() {
        return this.pageToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private Integer pageSize;
        private String pageToken;
        private String endVersionNumber;
        private String startTime;
        private String endTime;

        private Builder() {
        }

        private Builder(ListVersionsOptions options) {
            this.pageSize = options.pageSize;
            this.pageToken = options.pageToken;
            this.endVersionNumber = options.endVersionNumber;
            this.startTime = options.startTime;
            this.endTime = options.endTime;
        }

        public Builder setPageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder setPageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public Builder setEndVersionNumber(String endVersionNumber) {
            this.endVersionNumber = endVersionNumber;
            return this;
        }

        public Builder setEndVersionNumber(long endVersionNumber) {
            this.endVersionNumber = String.valueOf(endVersionNumber);
            return this;
        }

        public Builder setStartTimeMillis(long startTimeMillis) {
            this.startTime = RemoteConfigUtil.convertToUtcZuluFormat(startTimeMillis);
            return this;
        }

        public Builder setEndTimeMillis(long endTimeMillis) {
            this.endTime = RemoteConfigUtil.convertToUtcZuluFormat(endTimeMillis);
            return this;
        }

        public ListVersionsOptions build() {
            return new ListVersionsOptions(this);
        }
    }
}

