/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import com.google.api.gax.paging.Page;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.firebase.internal.NonNull;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigClient;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigException;
import com.google.firebase.remoteconfig.ListVersionsOptions;
import com.google.firebase.remoteconfig.Version;
import com.google.firebase.remoteconfig.internal.TemplateResponse;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public final class ListVersionsPage
implements Page<Version> {
    static final String END_OF_LIST = "";
    private final VersionsResultBatch currentBatch;
    private final VersionSource source;
    private final ListVersionsOptions listVersionsOptions;

    private ListVersionsPage(@NonNull VersionsResultBatch currentBatch, @NonNull VersionSource source, @NonNull ListVersionsOptions listVersionsOptions) {
        this.currentBatch = Preconditions.checkNotNull(currentBatch);
        this.source = Preconditions.checkNotNull(source);
        this.listVersionsOptions = listVersionsOptions;
    }

    @Override
    public boolean hasNextPage() {
        return !END_OF_LIST.equals(this.currentBatch.getNextPageToken());
    }

    @NonNull
    public ListVersionsPage getNextPage() {
        if (this.hasNextPage()) {
            ListVersionsOptions options = this.listVersionsOptions != null ? this.listVersionsOptions.toBuilder().setPageToken(this.currentBatch.getNextPageToken()).build() : ListVersionsOptions.builder().setPageToken(this.currentBatch.getNextPageToken()).build();
            Factory factory = new Factory(this.source, options);
            try {
                return factory.create();
            }
            catch (FirebaseRemoteConfigException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Override
    @NonNull
    public String getNextPageToken() {
        return this.currentBatch.getNextPageToken();
    }

    @Override
    @NonNull
    public Iterable<Version> getValues() {
        return this.currentBatch.getVersions();
    }

    @Override
    @NonNull
    public Iterable<Version> iterateAll() {
        return new VersionIterable(this);
    }

    static class Factory {
        private final VersionSource source;
        private final ListVersionsOptions listVersionsOptions;

        Factory(@NonNull VersionSource source) {
            this(source, null);
        }

        Factory(@NonNull VersionSource source, @NonNull ListVersionsOptions listVersionsOptions) {
            this.source = Preconditions.checkNotNull(source, "source must not be null");
            this.listVersionsOptions = listVersionsOptions;
        }

        ListVersionsPage create() throws FirebaseRemoteConfigException {
            VersionsResultBatch batch = this.source.fetch(this.listVersionsOptions);
            return new ListVersionsPage(batch, this.source, this.listVersionsOptions);
        }
    }

    static class DefaultVersionSource
    implements VersionSource {
        private final FirebaseRemoteConfigClient remoteConfigClient;

        DefaultVersionSource(FirebaseRemoteConfigClient remoteConfigClient) {
            this.remoteConfigClient = Preconditions.checkNotNull(remoteConfigClient, "remote config client must not be null");
        }

        @Override
        public VersionsResultBatch fetch(ListVersionsOptions listVersionsOptions) throws FirebaseRemoteConfigException {
            TemplateResponse.ListVersionsResponse response = this.remoteConfigClient.listVersions(listVersionsOptions);
            ImmutableList.Builder builder = ImmutableList.builder();
            if (response.hasVersions()) {
                for (TemplateResponse.VersionResponse versionResponse : response.getVersions()) {
                    builder.add(new Version(versionResponse));
                }
            }
            String nextPageToken = response.getNextPageToken() != null ? response.getNextPageToken() : ListVersionsPage.END_OF_LIST;
            return new VersionsResultBatch((List<Version>)((Object)builder.build()), nextPageToken);
        }
    }

    static interface VersionSource {
        @NonNull
        public VersionsResultBatch fetch(ListVersionsOptions var1) throws FirebaseRemoteConfigException;
    }

    static final class VersionsResultBatch {
        private final List<Version> versions;
        private final String nextPageToken;

        VersionsResultBatch(@NonNull List<Version> versions, @NonNull String nextPageToken) {
            this.versions = Preconditions.checkNotNull(versions);
            this.nextPageToken = Preconditions.checkNotNull(nextPageToken);
        }

        @NonNull
        List<Version> getVersions() {
            return this.versions;
        }

        @NonNull
        String getNextPageToken() {
            return this.nextPageToken;
        }
    }

    private static class VersionIterable
    implements Iterable<Version> {
        private final ListVersionsPage startingPage;

        VersionIterable(@NonNull ListVersionsPage startingPage) {
            this.startingPage = Preconditions.checkNotNull(startingPage, "starting page must not be null");
        }

        @Override
        @NonNull
        public Iterator<Version> iterator() {
            return new VersionIterator(this.startingPage);
        }

        private static class VersionIterator
        implements Iterator<Version> {
            private ListVersionsPage currentPage;
            private List<Version> batch;
            private int index = 0;

            private VersionIterator(ListVersionsPage startingPage) {
                this.setCurrentPage(startingPage);
            }

            @Override
            public boolean hasNext() {
                if (this.index == this.batch.size()) {
                    if (this.currentPage.hasNextPage()) {
                        this.setCurrentPage(this.currentPage.getNextPage());
                    } else {
                        return false;
                    }
                }
                return this.index < this.batch.size();
            }

            @Override
            public Version next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.batch.get(this.index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove operation not supported");
            }

            private void setCurrentPage(ListVersionsPage page) {
                this.currentPage = Preconditions.checkNotNull(page);
                this.batch = ImmutableList.copyOf(page.getValues());
                this.index = 0;
            }
        }
    }
}

