/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import com.google.common.base.Preconditions;
import com.google.firebase.internal.NonNull;
import com.google.firebase.internal.Nullable;
import com.google.firebase.remoteconfig.internal.TemplateResponse;
import java.util.Objects;

public class User {
    private final String email;
    private final String name;
    private final String imageUrl;

    User(@NonNull TemplateResponse.UserResponse userResponse) {
        Preconditions.checkNotNull(userResponse);
        this.email = userResponse.getEmail();
        this.name = userResponse.getName();
        this.imageUrl = userResponse.getImageUrl();
    }

    @Nullable
    public String getEmail() {
        return this.email;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getImageUrl() {
        return this.imageUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return Objects.equals(this.email, user.email) && Objects.equals(this.name, user.name) && Objects.equals(this.imageUrl, user.imageUrl);
    }

    public int hashCode() {
        return Objects.hash(this.email, this.name, this.imageUrl);
    }

    TemplateResponse.UserResponse toUserResponse() {
        return new TemplateResponse.UserResponse().setEmail(this.email).setImageUrl(this.imageUrl).setName(this.name);
    }
}

