/*
 * Decompiled with CFR 0.152.
 */
package hive.keycloak.authenticator;

import hive.keycloak.authenticator.credentials.FirebaseAuthCredentialModel;
import java.util.Optional;
import java.util.stream.Stream;
import org.keycloak.common.util.Time;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialInputUpdater;
import org.keycloak.credential.CredentialInputValidator;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.credential.CredentialTypeMetadata;
import org.keycloak.credential.CredentialTypeMetadataContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;

public class FirebaseAuthCredentialProvider
implements CredentialProvider<FirebaseAuthCredentialModel>,
CredentialInputValidator,
CredentialInputUpdater {
    protected final KeycloakSession session;

    public FirebaseAuthCredentialProvider(KeycloakSession session) {
        this.session = session;
    }

    public boolean isValid(RealmModel realm, UserModel user, CredentialInput input) {
        if (!(input instanceof UserCredentialModel)) {
            return false;
        }
        return input.getType().equals(this.getType());
    }

    public boolean supportsCredentialType(String credentialType) {
        return this.getType().equals(credentialType);
    }

    public boolean isConfiguredFor(RealmModel realm, UserModel user, String credentialType) {
        if (!this.supportsCredentialType(credentialType)) {
            return false;
        }
        return user.credentialManager().getStoredCredentialsByTypeStream(credentialType).findAny().isPresent();
    }

    public CredentialModel createCredential(RealmModel realm, UserModel user, FirebaseAuthCredentialModel credentialModel) {
        credentialModel.setCreatedDate(Time.currentTimeMillis());
        return user.credentialManager().createStoredCredential((CredentialModel)credentialModel);
    }

    public boolean updateCredential(RealmModel realm, UserModel user, CredentialInput input) {
        String[] parts = input.getChallengeResponse().split(":");
        if (parts.length != 2) {
            return false;
        }
        String fcmToken = parts[0];
        String deviceId = parts[1];
        Optional model = user.credentialManager().getStoredCredentialsByTypeStream(input.getType()).findFirst();
        if (model.isPresent()) {
            CredentialModel credentialModel = (CredentialModel)model.get();
            this.deleteCredential(realm, user, credentialModel.getId());
            this.createCredential(realm, user, FirebaseAuthCredentialModel.createFirebaseAuthenticator(fcmToken, deviceId));
            return true;
        }
        return false;
    }

    public boolean deleteCredential(RealmModel realm, UserModel user, String credentialId) {
        return user.credentialManager().removeStoredCredentialById(credentialId);
    }

    public FirebaseAuthCredentialModel getCredentialFromModel(CredentialModel model) {
        return FirebaseAuthCredentialModel.createFromModel(model);
    }

    public CredentialTypeMetadata getCredentialTypeMetadata(CredentialTypeMetadataContext metadataContext) {
        return CredentialTypeMetadata.builder().type(this.getType()).category(CredentialTypeMetadata.Category.TWO_FACTOR).displayName("firebaseAuthenticator").helpText("firebaseAuthSetup").removeable(true).build(this.session);
    }

    public String getType() {
        return "firebase-auth";
    }

    public Stream<String> getDisableableCredentialTypesStream(RealmModel realm, UserModel user) {
        return Stream.empty();
    }

    public void disableCredentialType(RealmModel realm, UserModel user, String credentialType) {
    }
}

