/*
 * Decompiled with CFR 0.152.
 */
package hive.keycloak.authenticator;

import com.google.firebase.messaging.FirebaseMessagingException;
import hive.keycloak.authenticator.FirebaseAuthCredentialProvider;
import hive.keycloak.authenticator.credentials.FirebaseAuthCredentialData;
import hive.keycloak.authenticator.firebase.FirebaseService;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.CredentialValidator;
import org.keycloak.common.util.Time;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.util.JsonSerialization;

public class FirebaseAuthenticator
implements Authenticator,
CredentialValidator<FirebaseAuthCredentialProvider> {
    private static final Logger logger = Logger.getLogger(FirebaseAuthenticator.class);
    private static final String TPL_FIREBASE_LOGIN = "firebase-login.ftl";
    private static final String TPL_FIREBASE_REGISTER = "firebase-register.ftl";

    public void authenticate(AuthenticationFlowContext context) {
        AuthenticatorConfigModel config = context.getAuthenticatorConfig();
        Map configMap = config != null ? config.getConfig() : new HashMap();
        int codeDigits = Integer.parseInt(configMap.getOrDefault("codeDigits", "2"));
        int fakeCodesCount = Integer.parseInt(configMap.getOrDefault("fakeCodesCount", "3"));
        int sessionTimeoutSeconds = Integer.parseInt(configMap.getOrDefault("sessionTimeoutSeconds", "300"));
        boolean forceSecondFactor = Boolean.parseBoolean(configMap.getOrDefault("forceSecondFactor", "false"));
        Optional model = context.getUser().credentialManager().getStoredCredentialsByTypeStream("firebase-auth").findFirst();
        if (model.isEmpty()) {
            if (forceSecondFactor) {
                logger.infof("No Firebase credential found for user: %s - forcing 2FA setup", (Object)context.getUser().getUsername());
                this.handleForce2FAFlow(context, sessionTimeoutSeconds);
            } else {
                logger.infof("No Firebase credential found for user: %s - skipping Firebase auth", (Object)context.getUser().getUsername());
                context.success();
            }
            return;
        }
        this.handleStandardMFAFlow(context, (CredentialModel)model.get(), configMap, codeDigits, fakeCodesCount, sessionTimeoutSeconds);
    }

    private void handleForce2FAFlow(AuthenticationFlowContext context, int sessionTimeoutSeconds) {
        String sessionId = UUID.randomUUID().toString();
        String userId = context.getUser().getId();
        AuthenticationSessionModel authSession = context.getAuthenticationSession();
        long expiryTime = Time.currentTimeMillis() + (long)sessionTimeoutSeconds * 1000L;
        String verificationToken = FirebaseService.generateSecureToken();
        authSession.setAuthNote("firebase.reg.session_id", sessionId);
        authSession.setAuthNote("firebase.reg.user_id", userId);
        authSession.setAuthNote("firebase.reg.expires_at", String.valueOf(expiryTime));
        authSession.setAuthNote("firebase.reg.completed", "false");
        authSession.setAuthNote("firebase.reg.status", "pending");
        authSession.setAuthNote("firebase.reg.verification_token", verificationToken);
        String rootSessionId = authSession.getParentSession().getId();
        String tabId = authSession.getTabId();
        RealmModel realm = context.getRealm();
        realm.setAttribute("firebase_reg_session_" + sessionId, rootSessionId + ":" + tabId + ":" + authSession.getClient().getId());
        Response challenge = context.form().setAttribute("sessionId", (Object)sessionId).setAttribute("verificationToken", (Object)verificationToken).createForm(TPL_FIREBASE_REGISTER);
        context.challenge(challenge);
    }

    private void handleStandardMFAFlow(AuthenticationFlowContext context, CredentialModel credentialModel, Map<String, String> configMap, int codeDigits, int fakeCodesCount, int sessionTimeoutSeconds) {
        FirebaseService.initialize(configMap);
        try {
            FirebaseAuthCredentialData credentialData = (FirebaseAuthCredentialData)JsonSerialization.readValue((String)credentialModel.getCredentialData(), FirebaseAuthCredentialData.class);
            String fcmToken = credentialData.getFcmToken();
            String userId = context.getUser().getId();
            String sessionId = UUID.randomUUID().toString();
            String verificationCode = FirebaseService.sendAuthNotification(context.getSession(), context.getAuthenticationSession(), fcmToken, sessionId, userId, codeDigits, fakeCodesCount, sessionTimeoutSeconds);
            logger.infof("Sent auth notification to user %s, session %s, code digits: %d, fake codes: %d", new Object[]{context.getUser().getUsername(), sessionId, codeDigits, fakeCodesCount});
            Response challenge = context.form().setAttribute("verificationCode", (Object)verificationCode).setAttribute("sessionId", (Object)sessionId).createForm(TPL_FIREBASE_LOGIN);
            context.challenge(challenge);
        }
        catch (IOException e) {
            logger.error((Object)"Error parsing Firebase credential data", (Throwable)e);
            context.failure(AuthenticationFlowError.INVALID_CREDENTIALS);
        }
        catch (FirebaseMessagingException e) {
            logger.error((Object)"Error sending Firebase notification", (Throwable)e);
            context.failure(AuthenticationFlowError.INTERNAL_ERROR);
        }
    }

    public void action(AuthenticationFlowContext context) {
        AuthenticationSessionModel authSession = context.getAuthenticationSession();
        String regSessionId = authSession.getAuthNote("firebase.reg.session_id");
        if (regSessionId != null) {
            String completed = authSession.getAuthNote("firebase.reg.completed");
            String status = authSession.getAuthNote("firebase.reg.status");
            if ("true".equals(completed) || "fcm_registered".equals(status)) {
                logger.infof("Force 2FA registration completed for user: %s", (Object)context.getUser().getUsername());
                authSession.removeAuthNote("firebase.reg.session_id");
                authSession.removeAuthNote("firebase.reg.user_id");
                authSession.removeAuthNote("firebase.reg.expires_at");
                authSession.removeAuthNote("firebase.reg.completed");
                authSession.removeAuthNote("firebase.reg.status");
                authSession.removeAuthNote("firebase.reg.verification_token");
                context.success();
                return;
            }
            logger.debugf("Force 2FA registration not yet completed for session: %s", (Object)regSessionId);
            this.handleForce2FAFlow(context, 300);
            return;
        }
        String sessionId = authSession.getAuthNote("firebase_session_id");
        if (sessionId != null) {
            String status = authSession.getAuthNote("firebase.status");
            if ("verified".equals(status)) {
                logger.infof("Firebase MFA verification successful for user: %s", (Object)context.getUser().getUsername());
                authSession.removeAuthNote("firebase_session_id");
                authSession.removeAuthNote("firebase_root_session_id");
                authSession.removeAuthNote("firebase_tab_id");
                authSession.removeAuthNote("firebase.correct_code");
                authSession.removeAuthNote("firebase.user_id");
                authSession.removeAuthNote("firebase.expires_at");
                authSession.removeAuthNote("firebase.status");
                authSession.removeAuthNote("firebase.verification_token");
                context.success();
                return;
            }
            if ("expired".equals(status)) {
                logger.warnf("Firebase MFA session expired for user: %s", (Object)context.getUser().getUsername());
                this.authenticate(context);
                return;
            }
            logger.debugf("Firebase MFA not yet verified for session: %s, status: %s", (Object)sessionId, (Object)status);
            Response challenge = context.form().setAttribute("verificationCode", (Object)authSession.getAuthNote("firebase.correct_code")).setAttribute("sessionId", (Object)sessionId).createForm(TPL_FIREBASE_LOGIN);
            context.challenge(challenge);
            return;
        }
        logger.error((Object)"action() called but no Firebase session found in auth notes");
        context.failure(AuthenticationFlowError.INTERNAL_ERROR);
    }

    public boolean requiresUser() {
        return true;
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return true;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    public void close() {
    }

    public String getType(KeycloakSession session) {
        return "firebase-auth";
    }

    public FirebaseAuthCredentialProvider getCredentialProvider(KeycloakSession session) {
        return (FirebaseAuthCredentialProvider)session.getProvider(CredentialProvider.class, "firebase-auth");
    }
}

