/*
 * Decompiled with CFR 0.152.
 */
package hive.keycloak.authenticator;

import hive.keycloak.authenticator.FirebaseAuthenticator;
import java.util.List;
import org.keycloak.Config;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;

public class FirebaseAuthenticatorFactory
implements AuthenticatorFactory {
    public static final String PROVIDER_ID = "firebase-authenticator";
    private static final FirebaseAuthenticator SINGLETON = new FirebaseAuthenticator();
    private static final AuthenticationExecutionModel.Requirement[] REQUIREMENT_CHOICES = new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.REQUIRED, AuthenticationExecutionModel.Requirement.ALTERNATIVE, AuthenticationExecutionModel.Requirement.DISABLED};

    public String getId() {
        return PROVIDER_ID;
    }

    public Authenticator create(KeycloakSession session) {
        return SINGLETON;
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return REQUIREMENT_CHOICES;
    }

    public boolean isConfigurable() {
        return true;
    }

    public boolean isUserSetupAllowed() {
        return true;
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return List.of(new ProviderConfigProperty("serviceAccountJson", "Firebase Service Account JSON", "The JSON content of your Firebase service account file (contains project ID)", "Text", (Object)""), new ProviderConfigProperty("codeDigits", "Code Digits", "Number of digits in the verification code", "List", (Object)"2", new String[]{"1", "2", "3", "4", "5", "6"}), new ProviderConfigProperty("fakeCodesCount", "Fake Codes Count", "Number of fake codes to generate", "List", (Object)"3", new String[]{"1", "2", "3", "4", "5"}), new ProviderConfigProperty("sessionTimeoutSeconds", "Session Timeout (seconds)", "How long authentication sessions remain valid", "Integer", (Object)300), new ProviderConfigProperty("forceSecondFactor", "Force 2FA", "If 2FA authentication is not configured, the user is forced to setup Firebase Authentication", "boolean", (Object)false));
    }

    public String getHelpText() {
        return "Validates users with mobile device push notification, using Firebase services.";
    }

    public String getDisplayType() {
        return "Firebase Authentication (2FA)";
    }

    public String getReferenceCategory() {
        return "firebase-auth";
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }
}

