/*
 * Decompiled with CFR 0.152.
 */
package hive.keycloak.authenticator.credentials;

import hive.keycloak.authenticator.credentials.FirebaseAuthCredentialData;
import java.io.IOException;
import org.keycloak.common.util.Time;
import org.keycloak.credential.CredentialModel;
import org.keycloak.util.JsonSerialization;

public class FirebaseAuthCredentialModel
extends CredentialModel {
    public static final String TYPE = "firebase-auth";
    private final FirebaseAuthCredentialData firebaseAuthData;

    private FirebaseAuthCredentialModel(FirebaseAuthCredentialData firebaseAuthData) {
        this.firebaseAuthData = firebaseAuthData;
    }

    private FirebaseAuthCredentialModel(String fcmToken, String deviceId) {
        this.firebaseAuthData = new FirebaseAuthCredentialData(fcmToken, deviceId, Time.currentTimeMillis());
    }

    public static FirebaseAuthCredentialModel createFromModel(CredentialModel credentialModel) {
        try {
            FirebaseAuthCredentialData credentialData = (FirebaseAuthCredentialData)JsonSerialization.readValue((String)credentialModel.getCredentialData(), FirebaseAuthCredentialData.class);
            FirebaseAuthCredentialModel firebaseAuthModel = new FirebaseAuthCredentialModel(credentialData);
            firebaseAuthModel.setUserLabel("Firebase Push Notification: " + credentialData.getDeviceId());
            firebaseAuthModel.setCreatedDate(credentialModel.getCreatedDate());
            firebaseAuthModel.setType(TYPE);
            firebaseAuthModel.setId(credentialModel.getId());
            firebaseAuthModel.setCredentialData(credentialModel.getCredentialData());
            return firebaseAuthModel;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static FirebaseAuthCredentialModel createFirebaseAuthenticator(String fcmToken, String deviceId) {
        FirebaseAuthCredentialModel credentialModel = new FirebaseAuthCredentialModel(fcmToken, deviceId);
        credentialModel.fillCredentialModelFields();
        return credentialModel;
    }

    public FirebaseAuthCredentialData getFirebaseAuthData() {
        return this.firebaseAuthData;
    }

    private void fillCredentialModelFields() {
        try {
            this.setCredentialData(JsonSerialization.writeValueAsString((Object)this.firebaseAuthData));
            this.setType(TYPE);
            this.setCreatedDate(Time.currentTimeMillis());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

