/*
 * Decompiled with CFR 0.152.
 */
package hive.keycloak.authenticator.firebase;

import hive.keycloak.authenticator.firebase.FirebaseService;
import java.util.HashSet;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.timer.ScheduledTask;

public class FirebaseSessionCleanupTask
implements ScheduledTask {
    private static final Logger logger = Logger.getLogger(FirebaseSessionCleanupTask.class);

    public void run(KeycloakSession session) {
        try {
            session.realms().getRealmsStream().forEach(realm -> this.cleanupRealmSessions(session, (RealmModel)realm));
        }
        catch (Exception e) {
            logger.error((Object)"Error during Firebase session cleanup", (Throwable)e);
        }
    }

    private void cleanupRealmSessions(KeycloakSession session, RealmModel realm) {
        try {
            Map attributes = realm.getAttributes();
            HashSet<String> keysToRemove = new HashSet<String>();
            int totalMappings = 0;
            int expiredMappings = 0;
            for (Map.Entry entry : attributes.entrySet()) {
                String key = (String)entry.getKey();
                if (!key.startsWith("firebase_session_") && !key.startsWith("firebase_reg_session_")) continue;
                ++totalMappings;
                String sessionId = key.substring(key.indexOf("_session_") + 9);
                boolean isValid = false;
                if (key.startsWith("firebase_session_")) {
                    isValid = FirebaseService.hasValidSession(session, sessionId) || FirebaseService.isSessionVerified(session, sessionId);
                } else if (key.startsWith("firebase_reg_session_")) {
                    boolean bl = isValid = FirebaseService.hasValidRegistrationSession(session, sessionId) || FirebaseService.isRegistrationCompleted(session, sessionId);
                }
                if (isValid) continue;
                keysToRemove.add(key);
                ++expiredMappings;
            }
            for (String key : keysToRemove) {
                realm.removeAttribute(key);
            }
            if (expiredMappings > 0) {
                logger.infof("Firebase session cleanup completed for realm %s: removed %d expired mappings out of %d total", (Object)realm.getName(), (Object)expiredMappings, (Object)totalMappings);
            } else {
                logger.debugf("Firebase session cleanup completed for realm %s: no expired mappings found out of %d total", (Object)realm.getName(), (Object)totalMappings);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error during Firebase session cleanup", (Throwable)e);
        }
    }
}

