/*
 * Decompiled with CFR 0.152.
 */
package hive.keycloak.authenticator.rest;

import hive.keycloak.authenticator.firebase.FirebaseService;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;

@Path(value="/")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class FirebaseAuthResource {
    private static final Logger logger = Logger.getLogger(FirebaseAuthResource.class);
    private final KeycloakSession session;

    public FirebaseAuthResource(KeycloakSession session) {
        this.session = session;
    }

    @POST
    @Path(value="verify")
    public Response verifyCode(Map<String, String> payload) {
        try {
            String sessionId = payload.get("session_id");
            String selectedCode = payload.get("selected_code");
            String verificationToken = payload.get("verification_token");
            if (sessionId == null || sessionId.trim().isEmpty()) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(this.createErrorResponse("missing_session_id", "Session ID is required")).build();
            }
            if (selectedCode == null || selectedCode.trim().isEmpty()) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(this.createErrorResponse("missing_code", "Selected code is required")).build();
            }
            if (verificationToken == null || verificationToken.trim().isEmpty()) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(this.createErrorResponse("missing_verification_token", "Verification token is required")).build();
            }
            boolean isValid = FirebaseService.verifyAuthCode(this.session, sessionId, selectedCode, verificationToken);
            HashMap<String, Object> response = new HashMap<String, Object>();
            if (isValid) {
                response.put("success", true);
                response.put("message", "Verification successful");
                logger.infof("Verification successful for session: %s", (Object)sessionId);
                return Response.ok(response).build();
            }
            response.put("success", false);
            response.put("message", "Invalid or expired verification code");
            logger.infof("Verification failed for session: %s", (Object)sessionId);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(response).build();
        }
        catch (Exception e) {
            logger.error((Object)"Error verifying code", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(this.createErrorResponse("internal_error", "Failed to verify code")).build();
        }
    }

    @GET
    @Path(value="session/{sessionId}/status")
    public Response getSessionStatus(@PathParam(value="sessionId") String sessionId) {
        try {
            String status;
            if (sessionId == null || sessionId.trim().isEmpty()) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(this.createErrorResponse("missing_session_id", "Session ID is required")).build();
            }
            HashMap<String, Object> response = new HashMap<String, Object>();
            boolean fcmTokenRegistered = false;
            boolean isRegistrationSession = FirebaseService.hasValidRegistrationSession(this.session, sessionId);
            if (isRegistrationSession) {
                String userId = FirebaseService.getUserIdFromRegistrationSession(this.session, sessionId);
                if (userId != null) {
                    boolean registrationCompleted = FirebaseService.isRegistrationCompleted(this.session, sessionId);
                    if (registrationCompleted) {
                        status = "fcm_registered";
                        fcmTokenRegistered = true;
                        logger.debugf("Force 2FA registration completed for session: %s", (Object)sessionId);
                    } else {
                        status = "pending";
                        logger.debugf("Force 2FA registration pending for session: %s", (Object)sessionId);
                    }
                } else {
                    status = "expired";
                }
            } else {
                boolean authSessionExists = FirebaseService.hasValidSession(this.session, sessionId);
                if (authSessionExists) {
                    status = "pending";
                    logger.debugf("Standard MFA session pending for session: %s", (Object)sessionId);
                } else if (FirebaseService.isSessionVerified(this.session, sessionId)) {
                    status = "verified";
                    logger.debugf("Standard MFA session verified for session: %s", (Object)sessionId);
                } else {
                    status = "expired";
                    logger.debugf("Standard MFA session expired/invalid for session: %s", (Object)sessionId);
                }
            }
            response.put("session_id", sessionId);
            response.put("status", status);
            response.put("fcm_token_registered", fcmTokenRegistered);
            response.put("timestamp", System.currentTimeMillis());
            logger.debugf("Session status check for %s: %s", (Object)sessionId, (Object)status);
            return Response.ok(response).build();
        }
        catch (Exception e) {
            logger.error((Object)"Error checking session status", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(this.createErrorResponse("internal_error", "Failed to check session status")).build();
        }
    }

    private Map<String, String> createErrorResponse(String error, String description) {
        HashMap<String, String> errorResponse = new HashMap<String, String>();
        errorResponse.put("error", error);
        errorResponse.put("error_description", description);
        return errorResponse;
    }
}

