/*
 * Decompiled with CFR 0.152.
 */
package hive.keycloak.authenticator.rest;

import hive.keycloak.authenticator.firebase.FirebaseSessionCleanupTask;
import hive.keycloak.authenticator.rest.FirebaseAuthResourceProvider;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.services.resource.RealmResourceProvider;
import org.keycloak.services.resource.RealmResourceProviderFactory;
import org.keycloak.timer.ScheduledTask;
import org.keycloak.timer.TimerProvider;

public class FirebaseAuthResourceProviderFactory
implements RealmResourceProviderFactory {
    private static final Logger logger = Logger.getLogger(FirebaseAuthResourceProviderFactory.class);
    public static final String PROVIDER_ID = "firebase-auth";
    private static final long CLEANUP_INTERVAL_MS = 300000L;
    private static final String CLEANUP_TASK_ID = "firebase-session-cleanup";

    public String getId() {
        return PROVIDER_ID;
    }

    public RealmResourceProvider create(KeycloakSession session) {
        return new FirebaseAuthResourceProvider(session);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
        this.scheduleCleanupTask(factory);
    }

    public void close() {
        this.cancelCleanupTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleCleanupTask(KeycloakSessionFactory factory) {
        try (KeycloakSession session = factory.create();){
            TimerProvider timer = (TimerProvider)session.getProvider(TimerProvider.class);
            if (timer != null) {
                timer.cancelTask(CLEANUP_TASK_ID);
                timer.scheduleTask((ScheduledTask)new FirebaseSessionCleanupTask(), 300000L, CLEANUP_TASK_ID);
                logger.info((Object)"Firebase session cleanup task scheduled to run every 5 minutes");
            } else {
                logger.warn((Object)"TimerProvider not available - Firebase session cleanup task not scheduled");
            }
        }
    }

    private void cancelCleanupTask() {
        logger.info((Object)"Firebase auth provider closing - cleanup task will be cancelled by Keycloak");
    }
}

