/*
 * Decompiled with CFR 0.152.
 */
package hive.keycloak.authenticator.rest;

import hive.keycloak.authenticator.FirebaseAuthCredentialProvider;
import hive.keycloak.authenticator.credentials.FirebaseAuthCredentialData;
import hive.keycloak.authenticator.credentials.FirebaseAuthCredentialModel;
import hive.keycloak.authenticator.firebase.FirebaseService;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.jboss.logging.Logger;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.util.JsonSerialization;

@Path(value="/")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class FirebaseTokenResource {
    private static final Logger logger = Logger.getLogger(FirebaseTokenResource.class);
    private final KeycloakSession session;

    public FirebaseTokenResource(KeycloakSession session) {
        this.session = session;
    }

    @POST
    @Path(value="register")
    public Response registerToken(Map<String, String> payload) {
        try {
            UserModel user;
            RealmModel realm = this.session.getContext().getRealm();
            String fcmToken = payload.get("fcm_token");
            String sessionId = payload.get("session_id");
            String deviceId = payload.get("device_id");
            String verificationToken = payload.get("verification_token");
            boolean isForce2FA = false;
            if (sessionId != null && !sessionId.trim().isEmpty()) {
                if (verificationToken == null || verificationToken.trim().isEmpty()) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(this.createErrorResponse("missing_verification_token", "Verification token is required for Force 2FA registration")).build();
                }
                user = this.authenticateViaSession(sessionId, verificationToken, realm);
                if (user == null) {
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity(this.createErrorResponse("invalid_session", "Invalid session ID or verification token")).build();
                }
                isForce2FA = true;
                logger.infof("Force 2FA registration attempt for session: %s, user: %s", (Object)sessionId, (Object)user.getUsername());
            } else {
                user = this.authenticateViaBearer(realm);
                if (user == null) {
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity(this.createErrorResponse("unauthorized", "Authentication required")).build();
                }
                logger.infof("Standard FCM token registration attempt for user: %s", (Object)user.getUsername());
            }
            if (fcmToken == null || fcmToken.trim().isEmpty()) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(this.createErrorResponse("missing_fcm_token", "FCM token is required")).build();
            }
            if (deviceId == null || deviceId.trim().isEmpty()) {
                deviceId = UUID.randomUUID().toString();
            }
            FirebaseAuthCredentialProvider provider = (FirebaseAuthCredentialProvider)this.session.getProvider(CredentialProvider.class, "firebase-auth");
            user.credentialManager().getStoredCredentialsByTypeStream("firebase-auth").forEach(credential -> provider.deleteCredential(realm, user, credential.getId()));
            provider.createCredential(realm, user, FirebaseAuthCredentialModel.createFirebaseAuthenticator(fcmToken, deviceId));
            logger.infof("FCM token registered successfully for user: %s, device: %s", (Object)user.getUsername(), (Object)deviceId);
            if (isForce2FA) {
                boolean registrationCompleted = FirebaseService.completeRegistration(this.session, sessionId);
                if (registrationCompleted) {
                    logger.infof("Force 2FA registration completed for session: %s, user: %s", (Object)sessionId, (Object)user.getUsername());
                } else {
                    logger.warnf("Failed to complete Force 2FA registration for session: %s", (Object)sessionId);
                }
            }
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", isForce2FA ? "Force 2FA registration completed successfully" : "FCM token registered successfully");
            response.put("device_id", deviceId);
            if (isForce2FA) {
                response.put("force_2fa_completed", true);
            }
            return Response.ok(response).build();
        }
        catch (Exception e) {
            logger.error((Object)"Error registering FCM token", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(this.createErrorResponse("internal_error", "Failed to register FCM token")).build();
        }
    }

    @POST
    @Path(value="clear")
    public Response clearToken() {
        try {
            boolean credentialsRemoved;
            RealmModel realm = this.session.getContext().getRealm();
            UserModel user = this.authenticateViaBearer(realm);
            if (user == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity(this.createErrorResponse("unauthorized", "Authentication required")).build();
            }
            FirebaseAuthCredentialProvider provider = (FirebaseAuthCredentialProvider)this.session.getProvider(CredentialProvider.class, "firebase-auth");
            boolean bl = credentialsRemoved = user.credentialManager().getStoredCredentialsByTypeStream("firebase-auth").peek(credential -> provider.deleteCredential(realm, user, credential.getId())).count() > 0L;
            if (!credentialsRemoved) {
                HashMap<String, Object> response = new HashMap<String, Object>();
                response.put("success", true);
                response.put("message", "No FCM token found for this user - already cleared");
                response.put("user_id", user.getId());
                response.put("username", user.getUsername());
                response.put("already_cleared", true);
                return Response.status((int)208).entity(response).build();
            }
            logger.infof("FCM token cleared successfully for user: %s", (Object)user.getUsername());
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "FCM token cleared successfully");
            response.put("user_id", user.getId());
            response.put("username", user.getUsername());
            return Response.ok(response).build();
        }
        catch (Exception e) {
            logger.error((Object)"Error clearing FCM token", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(this.createErrorResponse("internal_error", "Failed to clear FCM token")).build();
        }
    }

    @GET
    @Path(value="status")
    public Response getTokenStatus() {
        try {
            RealmModel realm = this.session.getContext().getRealm();
            AuthenticationManager.AuthResult authResult = new AppAuthManager.BearerTokenAuthenticator(this.session).setRealm(realm).setConnection(this.session.getContext().getConnection()).setHeaders(this.session.getContext().getRequestHeaders()).authenticate();
            if (authResult == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity(this.createErrorResponse("unauthorized", "Authentication required")).build();
            }
            UserModel user = authResult.getUser();
            Optional credential = user.credentialManager().getStoredCredentialsByTypeStream("firebase-auth").findFirst();
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("has_fcm_token", credential.isPresent());
            response.put("user_id", user.getId());
            response.put("username", user.getUsername());
            if (credential.isPresent()) {
                try {
                    FirebaseAuthCredentialData credentialData = (FirebaseAuthCredentialData)JsonSerialization.readValue((String)((CredentialModel)credential.get()).getCredentialData(), FirebaseAuthCredentialData.class);
                    response.put("device_id", credentialData.getDeviceId());
                    response.put("last_updated", credentialData.getLastUpdated());
                }
                catch (IOException e) {
                    logger.warn((Object)("Error parsing Firebase credential data for user: " + user.getUsername()), (Throwable)e);
                }
            }
            return Response.ok(response).build();
        }
        catch (Exception e) {
            logger.error((Object)"Error checking FCM token status", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(this.createErrorResponse("internal_error", "Failed to check token status")).build();
        }
    }

    private UserModel authenticateViaBearer(RealmModel realm) {
        try {
            AuthenticationManager.AuthResult authResult = new AppAuthManager.BearerTokenAuthenticator(this.session).setRealm(realm).setConnection(this.session.getContext().getConnection()).setHeaders(this.session.getContext().getRequestHeaders()).authenticate();
            return authResult != null ? authResult.getUser() : null;
        }
        catch (Exception e) {
            logger.warn((Object)"Bearer token authentication failed", (Throwable)e);
            return null;
        }
    }

    private UserModel authenticateViaSession(String sessionId, String verificationToken, RealmModel realm) {
        try {
            if (!FirebaseService.hasValidRegistrationSession(this.session, sessionId)) {
                logger.warnf("Invalid or expired registration session: %s", (Object)sessionId);
                return null;
            }
            if (!FirebaseService.validateRegistrationToken(this.session, sessionId, verificationToken)) {
                logger.warnf("Invalid verification token for registration session: %s", (Object)sessionId);
                return null;
            }
            String userId = FirebaseService.getUserIdFromRegistrationSession(this.session, sessionId);
            if (userId == null) {
                logger.warnf("No user ID found for registration session: %s", (Object)sessionId);
                return null;
            }
            UserModel user = this.session.users().getUserById(realm, userId);
            if (user == null) {
                logger.warnf("User not found for ID: %s from session: %s", (Object)userId, (Object)sessionId);
                return null;
            }
            logger.debugf("Session-based authentication successful for user: %s, session: %s", (Object)user.getUsername(), (Object)sessionId);
            return user;
        }
        catch (Exception e) {
            logger.warn((Object)("Session-based authentication failed for session: " + sessionId), (Throwable)e);
            return null;
        }
    }

    private Map<String, String> createErrorResponse(String error, String description) {
        HashMap<String, String> errorResponse = new HashMap<String, String>();
        errorResponse.put("error", error);
        errorResponse.put("error_description", description);
        return errorResponse;
    }
}

