/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.protobuf.Any;
import io.grpc.Internal;
import io.grpc.InternalLogId;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.BackoffPolicy;
import io.grpc.internal.TimeProvider;
import io.grpc.xds.client.Bootstrapper;
import io.grpc.xds.client.ControlPlaneClient;
import io.grpc.xds.client.LoadReportClient;
import io.grpc.xds.client.LoadStatsManager2;
import io.grpc.xds.client.Locality;
import io.grpc.xds.client.MessagePrettyPrinter;
import io.grpc.xds.client.XdsClient;
import io.grpc.xds.client.XdsClientMetricReporter;
import io.grpc.xds.client.XdsLogger;
import io.grpc.xds.client.XdsResourceType;
import io.grpc.xds.client.XdsTransportFactory;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

@Internal
public final class XdsClientImpl
extends XdsClient
implements XdsClient.ResourceStore {
    @VisibleForTesting
    public static final int INITIAL_RESOURCE_FETCH_TIMEOUT_SEC = 15;
    private final SynchronizationContext syncContext = new SynchronizationContext(new Thread.UncaughtExceptionHandler(){

        @Override
        public void uncaughtException(Thread t2, Throwable e) {
            XdsClientImpl.this.logger.log(XdsLogger.XdsLogLevel.ERROR, "Uncaught exception in XdsClient SynchronizationContext. Panic!", e);
            throw new AssertionError((Object)e);
        }
    });
    private final Map<Bootstrapper.ServerInfo, LoadStatsManager2> loadStatsManagerMap = new HashMap<Bootstrapper.ServerInfo, LoadStatsManager2>();
    final Map<Bootstrapper.ServerInfo, LoadReportClient> serverLrsClientMap = new HashMap<Bootstrapper.ServerInfo, LoadReportClient>();
    private final Map<Bootstrapper.ServerInfo, ControlPlaneClient> serverCpClientMap = new HashMap<Bootstrapper.ServerInfo, ControlPlaneClient>();
    private final Map<XdsResourceType<? extends XdsClient.ResourceUpdate>, Map<String, ResourceSubscriber<? extends XdsClient.ResourceUpdate>>> resourceSubscribers = new HashMap<XdsResourceType<? extends XdsClient.ResourceUpdate>, Map<String, ResourceSubscriber<? extends XdsClient.ResourceUpdate>>>();
    private final Map<String, XdsResourceType<?>> subscribedResourceTypeUrls = new HashMap();
    private final XdsTransportFactory xdsTransportFactory;
    private final Bootstrapper.BootstrapInfo bootstrapInfo;
    private final ScheduledExecutorService timeService;
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private final Supplier<Stopwatch> stopwatchSupplier;
    private final TimeProvider timeProvider;
    private final Object securityConfig;
    private final InternalLogId logId;
    private final XdsLogger logger;
    private volatile boolean isShutdown;
    private final MessagePrettyPrinter messagePrinter;
    private final XdsClientMetricReporter metricReporter;

    public XdsClientImpl(XdsTransportFactory xdsTransportFactory, Bootstrapper.BootstrapInfo bootstrapInfo, ScheduledExecutorService timeService, BackoffPolicy.Provider backoffPolicyProvider, Supplier<Stopwatch> stopwatchSupplier, TimeProvider timeProvider, MessagePrettyPrinter messagePrinter, Object securityConfig, XdsClientMetricReporter metricReporter) {
        this.xdsTransportFactory = xdsTransportFactory;
        this.bootstrapInfo = bootstrapInfo;
        this.timeService = timeService;
        this.backoffPolicyProvider = backoffPolicyProvider;
        this.stopwatchSupplier = stopwatchSupplier;
        this.timeProvider = timeProvider;
        this.messagePrinter = messagePrinter;
        this.securityConfig = securityConfig;
        this.metricReporter = metricReporter;
        this.logId = InternalLogId.allocate("xds-client", null);
        this.logger = XdsLogger.withLogId(this.logId);
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created");
    }

    private void handleResourceResponse(XdsResourceType<?> xdsResourceType, Bootstrapper.ServerInfo serverInfo, String versionInfo, List<Any> resources, String nonce, XdsClient.ProcessingTracker processingTracker) {
        Preconditions.checkNotNull(xdsResourceType, "xdsResourceType");
        this.syncContext.throwIfNotInThisSynchronizationContext();
        Set<String> toParseResourceNames = xdsResourceType.shouldRetrieveResourceKeysForArgs() ? this.getResourceKeys(xdsResourceType) : null;
        XdsResourceType.Args args = new XdsResourceType.Args(serverInfo, versionInfo, nonce, this.bootstrapInfo, this.securityConfig, toParseResourceNames);
        this.handleResourceUpdate(args, resources, xdsResourceType, processingTracker);
    }

    private void handleStreamClosed(Status error, Bootstrapper.ServerInfo serverInfo) {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        this.cleanUpResourceTimers();
        if (!error.isOk()) {
            this.metricReporter.reportServerFailure(1L, serverInfo.target());
            for (Map<String, ResourceSubscriber<? extends XdsClient.ResourceUpdate>> subscriberMap : this.resourceSubscribers.values()) {
                for (ResourceSubscriber<? extends XdsClient.ResourceUpdate> subscriber : subscriberMap.values()) {
                    if (subscriber.hasResult()) continue;
                    subscriber.onError(error, null);
                }
            }
        }
    }

    private void handleStreamRestarted(Bootstrapper.ServerInfo serverInfo) {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        for (Map<String, ResourceSubscriber<? extends XdsClient.ResourceUpdate>> subscriberMap : this.resourceSubscribers.values()) {
            for (ResourceSubscriber<? extends XdsClient.ResourceUpdate> subscriber : subscriberMap.values()) {
                if (!((ResourceSubscriber)subscriber).serverInfo.equals(serverInfo)) continue;
                subscriber.restartTimer();
            }
        }
    }

    @Override
    public void shutdown() {
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                if (XdsClientImpl.this.isShutdown) {
                    return;
                }
                XdsClientImpl.this.isShutdown = true;
                for (ControlPlaneClient xdsChannel : XdsClientImpl.this.serverCpClientMap.values()) {
                    xdsChannel.shutdown();
                }
                for (LoadReportClient lrsClient : XdsClientImpl.this.serverLrsClientMap.values()) {
                    lrsClient.stopLoadReporting();
                }
                XdsClientImpl.this.cleanUpResourceTimers();
            }
        });
    }

    @Override
    public boolean isShutDown() {
        return this.isShutdown;
    }

    @Override
    public Map<String, XdsResourceType<?>> getSubscribedResourceTypesWithTypeUrl() {
        return Collections.unmodifiableMap(this.subscribedResourceTypeUrls);
    }

    @Override
    @Nullable
    public Collection<String> getSubscribedResources(Bootstrapper.ServerInfo serverInfo, XdsResourceType<? extends XdsClient.ResourceUpdate> type) {
        Map resources = this.resourceSubscribers.getOrDefault(type, Collections.emptyMap());
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String key : resources.keySet()) {
            if (!((ResourceSubscriber)resources.get(key)).serverInfo.equals(serverInfo)) continue;
            builder.add(key);
        }
        ImmutableCollection retVal = builder.build();
        return retVal.isEmpty() ? null : retVal;
    }

    @Override
    public ListenableFuture<Map<XdsResourceType<?>, Map<String, XdsClient.ResourceMetadata>>> getSubscribedResourcesMetadataSnapshot() {
        final SettableFuture<Map<XdsResourceType<?>, Map<String, XdsClient.ResourceMetadata>>> future = SettableFuture.create();
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                ImmutableMap.Builder metadataSnapshot = ImmutableMap.builder();
                for (XdsResourceType resourceType : XdsClientImpl.this.resourceSubscribers.keySet()) {
                    ImmutableMap.Builder<String, XdsClient.ResourceMetadata> metadataMap = ImmutableMap.builder();
                    for (Map.Entry resourceEntry : ((Map)XdsClientImpl.this.resourceSubscribers.get(resourceType)).entrySet()) {
                        metadataMap.put((String)resourceEntry.getKey(), ((ResourceSubscriber)resourceEntry.getValue()).metadata);
                    }
                    metadataSnapshot.put(resourceType, metadataMap.buildOrThrow());
                }
                future.set(metadataSnapshot.buildOrThrow());
            }
        });
        return future;
    }

    @Override
    public Object getSecurityConfig() {
        return this.securityConfig;
    }

    @Override
    public <T extends XdsClient.ResourceUpdate> void watchXdsResource(final XdsResourceType<T> type, final String resourceName, final XdsClient.ResourceWatcher<T> watcher, final Executor watcherExecutor) {
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                ResourceSubscriber subscriber;
                if (!XdsClientImpl.this.resourceSubscribers.containsKey(type)) {
                    XdsClientImpl.this.resourceSubscribers.put(type, new HashMap());
                    XdsClientImpl.this.subscribedResourceTypeUrls.put(type.typeUrl(), type);
                }
                if ((subscriber = (ResourceSubscriber)((Map)XdsClientImpl.this.resourceSubscribers.get(type)).get(resourceName)) == null) {
                    XdsClientImpl.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Subscribe {0} resource {1}", type, resourceName);
                    subscriber = new ResourceSubscriber(type, resourceName);
                    ((Map)XdsClientImpl.this.resourceSubscribers.get(type)).put(resourceName, subscriber);
                    if (subscriber.controlPlaneClient != null) {
                        subscriber.controlPlaneClient.adjustResourceSubscription(type);
                    }
                }
                subscriber.addWatcher(watcher, watcherExecutor);
            }
        });
    }

    @Override
    public <T extends XdsClient.ResourceUpdate> void cancelXdsResourceWatch(final XdsResourceType<T> type, final String resourceName, final XdsClient.ResourceWatcher<T> watcher) {
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                ResourceSubscriber subscriber = (ResourceSubscriber)((Map)XdsClientImpl.this.resourceSubscribers.get(type)).get(resourceName);
                subscriber.removeWatcher(watcher);
                if (!subscriber.isWatched()) {
                    subscriber.cancelResourceWatch();
                    ((Map)XdsClientImpl.this.resourceSubscribers.get(type)).remove(resourceName);
                    if (subscriber.controlPlaneClient != null) {
                        subscriber.controlPlaneClient.adjustResourceSubscription(type);
                    }
                    if (((Map)XdsClientImpl.this.resourceSubscribers.get(type)).isEmpty()) {
                        XdsClientImpl.this.resourceSubscribers.remove(type);
                        XdsClientImpl.this.subscribedResourceTypeUrls.remove(type.typeUrl());
                    }
                }
            }
        });
    }

    @Override
    public LoadStatsManager2.ClusterDropStats addClusterDropStats(final Bootstrapper.ServerInfo serverInfo, String clusterName, @Nullable String edsServiceName) {
        LoadStatsManager2 loadStatsManager = this.loadStatsManagerMap.get(serverInfo);
        LoadStatsManager2.ClusterDropStats dropCounter = loadStatsManager.getClusterDropStats(clusterName, edsServiceName);
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                XdsClientImpl.this.serverLrsClientMap.get(serverInfo).startLoadReporting();
            }
        });
        return dropCounter;
    }

    @Override
    public LoadStatsManager2.ClusterLocalityStats addClusterLocalityStats(final Bootstrapper.ServerInfo serverInfo, String clusterName, @Nullable String edsServiceName, Locality locality) {
        LoadStatsManager2 loadStatsManager = this.loadStatsManagerMap.get(serverInfo);
        LoadStatsManager2.ClusterLocalityStats loadCounter = loadStatsManager.getClusterLocalityStats(clusterName, edsServiceName, locality);
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                XdsClientImpl.this.serverLrsClientMap.get(serverInfo).startLoadReporting();
            }
        });
        return loadCounter;
    }

    @Override
    public Bootstrapper.BootstrapInfo getBootstrapInfo() {
        return this.bootstrapInfo;
    }

    public String toString() {
        return this.logId.toString();
    }

    @Override
    protected void startSubscriberTimersIfNeeded(final Bootstrapper.ServerInfo serverInfo) {
        if (this.isShutDown()) {
            return;
        }
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                if (XdsClientImpl.this.isShutDown()) {
                    return;
                }
                for (Map subscriberMap : XdsClientImpl.this.resourceSubscribers.values()) {
                    for (ResourceSubscriber subscriber : subscriberMap.values()) {
                        if (!subscriber.serverInfo.equals(serverInfo) || subscriber.respTimer != null) continue;
                        subscriber.restartTimer();
                    }
                }
            }
        });
    }

    private Set<String> getResourceKeys(XdsResourceType<?> xdsResourceType) {
        if (!this.resourceSubscribers.containsKey(xdsResourceType)) {
            return null;
        }
        return this.resourceSubscribers.get(xdsResourceType).keySet();
    }

    private void cleanUpResourceTimers() {
        for (Map<String, ResourceSubscriber<? extends XdsClient.ResourceUpdate>> subscriberMap : this.resourceSubscribers.values()) {
            for (ResourceSubscriber<? extends XdsClient.ResourceUpdate> subscriber : subscriberMap.values()) {
                subscriber.stopTimer();
            }
        }
    }

    public ControlPlaneClient getOrCreateControlPlaneClient(final Bootstrapper.ServerInfo serverInfo) {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        if (this.serverCpClientMap.containsKey(serverInfo)) {
            return this.serverCpClientMap.get(serverInfo);
        }
        XdsTransportFactory.XdsTransport xdsTransport = this.xdsTransportFactory.create(serverInfo);
        ControlPlaneClient controlPlaneClient = new ControlPlaneClient(xdsTransport, serverInfo, this.bootstrapInfo.node(), new XdsClient.XdsResponseHandler(){

            @Override
            public void handleResourceResponse(XdsResourceType<?> resourceType, Bootstrapper.ServerInfo serverInfo2, String versionInfo, List<Any> resources, String nonce, XdsClient.ProcessingTracker processingTracker) {
                XdsClientImpl.this.handleResourceResponse(resourceType, serverInfo2, versionInfo, resources, nonce, processingTracker);
            }

            @Override
            public void handleStreamClosed(Status error) {
                XdsClientImpl.this.handleStreamClosed(error, serverInfo);
            }

            @Override
            public void handleStreamRestarted(Bootstrapper.ServerInfo serverInfo2) {
                XdsClientImpl.this.handleStreamRestarted(serverInfo2);
            }
        }, this, this.timeService, this.syncContext, this.backoffPolicyProvider, this.stopwatchSupplier, this, this.messagePrinter);
        this.serverCpClientMap.put(serverInfo, controlPlaneClient);
        LoadStatsManager2 loadStatsManager = new LoadStatsManager2(this.stopwatchSupplier);
        this.loadStatsManagerMap.put(serverInfo, loadStatsManager);
        LoadReportClient lrsClient = new LoadReportClient(loadStatsManager, xdsTransport, this.bootstrapInfo.node(), this.syncContext, this.timeService, this.backoffPolicyProvider, this.stopwatchSupplier);
        this.serverLrsClientMap.put(serverInfo, lrsClient);
        return controlPlaneClient;
    }

    @Override
    @VisibleForTesting
    public Map<Bootstrapper.ServerInfo, LoadReportClient> getServerLrsClientMap() {
        return ImmutableMap.copyOf(this.serverLrsClientMap);
    }

    @Nullable
    private Bootstrapper.ServerInfo getServerInfo(String resource) {
        if (resource.startsWith("xdstp:")) {
            Bootstrapper.AuthorityInfo authorityInfo;
            URI uri = URI.create(resource);
            String authority = uri.getAuthority();
            if (authority == null) {
                authority = "";
            }
            if ((authorityInfo = this.bootstrapInfo.authorities().get(authority)) == null || authorityInfo.xdsServers().isEmpty()) {
                return null;
            }
            return (Bootstrapper.ServerInfo)authorityInfo.xdsServers().get(0);
        }
        return (Bootstrapper.ServerInfo)this.bootstrapInfo.servers().get(0);
    }

    private <T extends XdsClient.ResourceUpdate> void handleResourceUpdate(XdsResourceType.Args args, List<Any> resources, XdsResourceType<T> xdsResourceType, XdsClient.ProcessingTracker processingTracker) {
        XdsResourceType.ValidatedResourceUpdate<T> result = xdsResourceType.parse(args, resources);
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Received {0} Response version {1} nonce {2}. Parsed resources: {3}", xdsResourceType.typeName(), args.versionInfo, args.nonce, result.unpackedResources);
        Map parsedResources = result.parsedResources;
        Set<String> invalidResources = result.invalidResources;
        this.metricReporter.reportResourceUpdates(parsedResources.size(), invalidResources.size(), args.getServerInfo().target(), xdsResourceType.typeUrl());
        List<String> errors = result.errors;
        String errorDetail = null;
        if (errors.isEmpty()) {
            Preconditions.checkArgument(invalidResources.isEmpty(), "found invalid resources but missing errors");
            this.serverCpClientMap.get(args.serverInfo).ackResponse(xdsResourceType, args.versionInfo, args.nonce);
        } else {
            errorDetail = Joiner.on('\n').join(errors);
            this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Failed processing {0} Response version {1} nonce {2}. Errors:\n{3}", xdsResourceType.typeName(), args.versionInfo, args.nonce, errorDetail);
            this.serverCpClientMap.get(args.serverInfo).nackResponse(xdsResourceType, args.nonce, errorDetail);
        }
        long updateTime = this.timeProvider.currentTimeNanos();
        Map subscribedResources = this.resourceSubscribers.getOrDefault(xdsResourceType, Collections.emptyMap());
        for (Map.Entry entry : subscribedResources.entrySet()) {
            String resourceName = (String)entry.getKey();
            ResourceSubscriber subscriber = (ResourceSubscriber)entry.getValue();
            if (parsedResources.containsKey(resourceName)) {
                subscriber.onData(parsedResources.get(resourceName), args.versionInfo, updateTime, processingTracker);
                continue;
            }
            if (invalidResources.contains(resourceName)) {
                subscriber.onRejected(args.versionInfo, updateTime, errorDetail);
            }
            if (!xdsResourceType.isFullStateOfTheWorld()) continue;
            if (invalidResources.contains(resourceName)) {
                if (subscriber.data != null) continue;
                subscriber.onError(Status.UNAVAILABLE.withDescription(errorDetail), processingTracker);
                continue;
            }
            if (!subscriber.serverInfo.equals(args.serverInfo)) continue;
            subscriber.onAbsent(processingTracker);
        }
    }

    @Override
    public Future<Void> reportServerConnections(XdsClient.ServerConnectionCallback callback) {
        SettableFuture<Void> future = SettableFuture.create();
        this.syncContext.execute(() -> {
            this.serverCpClientMap.forEach((serverInfo, controlPlaneClient) -> callback.reportServerConnectionGauge(controlPlaneClient.hasWorkingAdsStream(), serverInfo.target()));
            future.set(null);
        });
        return future;
    }

    private final class ResourceSubscriber<T extends XdsClient.ResourceUpdate> {
        @Nullable
        private final Bootstrapper.ServerInfo serverInfo;
        @Nullable
        private final ControlPlaneClient controlPlaneClient;
        private final XdsResourceType<T> type;
        private final String resource;
        private final Map<XdsClient.ResourceWatcher<T>, Executor> watchers = new HashMap<XdsClient.ResourceWatcher<T>, Executor>();
        @Nullable
        private T data;
        private boolean absent;
        private boolean resourceDeletionIgnored;
        @Nullable
        private SynchronizationContext.ScheduledHandle respTimer;
        @Nullable
        private XdsClient.ResourceMetadata metadata;
        @Nullable
        private String errorDescription;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ResourceSubscriber(XdsResourceType<T> type, String resource) {
            XdsClientImpl.this.syncContext.throwIfNotInThisSynchronizationContext();
            this.type = type;
            this.resource = resource;
            this.serverInfo = XdsClientImpl.this.getServerInfo(resource);
            if (this.serverInfo == null) {
                this.errorDescription = "Wrong configuration: xds server does not exist for resource " + resource;
                this.controlPlaneClient = null;
                return;
            }
            this.metadata = XdsClient.ResourceMetadata.newResourceMetadataUnknown();
            ControlPlaneClient controlPlaneClient = null;
            try {
                controlPlaneClient = XdsClientImpl.this.getOrCreateControlPlaneClient(this.serverInfo);
                if (controlPlaneClient.isInBackoff()) {
                    return;
                }
            }
            catch (IllegalArgumentException e) {
                controlPlaneClient = null;
                this.errorDescription = "Bad configuration:  " + e.getMessage();
                return;
            }
            finally {
                this.controlPlaneClient = controlPlaneClient;
            }
            this.restartTimer();
        }

        void addWatcher(XdsClient.ResourceWatcher<T> watcher, Executor watcherExecutor) {
            Preconditions.checkArgument(!this.watchers.containsKey(watcher), "watcher %s already registered", watcher);
            this.watchers.put(watcher, watcherExecutor);
            T savedData = this.data;
            boolean savedAbsent = this.absent;
            watcherExecutor.execute(() -> {
                if (this.errorDescription != null) {
                    watcher.onError(Status.INVALID_ARGUMENT.withDescription(this.errorDescription));
                    return;
                }
                if (savedData != null) {
                    this.notifyWatcher(watcher, savedData);
                } else if (savedAbsent) {
                    watcher.onResourceDoesNotExist(this.resource);
                }
            });
        }

        void removeWatcher(XdsClient.ResourceWatcher<T> watcher) {
            Preconditions.checkArgument(this.watchers.containsKey(watcher), "watcher %s not registered", watcher);
            this.watchers.remove(watcher);
        }

        void restartTimer() {
            if (this.data != null || this.absent) {
                return;
            }
            if (!this.controlPlaneClient.isReady()) {
                return;
            }
            this.metadata = XdsClient.ResourceMetadata.newResourceMetadataRequested();
            class ResourceNotFound
            implements Runnable {
                ResourceNotFound() {
                }

                @Override
                public void run() {
                    XdsClientImpl.this.logger.log(XdsLogger.XdsLogLevel.INFO, "{0} resource {1} initial fetch timeout", ResourceSubscriber.this.type, ResourceSubscriber.this.resource);
                    ResourceSubscriber.this.respTimer = null;
                    ResourceSubscriber.this.onAbsent(null);
                }

                public String toString() {
                    return ResourceSubscriber.this.type + this.getClass().getSimpleName();
                }
            }
            this.respTimer = XdsClientImpl.this.syncContext.schedule(new ResourceNotFound(), 15L, TimeUnit.SECONDS, XdsClientImpl.this.timeService);
        }

        void stopTimer() {
            if (this.respTimer != null && this.respTimer.isPending()) {
                this.respTimer.cancel();
                this.respTimer = null;
            }
        }

        void cancelResourceWatch() {
            if (this.isWatched()) {
                throw new IllegalStateException("Can't cancel resource watch with active watchers present");
            }
            this.stopTimer();
            String message = "Unsubscribing {0} resource {1} from server {2}";
            XdsLogger.XdsLogLevel logLevel = XdsLogger.XdsLogLevel.INFO;
            if (this.resourceDeletionIgnored) {
                message = message + " for which we previously ignored a deletion";
                logLevel = XdsLogger.XdsLogLevel.FORCE_INFO;
            }
            XdsClientImpl.this.logger.log(logLevel, message, this.type, this.resource, this.serverInfo != null ? this.serverInfo.target() : "unknown");
        }

        boolean isWatched() {
            return !this.watchers.isEmpty();
        }

        boolean hasResult() {
            return this.data != null || this.absent;
        }

        void onData(XdsResourceType.ParsedResource<T> parsedResource, String version, long updateTime, XdsClient.ProcessingTracker processingTracker) {
            if (this.respTimer != null && this.respTimer.isPending()) {
                this.respTimer.cancel();
                this.respTimer = null;
            }
            T oldData = this.data;
            this.data = parsedResource.getResourceUpdate();
            this.metadata = XdsClient.ResourceMetadata.newResourceMetadataAcked(parsedResource.getRawResource(), version, updateTime);
            this.absent = false;
            if (this.resourceDeletionIgnored) {
                XdsClientImpl.this.logger.log(XdsLogger.XdsLogLevel.FORCE_INFO, "xds server {0}: server returned new version of resource for which we previously ignored a deletion: type {1} name {2}", this.serverInfo != null ? this.serverInfo.target() : "unknown", this.type, this.resource);
                this.resourceDeletionIgnored = false;
            }
            if (!Objects.equals(oldData, this.data)) {
                for (XdsClient.ResourceWatcher<T> watcher : this.watchers.keySet()) {
                    processingTracker.startTask();
                    this.watchers.get(watcher).execute(() -> {
                        try {
                            this.notifyWatcher(watcher, this.data);
                        }
                        finally {
                            processingTracker.onComplete();
                        }
                    });
                }
            }
        }

        void onAbsent(@Nullable XdsClient.ProcessingTracker processingTracker) {
            boolean ignoreResourceDeletionEnabled;
            if (this.respTimer != null && this.respTimer.isPending()) {
                return;
            }
            boolean bl = ignoreResourceDeletionEnabled = this.serverInfo != null && this.serverInfo.ignoreResourceDeletion();
            if (ignoreResourceDeletionEnabled && this.type.isFullStateOfTheWorld() && this.data != null) {
                if (!this.resourceDeletionIgnored) {
                    XdsClientImpl.this.logger.log(XdsLogger.XdsLogLevel.FORCE_WARNING, "xds server {0}: ignoring deletion for resource type {1} name {2}}", this.serverInfo.target(), this.type, this.resource);
                    this.resourceDeletionIgnored = true;
                }
                return;
            }
            XdsClientImpl.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Conclude {0} resource {1} not exist", this.type, this.resource);
            if (!this.absent) {
                this.data = null;
                this.absent = true;
                this.metadata = XdsClient.ResourceMetadata.newResourceMetadataDoesNotExist();
                for (XdsClient.ResourceWatcher<T> watcher : this.watchers.keySet()) {
                    if (processingTracker != null) {
                        processingTracker.startTask();
                    }
                    this.watchers.get(watcher).execute(() -> {
                        try {
                            watcher.onResourceDoesNotExist(this.resource);
                        }
                        finally {
                            if (processingTracker != null) {
                                processingTracker.onComplete();
                            }
                        }
                    });
                }
            }
        }

        void onError(Status error, @Nullable XdsClient.ProcessingTracker tracker) {
            if (this.respTimer != null && this.respTimer.isPending()) {
                this.respTimer.cancel();
                this.respTimer = null;
            }
            String description = error.getDescription() == null ? "" : error.getDescription() + " ";
            Status errorAugmented = Status.fromCode(error.getCode()).withDescription(description + "nodeID: " + XdsClientImpl.this.bootstrapInfo.node().getId()).withCause(error.getCause());
            for (XdsClient.ResourceWatcher watcher : this.watchers.keySet()) {
                if (tracker != null) {
                    tracker.startTask();
                }
                this.watchers.get(watcher).execute(() -> {
                    try {
                        watcher.onError(errorAugmented);
                    }
                    finally {
                        if (tracker != null) {
                            tracker.onComplete();
                        }
                    }
                });
            }
        }

        void onRejected(String rejectedVersion, long rejectedTime, String rejectedDetails) {
            this.metadata = XdsClient.ResourceMetadata.newResourceMetadataNacked(this.metadata, rejectedVersion, rejectedTime, rejectedDetails, this.data != null);
        }

        private void notifyWatcher(XdsClient.ResourceWatcher<T> watcher, T update) {
            watcher.onChanged(update);
        }
    }
}

