/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.grpc.v1_6;

import io.grpc.Status;
import io.opentelemetry.instrumentation.api.semconv.network.NetworkAttributesGetter;
import io.opentelemetry.instrumentation.api.semconv.network.ServerAttributesGetter;
import io.opentelemetry.instrumentation.grpc.v1_6.GrpcRequest;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.annotation.Nullable;

final class GrpcNetworkServerAttributesGetter
implements ServerAttributesGetter<GrpcRequest>,
NetworkAttributesGetter<GrpcRequest, Status> {
    GrpcNetworkServerAttributesGetter() {
    }

    @Override
    @Nullable
    public String getServerAddress(GrpcRequest grpcRequest) {
        return grpcRequest.getLogicalHost();
    }

    @Override
    public Integer getServerPort(GrpcRequest grpcRequest) {
        return grpcRequest.getLogicalPort();
    }

    @Override
    @Nullable
    public InetSocketAddress getNetworkLocalInetSocketAddress(GrpcRequest grpcRequest, @Nullable Status status) {
        return null;
    }

    @Override
    @Nullable
    public InetSocketAddress getNetworkPeerInetSocketAddress(GrpcRequest request, @Nullable Status status) {
        SocketAddress address = request.getPeerSocketAddress();
        if (address instanceof InetSocketAddress) {
            return (InetSocketAddress)address;
        }
        return null;
    }
}

