/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.grpc.v1_6;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.grpc.Status;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.instrumentation.api.incubator.semconv.rpc.RpcClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.incubator.semconv.rpc.RpcClientMetrics;
import io.opentelemetry.instrumentation.api.incubator.semconv.rpc.RpcServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.incubator.semconv.rpc.RpcServerMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.semconv.network.NetworkAttributesExtractor;
import io.opentelemetry.instrumentation.api.semconv.network.ServerAttributesExtractor;
import io.opentelemetry.instrumentation.grpc.v1_6.GrpcAttributesExtractor;
import io.opentelemetry.instrumentation.grpc.v1_6.GrpcNetworkServerAttributesGetter;
import io.opentelemetry.instrumentation.grpc.v1_6.GrpcRequest;
import io.opentelemetry.instrumentation.grpc.v1_6.GrpcRequestGetter;
import io.opentelemetry.instrumentation.grpc.v1_6.GrpcRpcAttributesGetter;
import io.opentelemetry.instrumentation.grpc.v1_6.GrpcSpanNameExtractor;
import io.opentelemetry.instrumentation.grpc.v1_6.GrpcSpanStatusExtractor;
import io.opentelemetry.instrumentation.grpc.v1_6.GrpcTelemetry;
import io.opentelemetry.instrumentation.grpc.v1_6.internal.GrpcClientNetworkAttributesGetter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class GrpcTelemetryBuilder {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.grpc-1.6";
    private static final AttributeKey<String> PEER_SERVICE = AttributeKey.stringKey("peer.service");
    private final OpenTelemetry openTelemetry;
    @Nullable
    private String peerService;
    private Function<SpanNameExtractor<GrpcRequest>, ? extends SpanNameExtractor<? super GrpcRequest>> clientSpanNameExtractorTransformer = Function.identity();
    private Function<SpanNameExtractor<GrpcRequest>, ? extends SpanNameExtractor<? super GrpcRequest>> serverSpanNameExtractorTransformer = Function.identity();
    private final List<AttributesExtractor<? super GrpcRequest, ? super Status>> additionalExtractors = new ArrayList<AttributesExtractor<? super GrpcRequest, ? super Status>>();
    private final List<AttributesExtractor<? super GrpcRequest, ? super Status>> additionalClientExtractors = new ArrayList<AttributesExtractor<? super GrpcRequest, ? super Status>>();
    private final List<AttributesExtractor<? super GrpcRequest, ? super Status>> additionalServerExtractors = new ArrayList<AttributesExtractor<? super GrpcRequest, ? super Status>>();
    private boolean captureExperimentalSpanAttributes;
    private List<String> capturedClientRequestMetadata = Collections.emptyList();
    private List<String> capturedServerRequestMetadata = Collections.emptyList();

    GrpcTelemetryBuilder(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    @CanIgnoreReturnValue
    public GrpcTelemetryBuilder addAttributeExtractor(AttributesExtractor<? super GrpcRequest, ? super Status> attributesExtractor) {
        this.additionalExtractors.add(attributesExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public GrpcTelemetryBuilder addClientAttributeExtractor(AttributesExtractor<? super GrpcRequest, ? super Status> attributesExtractor) {
        this.additionalClientExtractors.add(attributesExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public GrpcTelemetryBuilder addServerAttributeExtractor(AttributesExtractor<? super GrpcRequest, ? super Status> attributesExtractor) {
        this.additionalServerExtractors.add(attributesExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public GrpcTelemetryBuilder setClientSpanNameExtractor(Function<SpanNameExtractor<GrpcRequest>, ? extends SpanNameExtractor<? super GrpcRequest>> clientSpanNameExtractor) {
        this.clientSpanNameExtractorTransformer = clientSpanNameExtractor;
        return this;
    }

    @CanIgnoreReturnValue
    public GrpcTelemetryBuilder setServerSpanNameExtractor(Function<SpanNameExtractor<GrpcRequest>, ? extends SpanNameExtractor<? super GrpcRequest>> serverSpanNameExtractor) {
        this.serverSpanNameExtractorTransformer = serverSpanNameExtractor;
        return this;
    }

    @CanIgnoreReturnValue
    public GrpcTelemetryBuilder setPeerService(String peerService) {
        this.peerService = peerService;
        return this;
    }

    @CanIgnoreReturnValue
    public GrpcTelemetryBuilder setCaptureExperimentalSpanAttributes(boolean captureExperimentalSpanAttributes) {
        this.captureExperimentalSpanAttributes = captureExperimentalSpanAttributes;
        return this;
    }

    @CanIgnoreReturnValue
    public GrpcTelemetryBuilder setCapturedClientRequestMetadata(List<String> capturedClientRequestMetadata) {
        this.capturedClientRequestMetadata = capturedClientRequestMetadata;
        return this;
    }

    @CanIgnoreReturnValue
    public GrpcTelemetryBuilder setCapturedServerRequestMetadata(List<String> capturedServerRequestMetadata) {
        this.capturedServerRequestMetadata = capturedServerRequestMetadata;
        return this;
    }

    public GrpcTelemetry build() {
        GrpcSpanNameExtractor originalSpanNameExtractor = new GrpcSpanNameExtractor();
        SpanNameExtractor<? super GrpcRequest> clientSpanNameExtractor = this.clientSpanNameExtractorTransformer.apply(originalSpanNameExtractor);
        SpanNameExtractor<? super GrpcRequest> serverSpanNameExtractor = this.serverSpanNameExtractorTransformer.apply(originalSpanNameExtractor);
        InstrumenterBuilder<GrpcRequest, Status> clientInstrumenterBuilder = Instrumenter.builder(this.openTelemetry, INSTRUMENTATION_NAME, clientSpanNameExtractor);
        InstrumenterBuilder<GrpcRequest, Status> serverInstrumenterBuilder = Instrumenter.builder(this.openTelemetry, INSTRUMENTATION_NAME, serverSpanNameExtractor);
        GrpcClientNetworkAttributesGetter netClientAttributesGetter = new GrpcClientNetworkAttributesGetter();
        GrpcNetworkServerAttributesGetter netServerAttributesGetter = new GrpcNetworkServerAttributesGetter();
        GrpcRpcAttributesGetter rpcAttributesGetter = GrpcRpcAttributesGetter.INSTANCE;
        clientInstrumenterBuilder.setSpanStatusExtractor(GrpcSpanStatusExtractor.CLIENT).addAttributesExtractors(this.additionalExtractors).addAttributesExtractor(RpcClientAttributesExtractor.create(rpcAttributesGetter)).addAttributesExtractor(ServerAttributesExtractor.create(netClientAttributesGetter)).addAttributesExtractor(NetworkAttributesExtractor.create(netClientAttributesGetter)).addAttributesExtractors(this.additionalClientExtractors).addAttributesExtractor(new GrpcAttributesExtractor(GrpcRpcAttributesGetter.INSTANCE, this.capturedClientRequestMetadata)).addOperationMetrics(RpcClientMetrics.get());
        serverInstrumenterBuilder.setSpanStatusExtractor(GrpcSpanStatusExtractor.SERVER).addAttributesExtractors(this.additionalExtractors).addAttributesExtractor(RpcServerAttributesExtractor.create(rpcAttributesGetter)).addAttributesExtractor(ServerAttributesExtractor.create(netServerAttributesGetter)).addAttributesExtractor(NetworkAttributesExtractor.create(netServerAttributesGetter)).addAttributesExtractor(new GrpcAttributesExtractor(GrpcRpcAttributesGetter.INSTANCE, this.capturedServerRequestMetadata)).addAttributesExtractors(this.additionalServerExtractors).addOperationMetrics(RpcServerMetrics.get());
        if (this.peerService != null) {
            clientInstrumenterBuilder.addAttributesExtractor(AttributesExtractor.constant(PEER_SERVICE, this.peerService));
        }
        return new GrpcTelemetry(serverInstrumenterBuilder.buildServerInstrumenter(GrpcRequestGetter.INSTANCE), clientInstrumenterBuilder.buildInstrumenter(SpanKindExtractor.alwaysClient()), this.openTelemetry.getPropagators(), this.captureExperimentalSpanAttributes);
    }
}

