/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.grpc.v1_6;

import io.grpc.Contexts;
import io.grpc.ForwardingServerCall;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Grpc;
import io.grpc.InternalMetadata;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.grpc.v1_6.GrpcRequest;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

final class TracingServerInterceptor
implements ServerInterceptor {
    private static final AttributeKey<Long> MESSAGE_ID = AttributeKey.longKey("message.id");
    private static final AttributeKey<String> MESSAGE_TYPE = AttributeKey.stringKey("message.type");
    private static final String SENT = "SENT";
    private static final String RECEIVED = "RECEIVED";
    private static final AtomicLongFieldUpdater<TracingServerCall> MESSAGE_ID_UPDATER = AtomicLongFieldUpdater.newUpdater(TracingServerCall.class, "messageId");
    private static final Metadata.Key<String> AUTHORITY_KEY = InternalMetadata.keyOf(":authority", Metadata.ASCII_STRING_MARSHALLER);
    private final Instrumenter<GrpcRequest, Status> instrumenter;
    private final boolean captureExperimentalSpanAttributes;

    TracingServerInterceptor(Instrumenter<GrpcRequest, Status> instrumenter, boolean captureExperimentalSpanAttributes) {
        this.instrumenter = instrumenter;
        this.captureExperimentalSpanAttributes = captureExperimentalSpanAttributes;
    }

    public <REQUEST, RESPONSE> ServerCall.Listener<REQUEST> interceptCall(ServerCall<REQUEST, RESPONSE> call, Metadata headers, ServerCallHandler<REQUEST, RESPONSE> next) {
        String authority = call.getAuthority();
        if (authority == null && headers != null) {
            authority = headers.get(AUTHORITY_KEY);
        }
        GrpcRequest request = new GrpcRequest(call.getMethodDescriptor(), headers, call.getAttributes().get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR), authority);
        Context parentContext = Context.current();
        if (!this.instrumenter.shouldStart(parentContext, request)) {
            return next.startCall(call, headers);
        }
        Context context = this.instrumenter.start(parentContext, request);
        Scope ignored = context.makeCurrent();
        try {
            TracingServerCall.TracingServerCallListener tracingServerCallListener = new TracingServerCall<REQUEST, RESPONSE>(call, context, request).start(headers, next);
            if (ignored != null) {
                ignored.close();
            }
            return tracingServerCallListener;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                this.instrumenter.end(context, request, Status.UNKNOWN, e);
                throw e;
            }
        }
    }

    final class TracingServerCall<REQUEST, RESPONSE>
    extends ForwardingServerCall.SimpleForwardingServerCall<REQUEST, RESPONSE> {
        private final Context context;
        private final GrpcRequest request;
        private Status status;
        volatile long messageId;

        TracingServerCall(ServerCall<REQUEST, RESPONSE> delegate, Context context, GrpcRequest request) {
            super(delegate);
            this.context = context;
            this.request = request;
        }

        TracingServerCallListener start(Metadata headers, ServerCallHandler<REQUEST, RESPONSE> next) {
            return new TracingServerCallListener(Contexts.interceptCall(io.grpc.Context.current(), this, headers, next), this.context, this.request);
        }

        @Override
        public void sendMessage(RESPONSE message) {
            try (Scope ignored = this.context.makeCurrent();){
                super.sendMessage(message);
            }
            Span span = Span.fromContext(this.context);
            Attributes attributes = Attributes.of(MESSAGE_TYPE, TracingServerInterceptor.SENT, MESSAGE_ID, MESSAGE_ID_UPDATER.incrementAndGet(this));
            span.addEvent("message", attributes);
        }

        @Override
        public void close(Status status, Metadata trailers) {
            this.status = status;
            try {
                this.delegate().close(status, trailers);
            }
            catch (Throwable e) {
                TracingServerInterceptor.this.instrumenter.end(this.context, this.request, status, e);
                throw e;
            }
        }

        final class TracingServerCallListener
        extends ForwardingServerCallListener.SimpleForwardingServerCallListener<REQUEST> {
            private final Context context;
            private final GrpcRequest request;

            TracingServerCallListener(ServerCall.Listener<REQUEST> delegate, Context context, GrpcRequest request) {
                super(delegate);
                this.context = context;
                this.request = request;
            }

            @Override
            public void onMessage(REQUEST message) {
                Attributes attributes = Attributes.of(MESSAGE_TYPE, TracingServerInterceptor.RECEIVED, MESSAGE_ID, MESSAGE_ID_UPDATER.incrementAndGet(TracingServerCall.this));
                Span.fromContext(this.context).addEvent("message", attributes);
                this.delegate().onMessage(message);
            }

            @Override
            public void onHalfClose() {
                try {
                    this.delegate().onHalfClose();
                }
                catch (Throwable e) {
                    TracingServerInterceptor.this.instrumenter.end(this.context, this.request, Status.UNKNOWN, e);
                    throw e;
                }
            }

            @Override
            public void onCancel() {
                try {
                    this.delegate().onCancel();
                    if (TracingServerInterceptor.this.captureExperimentalSpanAttributes) {
                        Span.fromContext(this.context).setAttribute("grpc.canceled", true);
                    }
                }
                catch (Throwable e) {
                    TracingServerInterceptor.this.instrumenter.end(this.context, this.request, Status.UNKNOWN, e);
                    throw e;
                }
                TracingServerInterceptor.this.instrumenter.end(this.context, this.request, Status.CANCELLED, null);
            }

            @Override
            public void onComplete() {
                try {
                    this.delegate().onComplete();
                }
                catch (Throwable e) {
                    TracingServerInterceptor.this.instrumenter.end(this.context, this.request, Status.UNKNOWN, e);
                    throw e;
                }
                if (TracingServerCall.this.status == null) {
                    TracingServerCall.this.status = Status.UNKNOWN;
                }
                TracingServerInterceptor.this.instrumenter.end(this.context, this.request, TracingServerCall.this.status, TracingServerCall.this.status.getCause());
            }

            @Override
            public void onReady() {
                try {
                    this.delegate().onReady();
                }
                catch (Throwable e) {
                    TracingServerInterceptor.this.instrumenter.end(this.context, this.request, Status.UNKNOWN, e);
                    throw e;
                }
            }
        }
    }
}

