/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.grpc.v1_6.internal;

import io.grpc.Context;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.context.Scope;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ContextStorageBridge
extends Context.Storage {
    private static final Logger logger = Logger.getLogger(ContextStorageBridge.class.getName());
    private static final ContextKey<io.grpc.Context> GRPC_CONTEXT = ContextKey.named("grpc-context");
    private static final Context.Key<Context> OTEL_CONTEXT = io.grpc.Context.key("otel-context");
    private static final Context.Key<Scope> OTEL_SCOPE = io.grpc.Context.key("otel-scope");
    private static final Context.Key<io.grpc.Context> ORIGINAL_CONTEXT = io.grpc.Context.key("original-context");
    private static final Context.Key<io.grpc.Context> ORIGINAL_TO_RESTORE = io.grpc.Context.key("original-to-restore");
    private final boolean propagateGrpcDeadline;
    private final Context.Storage originalStorage;

    public ContextStorageBridge(boolean propagateGrpcDeadline) {
        this.propagateGrpcDeadline = propagateGrpcDeadline;
        this.originalStorage = null;
    }

    public ContextStorageBridge(Context.Storage originalStorage) {
        this.propagateGrpcDeadline = false;
        this.originalStorage = originalStorage;
    }

    @Override
    public io.grpc.Context doAttach(io.grpc.Context toAttach) {
        Context otelContext = Context.current();
        io.grpc.Context current = otelContext.get(GRPC_CONTEXT);
        if (current == null) {
            current = io.grpc.Context.ROOT;
        }
        if (current == toAttach) {
            io.grpc.Context result = current.withValue(OTEL_SCOPE, Scope.noop());
            result = this.attachOriginalContextStorage(result);
            return result;
        }
        Context base = OTEL_CONTEXT.get(toAttach);
        Context newOtelContext = base != null ? base.with(GRPC_CONTEXT, toAttach) : Context.current().with(GRPC_CONTEXT, toAttach);
        Scope scope = newOtelContext.makeCurrent();
        io.grpc.Context result = current.withValue(OTEL_SCOPE, scope);
        result = this.attachOriginalContextStorage(result);
        return result;
    }

    private io.grpc.Context attachOriginalContextStorage(io.grpc.Context context) {
        io.grpc.Context result = context;
        if (this.originalStorage != null) {
            io.grpc.Context originalToRestore = this.originalStorage.doAttach(result);
            result = result.withValues(ORIGINAL_CONTEXT, result, ORIGINAL_TO_RESTORE, originalToRestore);
        }
        return result;
    }

    @Override
    public void detach(io.grpc.Context toDetach, io.grpc.Context toRestore) {
        Scope scope;
        if (this.originalStorage != null) {
            io.grpc.Context originalContext = ORIGINAL_CONTEXT.get(toRestore);
            io.grpc.Context originalToRestore = ORIGINAL_TO_RESTORE.get(toRestore);
            this.originalStorage.detach(originalContext, originalToRestore);
        }
        if ((scope = OTEL_SCOPE.get(toRestore)) == null) {
            logger.log(Level.SEVERE, "Detaching context which was not attached.", new Throwable().fillInStackTrace());
        } else {
            scope.close();
        }
    }

    @Override
    public io.grpc.Context current() {
        Context otelContext = Context.current();
        io.grpc.Context current = otelContext.get(GRPC_CONTEXT);
        if (current == null) {
            return io.grpc.Context.ROOT.withValue(OTEL_CONTEXT, otelContext);
        }
        Context previousOtelContext = OTEL_CONTEXT.get(current);
        if (previousOtelContext != otelContext) {
            io.grpc.Context originalCurrent;
            if (!(this.propagateGrpcDeadline || this.originalStorage == null || (originalCurrent = this.originalStorage.current()) != null && originalCurrent != io.grpc.Context.ROOT)) {
                current = current.fork();
            }
            return current.withValue(OTEL_CONTEXT, otelContext);
        }
        return current;
    }
}

